/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.database.hibernate.query.SimpleQuery;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.StringType;

public class UserManager {
    public static Logger log = Logger.getLogger(UserManager.class);

    public static List<String> getAllUserPositionSymbols(String userId) throws CUFException, Exception {
        PositionFinder ps = FinderFactory.getPositionFinder();
        List positions = ps.findByUserName(userId, new String[0]);
        return (List)CollectionUtils.collect((Collection)positions, (Transformer)new BeanToPropertyValueTransformer("symbol"));
    }

    public static List<String> getAllUserPositionNames(String userId) throws CUFException, Exception {
        PositionFinder ps = FinderFactory.getPositionFinder();
        List positions = ps.findByUserName(userId, new String[0]);
        return (List)CollectionUtils.collect((Collection)positions, (Transformer)new BeanToPropertyValueTransformer("name"));
    }

    public static String getPositionIdForSymbol(String positionSymbol) throws CUFException, Exception {
        StructureService ss = ServiceFactory.getStructureService();
        Position p = ss.getPosition(positionSymbol, new String[0]);
        if (p == null) {
            return null;
        }
        return p.getId().toString();
    }

    public static List<String> getUsersWithRole(String roleId) throws CUFException, Exception {
        log.trace((Object)("************ getUsersWithRole(roleId=" + roleId + ") ************"));
        ArrayList<String> usersWithRole = null;
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            log.info((Object)("Pobieranie wszystkich uzytkownikow o roli " + roleId));
            usersWithRole = new ArrayList<String>();
            if (Tools.isNullOrEmpty((String)roleId)) {
                throw new CUFException("Nie podano identyfikatora roli");
            }
            Object query = "";
            HashMap<String, StringType> scalars = null;
            SimpleQuery simpleQuery = null;
            List resultList = null;
            query = "SELECT DISTINCT uptab.userid FROM pm_userposition as uptab JOIN pm_positionrole as rtab ON (uptab.positionid=rtab.positionid) where rtab.roleid = '" + roleId + "'";
            log.info((Object)("Zapytanie: " + (String)query));
            scalars = new HashMap<String, StringType>();
            scalars.put("userid", StandardBasicTypes.STRING);
            simpleQuery = new SimpleQuery((String)query, scalars);
            resultList = simpleQuery.list(0, 0);
            if (resultList != null && resultList.size() > 0) {
                for (Map oneResult : resultList) {
                    Object o = oneResult.get("userid");
                    String userId = "";
                    if (o == null || Tools.isNullOrEmpty((String)(userId = o.toString())) || !uga.doesUserExist(userId)) continue;
                    usersWithRole.add(userId);
                }
            }
            return usersWithRole;
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static void addUsersWithRoleToGroup(String roleId, String groupName, boolean bCreateGroup) throws CUFException, Exception {
        log.trace((Object)("************ addUsersWithRoleToGroup(roleId=" + roleId + ", groupName=" + groupName + ", bCreateGroup=" + bCreateGroup + ") ************"));
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        List<String> usersWithRole = null;
        int iAdded = 0;
        int iNotAdded = 0;
        try {
            log.info((Object)"Dodawanie uzytkownikow o okreslonej roli do danej grupy");
            if (Tools.isNullOrEmpty((String)groupName)) {
                throw new CUFException("Nie podano nazwy grupy");
            }
            usersWithRole = UserManager.getUsersWithRole(roleId);
            if (usersWithRole == null || usersWithRole.size() == 0) {
                throw new CUFException("W systemie nie znaleziono uzytkownikow o roli " + roleId);
            }
            log.info((Object)("W systemie znaleziono " + usersWithRole.size() + " uzytkownikow o roli " + roleId));
            if (!uga.doesGroupExist(groupName)) {
                if (!bCreateGroup) {
                    throw new CUFException("Grupa o nazwie " + groupName + " nie istnieje w systemie");
                }
                log.info((Object)("Grupa o nazwie " + groupName + " nie istnieje w systemie. Tworzenie grupy"));
                uga.createGroup(groupName, groupName);
                log.info((Object)("Grupa o nazwie " + groupName + " utworzona w systemie"));
            } else {
                log.info((Object)("Grupa o nazwie " + groupName + " istnieje w systemie"));
            }
            for (String userId : usersWithRole) {
                if (uga.doesUserBelongToGroup(groupName, userId)) {
                    log.info((Object)("Uzytkownik o loginie " + userId + " nalezy juz do grupy " + groupName));
                    ++iNotAdded;
                    continue;
                }
                uga.addUserToGroup(groupName, userId);
                ++iAdded;
                log.info((Object)("Dodano uzytkownika o loginie " + userId + " do grupy " + groupName));
            }
            log.info((Object)("Ilosc dodanych uzytkownikow do grupy " + groupName + ": " + iAdded));
            log.info((Object)("Ilosc niedodanych uzytkownikow do grupy " + groupName + ": " + iNotAdded));
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static void deleteUsersWithRoleFromGroup(String roleId, String groupName, boolean bDeleteGroup) throws CUFException, Exception {
        log.trace((Object)("************ deleteUsersWithRoleFromGroup(roleId=" + roleId + ", groupName=" + groupName + ", bDeleteGroup=" + bDeleteGroup + ") ************"));
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        List<String> usersWithRole = null;
        int iDeleted = 0;
        int iNotDeleted = 0;
        String[] usersInGroup = null;
        try {
            log.info((Object)"Usuwanie uzytkownikow o okreslonej roli z danej grupy");
            if (Tools.isNullOrEmpty((String)groupName)) {
                throw new CUFException("Nie podano nazwy grupy");
            }
            if (!uga.doesGroupExist(groupName)) {
                throw new CUFException("Grupa o nazwie " + groupName + " nie istnieje w systemie");
            }
            usersWithRole = UserManager.getUsersWithRole(roleId);
            if (usersWithRole == null || usersWithRole.size() == 0) {
                throw new CUFException("W systemie nie znaleziono uzytkownikow o roli " + roleId);
            }
            log.info((Object)("W systemie znaleziono " + usersWithRole.size() + " uzytkownikow o roli " + roleId));
            for (String userId : usersWithRole) {
                if (!uga.doesUserBelongToGroup(groupName, userId)) {
                    log.info((Object)("Uzytkownik o loginie " + userId + " nie nalezy do grupy " + groupName));
                    ++iNotDeleted;
                    continue;
                }
                uga.removeUserFromGroup(groupName, userId);
                ++iDeleted;
                log.info((Object)("Usunieto uzytkownika o loginie " + userId + " z grupy " + groupName));
            }
            log.info((Object)("Ilosc usunietych uzytkownikow z grupy " + groupName + ": " + iDeleted));
            log.info((Object)("Ilosc nieusunietych uzytkownikow z grupy " + groupName + ": " + iNotDeleted));
            if (!bDeleteGroup) {
                return;
            }
            usersInGroup = uga.getAllUsers(groupName);
            if (usersInGroup == null || usersInGroup.length == 0) {
                log.info((Object)"Grupa jest pusta. Usuwanie grupy");
                uga.removeGroup(groupName);
                log.info((Object)("Usunieto z systemu grupe o nazwie " + groupName));
            }
        }
        catch (CUFException e) {
            log.warn((Object)e.getMessage());
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public static List<String> getGroupsForUser(String userId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            Object query = "select gt.groupid from usertable ut ";
            query = (String)query + "left join usergrouptable ugt on ugt.userid=ut.objectid ";
            query = (String)query + "left join grouptable gt on gt.objectid=ugt.groupid ";
            query = (String)query + " where ut.userid=:userid";
            NativeQuery sql = hs.createSQLQuery((String)query);
            sql.setParameter("userid", (Object)userId);
            List result = sql.list();
            tx.commit();
            List list = result;
            return list;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public void deleteUsers(List<String> userIds) throws BaseException {
        UserService us = ServiceFactory.getUserService();
        for (String userId : userIds) {
            us.deleteUser(userId);
        }
    }
}

