/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.io.office.model.writer;

import com.suncode.cuf.exception.CUFServiceException;
import com.suncode.cuf.io.office.model.writer.ResolvableValueWriter;
import com.suncode.cuf.io.office.model.writer.ValueWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ValueWriterResolver {
    private static ValueWriterResolver instance;
    private List<ResolvableValueWriter> writers = new ArrayList<ResolvableValueWriter>();

    private ValueWriterResolver() {
        Reflections reflections = new Reflections(ValueWriterResolver.class.getPackage().getName(), new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(ResolvableValueWriter.class);
        for (Class type : subTypes) {
            try {
                this.writers.add((ResolvableValueWriter)type.newInstance());
            }
            catch (Exception e) {
                throw new CUFServiceException("Can't create class: " + type, e);
            }
        }
        Collections.sort(this.writers, new Comparator<ResolvableValueWriter>(){

            @Override
            public int compare(ResolvableValueWriter r1, ResolvableValueWriter r2) {
                return r2.getPriority() - r1.getPriority();
            }
        });
    }

    public static ValueWriterResolver getInstance() {
        if (instance == null) {
            instance = new ValueWriterResolver();
        }
        return instance;
    }

    public ValueWriter resolve(Class<?> type) {
        for (ResolvableValueWriter writer : this.writers) {
            if (!writer.canResolveValue(type)) continue;
            return writer;
        }
        throw new CUFServiceException("Not supported cell type: " + type);
    }
}

