/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;

public class ImportDevices
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportDevices.class);

    @AdvancedTask(name="ImportDevicesFromXLS", description="ImportDevicesFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportDevicesFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ImportDevicesFromXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        DBManagement dbm = new DBManagement();
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Urz\u0105dzenia");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Urz\u0105dzenia w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < 3; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z urzadzeniami");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    String sDeviceName = sheet.getCell(((Integer)header.get("Nazwa urz\u0105dzenia")).intValue(), i).getContents();
                    String sPath = sheet.getCell(((Integer)header.get("\u015acie\u017cka")).intValue(), i).getContents();
                    String sSize = sheet.getCell(((Integer)header.get("Rozmiar [MB]")).intValue(), i).getContents();
                    Long lSize = new Long(-1L);
                    if (Tools.isNullOrEmpty((String)sDeviceName) || Tools.isNullOrEmpty((String)sPath) || Tools.isNullOrEmpty((String)sSize)) {
                        throw new CUFException("Brak danych dla urzadzenia w arkuszu w linii " + (i + 1));
                    }
                    if (ArchiveServices.DoesDeviceExist(sDeviceName)) {
                        throw new CUFException("Urzadzenie o nazwie " + sDeviceName + " istnieje juz w systemie");
                    }
                    File dir = new File(sPath = CUFTools.convertBackslashesToSlashes(sPath));
                    if (dir == null || !dir.exists()) {
                        throw new CUFException("Sciezka " + sPath + " dla urzadzenia o nazwie " + sDeviceName + " nie istnieje. Nalezy poprawic plik xls");
                    }
                    try {
                        lSize = Long.parseLong(sSize);
                        if (lSize <= 0L) {
                            throw new CUFException("Rozmiar dla urzadzenia o nazwie " + sDeviceName + " jest wartoscia ujemna");
                        }
                    }
                    catch (NumberFormatException e) {
                        taskLog.error((Object)e.getMessage());
                        throw new CUFException("Rozmiar dla urzadzenia o nazwie " + sDeviceName + " nie jest wartoscia liczbowa");
                    }
                    Device device = new Device();
                    device.setDeviceName(sDeviceName);
                    device.setDevicePath(sPath);
                    device.setDeviceSize(lSize);
                    device.setDeviceFreeSpace(lSize);
                    ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
                    as.createDevice(device);
                    long id = device.getId();
                    if (id == -1L) {
                        throw new CUFException("Blad podczas dodawania urzadzenia o nazwie " + sDeviceName + " do systemu");
                    }
                    log.info((Object)("Poprawnie dodano urzadzenie o nazwie " + sDeviceName + " do systemu"));
                    continue;
                }
                catch (CUFException e) {
                    taskLog.error((Object)e.getMessage());
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            log.info((Object)"Zakonczono import urzadzen");
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportDevicesFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

