/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.web.controller.archive;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.cuf.archive.DocumentHelper;
import com.suncode.cuf.web.dto.archive.DocumentUploadForm;
import com.suncode.cuf.web.dto.archive.DocumentUploadResult;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.AddDocumentResultMeta;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.exception.ServiceException;
import com.suncode.pwfl.web.util.JsonMessage;
import com.suncode.pwfl.web.util.SessionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"cuf/document"})
public class DocumentController {
    private static final Logger log = LoggerFactory.getLogger(DocumentController.class);
    @Autowired
    private DocumentHelper helper;
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassActionService documentClassActionService;

    @RequestMapping(value={"description/change"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonMessage changeDescription(@RequestParam Long fileId, @RequestParam String description) {
        log.info("Changing file description: fileId=[{}] description=[{}]", (Object)fileId, (Object)description);
        this.helper.changeDescription(fileId, description);
        return new JsonMessage();
    }

    @ResponseBody
    @Transactional
    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    public JsonMessage deleteDocuments(@RequestParam List<Long> fileIds) {
        log.info("Deleting documents: fileIds=[{}]", fileIds);
        if (CollectionUtils.isEmpty(fileIds)) {
            return new JsonMessage();
        }
        for (Long fileId : fileIds) {
            WfDocument document = this.documentService.getDocument(fileId);
            this.fileService.deleteFile(fileId);
            this.documentClassActionService.executeArchiveActions(document, DocumentEventTypes.DELETE_DOCUMENT_FROM_ARCHIVE);
        }
        return new JsonMessage();
    }

    @ResponseBody
    @Transactional
    @RequestMapping(value={"upload"}, method={RequestMethod.POST}, produces={"text/html;charset=UTF-8"})
    public String uploadDocument(DocumentUploadForm uploadForm) throws IOException {
        String userName = SessionUtils.getLoggedUserName();
        ArrayList<DocumentUploadResult> documentUploadResults = new ArrayList<DocumentUploadResult>();
        String[] fileNames = uploadForm.getFileNames();
        int index = -1;
        for (MultipartFile file : uploadForm.getFiles()) {
            InputStream is = file.getInputStream();
            DocumentDefinition fd = new DocumentDefinition();
            fd.setDocumentClassId(uploadForm.getDocumentClassId());
            if (fileNames == null || ++index >= fileNames.length || StringUtils.isBlank((CharSequence)fileNames[index])) {
                fd.setFileName(file.getOriginalFilename());
            } else {
                String extension = FilenameUtils.getExtension((String)file.getOriginalFilename());
                String customFileName = fileNames[index];
                int dLength = customFileName.length() - extension.length();
                if (dLength < 0) {
                    fd.setFileName(fileNames[index] + "." + extension);
                } else {
                    String customExtension = customFileName.substring(dLength);
                    if (customExtension.equalsIgnoreCase(extension)) {
                        fd.setFileName(fileNames[index]);
                    } else {
                        fd.setFileName(fileNames[index] + "." + extension);
                    }
                }
            }
            fd.setDescription(uploadForm.getDescription());
            fd.setUserName(userName);
            fd.setInputStream(is);
            fd.setProcessId(uploadForm.getProcessId());
            fd.setActivityId(uploadForm.getActivityId());
            fd.setIndexes(uploadForm.getIndexes());
            fd.setSaveAsNewVersion(uploadForm.isSaveAsNewVersion());
            AddDocumentResultMeta result = this.documentService.addDocumentWithMetaResult(fd);
            try {
                this.documentClassActionService.executeProcessActions(result.getDocument(), DocumentEventTypes.NEW_DOCUMENT_IN_PROCESS, fd.getProcessId(), fd.getActivityId(), result.getSavedAsNewVersion());
            }
            catch (ServiceException e) {
                ServiceFactory.getDocumentService().deleteDocument(result.getDocument());
                throw e;
            }
            WfFile wfFile = result.getDocument().getFile();
            DocumentUploadResult documentUploadResult = DocumentUploadResult.builder().id(wfFile.getId()).documentId(result.getDocument().getId()).description(wfFile.getDescription()).fileName(wfFile.getFileName()).systemFileName(wfFile.getSystemFileName()).fileDate(wfFile.getFileDate()).path(wfFile.getPath()).uploader(wfFile.getUploader()).size(wfFile.getSize()).fullPath(FilenameUtils.normalize((String)(wfFile.getPath() + "/" + wfFile.getSystemFileName()))).build();
            documentUploadResults.add(documentUploadResult);
        }
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(documentUploadResults);
    }
}

