/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.helper;

import com.suncode.cuf.io.office.model.CellValue;
import com.suncode.cuf.plannedtask.administration.structure.IStructureValidator;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.cuf.util.CUFFactory;
import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.user.DomainService;
import com.suncode.pwfl.util.exception.ServiceException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class StructureValidator
implements IStructureValidator {
    @Autowired
    private DomainService domainService;
    Set<String> usersExisting = new HashSet<String>();

    @Override
    public void validateStructure(StructureData data, String mode) {
        List<String> domainsExisting = this.domainService.getDomainList().stream().map(d -> d.getDomainName()).collect(Collectors.toList());
        int i = 1;
        try {
            for (Map<String, CellValue<String>> map : data.getPositions()) {
                this.checkRole(map);
                this.checkPositions(map);
                ++i;
            }
            i = 1;
            for (Map<String, CellValue<String>> map : data.getUsers()) {
                this.checkDomains(map, domainsExisting);
                this.checkUserId(map);
                this.checkGroups(map);
                ++i;
            }
            i = 1;
            for (Map<String, CellValue<String>> map : data.getOrgUnits()) {
                this.checkOrgUnits(map);
                ++i;
            }
        }
        catch (ServiceException e) {
            throw new ServiceException("Wiersz: " + i, (Throwable)e);
        }
    }

    private void checkGroups(Map<String, CellValue<String>> map) {
        String groups = this.readString(map.get("groups").getValue());
        if (StringUtils.isBlank((String)groups)) {
            String userId = this.readString(map.get("userName").getValue());
            throw new ServiceException("Nie podano grupy dla u\u017cytkownika: " + userId);
        }
    }

    private void checkUserId(Map<String, CellValue<String>> map) {
        String userId = this.readString(map.get("userName").getValue());
        if (StringUtils.isEmpty((String)userId)) {
            throw new ServiceException("Nazwa u\u017cytkownika nie mo\u017ce by\u0107 pusta.");
        }
    }

    private void checkPositions(Map<String, CellValue<String>> map) {
        String possym = this.readString(map.get("symbol").getValue());
        if (StringUtils.isBlank((String)possym)) {
            throw new ServiceException("Sybmol stanowiska nie mo\u017ce by\u0107 pusty.");
        }
        if (possym.contains(";")) {
            throw new ServiceException("Sybmol stanowiska nie mo\u017ce zawiera\u0107 znaku ';'.");
        }
    }

    private void checkOrgUnits(Map<String, CellValue<String>> map) {
        String orgU = this.readString(map.get("symbol").getValue());
        if (StringUtils.isBlank((String)orgU)) {
            throw new ServiceException("Sybmol jednostki organizacyjnej nie mo\u017ce by\u0107 pusty.");
        }
    }

    private void checkRole(Map<String, CellValue<String>> map) {
        String sRoles = this.readString(map.get("roles").getValue());
        if (!StringUtils.isEmpty((String)sRoles)) {
            String[] roles;
            for (String role : roles = sRoles.split(";")) {
                Role r = this.getRole(role);
                if (r != null) continue;
                throw new ServiceException("Rola o id: " + role + " nie istnieje w systemie.");
            }
        }
    }

    private Role getRole(String roleId) {
        return CUFFactory.getRoleHelper().getRole(roleId);
    }

    private void checkDomains(Map<String, CellValue<String>> map, List<String> domainsExisting) {
        String domain;
        String userName = map.get("userName").getValue();
        String[] splitted = userName.split("/");
        if (splitted.length == 2 && !domainsExisting.contains(domain = splitted[0])) {
            throw new ServiceException("Domena: \"" + domain + "\" nie istnieje w systemie");
        }
    }

    private String readString(Object object) {
        String s = object == null ? "" : object.toString();
        if (StringUtils.isEmpty((String)s)) {
            return "";
        }
        return s.trim();
    }
}

