/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.database.storage.DynamicTableStorageManager;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;

public class DynamicTableStorageGetAll
extends HttpServlet {
    public static Logger log = Logger.getLogger(DynamicTableStorageGetAll.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* DynamicTableStorageGetAll Servlet ****************************");
        PrintWriter printWriter = null;
        JsonStore jsonStore = null;
        GsonCustomUtils gsonCustomUtils = null;
        ArrayList records = null;
        boolean bSuccess = false;
        String answerMessage = "";
        UserGroupAdministration uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
        try {
            List<String> storagesNames;
            records = new ArrayList();
            String username = request.getParameter("username");
            String limitByUser = request.getParameter("limitByUser");
            boolean bLimitByUser = false;
            String tabTitle = request.getParameter("tabTitle");
            if (Tools.isNullOrEmpty((String)tabTitle)) {
                throw new CUFException("Tabela nie posiada tytu\u0142u. Nie mo\u017cna pobra\u0107 dla niej zestaw\u00f3w danych.");
            }
            if (bLimitByUser && Tools.isNullOrEmpty((String)username)) {
                throw new CUFException("Brak nazwy u\u017cytkownika. Nie mo\u017cna pobra\u0107 zestaw\u00f3w danych dla tabeli " + tabTitle + ".");
            }
            if (limitByUser != null) {
                bLimitByUser = Boolean.parseBoolean(limitByUser);
            }
            if ((storagesNames = DynamicTableStorageManager.getAllStoragesNames(bLimitByUser, username, tabTitle)) != null && storagesNames.size() > 0) {
                log.info((Object)("Znaleziono " + storagesNames.size() + " zestawow danych"));
                for (String storageName : storagesNames) {
                    if (bLimitByUser) {
                        HashMap<String, String> oneRecord = new HashMap<String, String>();
                        oneRecord.put("storageName", storageName);
                        oneRecord.put("owner", username);
                        oneRecord.put("ownerRealName", DynamicTableStorageGetAll.getOwnerRealName(uga, username));
                        int noOfRecords = DynamicTableStorageManager.getDynamicTableStorageNoOfRecords(storageName, username, tabTitle);
                        oneRecord.put("noOfRecords", String.valueOf(noOfRecords));
                        String defaultStorageName = DynamicTableStorageManager.getDefaultDynamicTableStorageNameForUser(username, tabTitle);
                        String defaultStorageValue = "false";
                        if (!Tools.isNullOrEmpty((String)defaultStorageName) && defaultStorageName.equals(storageName)) {
                            defaultStorageValue = "true";
                        }
                        oneRecord.put("isDefaultStorage", defaultStorageValue);
                        records.add(oneRecord);
                        continue;
                    }
                    List<String> owners = DynamicTableStorageManager.getDynamicTableStorageOwners(storageName, tabTitle);
                    for (String owner : owners) {
                        HashMap<String, String> oneRecord = new HashMap<String, String>();
                        oneRecord.put("storageName", storageName);
                        oneRecord.put("owner", owner);
                        oneRecord.put("ownerRealName", DynamicTableStorageGetAll.getOwnerRealName(uga, owner));
                        int noOfRecords = DynamicTableStorageManager.getDynamicTableStorageNoOfRecords(storageName, owner, tabTitle);
                        oneRecord.put("noOfRecords", String.valueOf(noOfRecords));
                        String defaultStorageName = DynamicTableStorageManager.getDefaultDynamicTableStorageNameForUser(owner, tabTitle);
                        String defaultStorageValue = "false";
                        if (!Tools.isNullOrEmpty((String)defaultStorageName) && defaultStorageName.equals(storageName)) {
                            defaultStorageValue = "true";
                        }
                        oneRecord.put("isDefaultStorage", defaultStorageValue);
                        records.add(oneRecord);
                    }
                }
            }
            bSuccess = true;
            answerMessage = "Pobrano zestawy danych dla tabeli " + tabTitle + ".";
            log.info((Object)("Pobrano zestawy danych dla tabeli " + tabTitle));
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn((Object)answerMessage);
        }
        catch (Exception e) {
            bSuccess = false;
            answerMessage = "B\u0142\u0105d odczytu zestaw\u00f3w danych.";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jsonStore = new JsonStore();
                jsonStore.setSuccess(Boolean.valueOf(bSuccess));
                jsonStore.setMessage(answerMessage);
                jsonStore.setRecords(records);
                gsonCustomUtils = new GsonCustomUtils();
                String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(sJsonData);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    private static String getOwnerRealName(UserGroupAdministration uga, String userId) throws Exception {
        String realName = "";
        if (!Tools.isNullOrEmpty((String)userId)) {
            if (uga.doesUserExist(userId)) {
                realName = uga.getUserRealName(userId);
                if (Tools.isNullOrEmpty((String)realName)) {
                    realName = userId + " (login)";
                }
            } else {
                realName = userId + " (login)";
            }
        } else {
            realName = "brak";
        }
        return realName;
    }
}

