/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.DocClassTable;
import com.plusmpm.database.IndexTable;
import com.plusmpm.util.DocumentData;
import com.plusmpm.util.Tools;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.util.SpringContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class UpdateDocumentIndexes
extends HttpServlet {
    public static Logger log = Logger.getLogger(UpdateDocumentIndexes.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* UpdateDocumentIndexes Servlet ****************************");
        PrintWriter printWriter = null;
        JSONObject jsObj = null;
        boolean bSuccess = false;
        DBManagement dbm = new DBManagement();
        String sDocumentId = "";
        try {
            String[] semicolonSplit;
            String sFileId = request.getParameter("fileId");
            String hmMapping = request.getParameter("hmMapping");
            try {
                Long.parseLong(sFileId);
            }
            catch (NumberFormatException e) {
                throw new CUFException("Podany identyfikator pliku nie jest wartoscia liczbowa");
            }
            if (Tools.isNullOrEmpty((String)hmMapping)) {
                throw new CUFException("Nie podano wartosci indeksow do aktualnienia");
            }
            String sDocClassName = ArchiveServices.GetDocClassNameForDocument(sFileId);
            DocClassTable docClassTable = dbm.getDocClassByName(sDocClassName);
            Long lDocClassId = docClassTable.getId();
            if (lDocClassId == null) {
                throw new CUFException("Klasa dokumentow o nazwie " + sDocClassName + " nie posiada identyfikatora");
            }
            HashMap<Long, Object> hmDocClassIndecies = new HashMap<Long, Object>();
            for (String oneSemicolonSplit : semicolonSplit = hmMapping.split(";")) {
                Long indexId;
                String[] equalSplit = oneSemicolonSplit.split("=");
                if (equalSplit.length == 1 || (indexId = ArchiveServices.GetIndexIdForDocClass(sDocClassName, equalSplit[0])) != null) continue;
                String indexValue = "";
                String[] testEqualSplit = oneSemicolonSplit.split("=", -1);
                for (int k = 1; k < testEqualSplit.length; ++k) {
                    indexValue = k < testEqualSplit.length - 1 ? indexValue + testEqualSplit[k] + "=" : indexValue + testEqualSplit[k];
                }
                IndexTable index = DBManagement.getIndex((String)indexId.toString());
                if (index == null) continue;
                if (index.getIndexType().compareToIgnoreCase("integer") == 0) {
                    Long LValue = new Long(indexValue);
                    hmDocClassIndecies.put(indexId, LValue);
                    continue;
                }
                if (index.getIndexType().compareToIgnoreCase("float") == 0) {
                    Float FValue = null;
                    String sVariableValue = indexValue.replaceAll("[\\\\]", "");
                    sVariableValue = sVariableValue.replaceAll("[,]", ".");
                    sVariableValue = sVariableValue.replaceAll("[ ]", "");
                    FValue = new Float(sVariableValue);
                    hmDocClassIndecies.put(indexId, FValue);
                    continue;
                }
                if (index.getIndexType().compareToIgnoreCase("date") == 0) {
                    Date DValue = null;
                    try {
                        String sDate = indexValue;
                        sDate = sDate.replaceAll("[\\\\]", "/");
                        sDate = sDate.replaceAll("[-]", "/");
                        sDate = sDate.replaceAll("[.]", "/");
                        long time = Date.parse(sDate);
                        DValue = new Date(time);
                    }
                    catch (Exception e) {
                        DValue = new Date(0L);
                    }
                    hmDocClassIndecies.put(indexId, DValue);
                    continue;
                }
                hmDocClassIndecies.put(indexId, indexValue);
            }
            DocumentData documentData = DBManagement.GetDocumentByFileId((String)lDocClassId.toString(), (String)sFileId);
            if (documentData == null) {
                throw new CUFException("Blad podczas pobierania idetyfikatora dokumentu o identyfikatorze pliku " + sFileId);
            }
            sDocumentId = String.valueOf(documentData.getLDocumentId());
            log.info((Object)("Id dokumkentu: " + sDocumentId));
            FileService fs = (FileService)SpringContext.getBean(FileService.class);
            fs.changeFileIndexes(new Long(sFileId), hmDocClassIndecies);
            bSuccess = true;
        }
        catch (CUFException e) {
            bSuccess = false;
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            bSuccess = false;
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jsObj = new JSONObject();
                jsObj.put("success", bSuccess);
                response.setContentType("text/html;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.println(jsObj.toString());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

