/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.extension;

import com.plusmpm.CUF.util.extension.ActivityState;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.dbspecific.NativeDatabase;
import com.plusmpm.database.hibernate.HibernateUtil;
import com.plusmpm.enhydra.shark.WfActivityManager;
import com.plusmpm.util.SharkFunctions;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfActivityIterator;
import org.enhydra.shark.api.client.wfmodel.WfAssignment;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfmodel.WfResource;
import org.enhydra.shark.api.client.wfservice.ExecutionAdministration;
import org.enhydra.shark.xpdl.elements.Activities;
import org.enhydra.shark.xpdl.elements.Activity;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;
import org.enhydra.shark.xpdl.elements.WorkflowProcesses;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class ActivityManager {
    private static Logger log = Logger.getLogger(ActivityManager.class);

    public void acceptActivity(String activityId, String processId, String userName, String acceptButtonActionName, Map<String, Object> contextMap, boolean ignoreOwnership) throws Throwable {
        Map ctx = SharkFunctions.getActivityContext((String)processId, (String)activityId);
        if (contextMap != null) {
            ctx.putAll(ctx);
        }
        SharkFunctions.setActivityContext((String)processId, (String)activityId, (Map)ctx);
        WfActivityManager wfActivityManager = new WfActivityManager(activityId, processId, userName, acceptButtonActionName);
        wfActivityManager.setIgnoreOwnership(ignoreOwnership);
        wfActivityManager.acceptActivity();
    }

    public void acceptActivity(String activityId, String userName, String acceptButtonActionName, Map<String, Object> contextMap, boolean ignoreOwnership) throws Throwable {
        String processId = this.getProcessIdByActivityId(activityId);
        if (processId != null || processId.isEmpty()) {
            throw new IllegalArgumentException("Zadanie o podanym activityId nie istnieje");
        }
        acceptButtonActionName = this.checkAcceptButtonAction(acceptButtonActionName, processId, activityId);
        List<String> users = this.getAssigments(processId, activityId);
        Long actState = this.getActivityState(activityId);
        this.acceptActivity(activityId, processId, userName, acceptButtonActionName, contextMap, ignoreOwnership);
    }

    public long getActivityState(String activityId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            SQLQuery sql = hs.createSQLQuery("select state from activities where id=:actId ");
            sql.addScalar("state", (Type)StandardBasicTypes.BIG_DECIMAL);
            sql.setString("actId", activityId);
            BigDecimal bi = (BigDecimal)sql.uniqueResult();
            tx.commit();
            if (bi != null) {
                long l = bi.longValue();
                return l;
            }
            long l = -1L;
            return l;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public List<String> getAssigments(String processId, String activityId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        ArrayList<String> users = new ArrayList();
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            String query = "select resourceid from assignmentstable where ";
            query = query + "activityid=:activityId and ";
            query = query + "activityprocessid=:processId  ";
            SQLQuery sql = hs.createSQLQuery(query);
            sql.addScalar("resourceid", (Type)StandardBasicTypes.STRING);
            sql.setString("activityId", activityId);
            sql.setString("processId", processId);
            users = sql.list();
            tx.commit();
            ArrayList<String> arrayList = users;
            return arrayList;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    private String checkAcceptButtonAction(String acceptButtonActionName, String processId, String activityId) {
        List<Map<String, Object>> buttons = ActivityManager.getButtonsFromActivity(processId, activityId);
        int buttonsCount = buttons.size();
        if (buttonsCount > 1 && (acceptButtonActionName == null || acceptButtonActionName.isEmpty())) {
            throw new IllegalArgumentException("W zadaniu zdefiniowano wi\u0119cej ni\u017c 1 przycisk. Nazwa akcji jest wymagana.");
        }
        if (buttonsCount == 1) {
            acceptButtonActionName = (String)buttons.get(0).get("actionName");
        } else if (buttonsCount == 0) {
            acceptButtonActionName = "";
        } else {
            log.warn((Object)"Nie obs\u0142u\u017cona akcja");
        }
        return acceptButtonActionName;
    }

    public List<Map<String, Object>> getOpenActivities(String processId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            SQLQuery sql = hs.createSQLQuery("select activitydefinitionid,process,processid,resourceid,state,performer,activated,accepted from activities where processid=:processId and state<1000006 ");
            sql.addScalar("activitydefinitionid", (Type)StandardBasicTypes.STRING);
            sql.addScalar("process", (Type)StandardBasicTypes.BIG_DECIMAL);
            sql.addScalar("processid", (Type)StandardBasicTypes.STRING);
            sql.addScalar("resourceid", (Type)StandardBasicTypes.STRING);
            sql.addScalar("state", (Type)StandardBasicTypes.BIG_DECIMAL);
            sql.addScalar("performer", (Type)StandardBasicTypes.STRING);
            sql.addScalar("activated", (Type)StandardBasicTypes.INTEGER);
            sql.addScalar("accepted", (Type)StandardBasicTypes.INTEGER);
            sql.setString("processId", processId);
            sql.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
            List list = sql.list();
            tx.commit();
            List list2 = list;
            return list2;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public String getLastOpenActivity(String processId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            SQLQuery sql = hs.createSQLQuery("select id from activities where processid=:processId and state<1000006 order by activated desc ");
            sql.addScalar("id", (Type)StandardBasicTypes.STRING);
            sql.setParameter("processId", (Object)processId);
            sql.setResultTransformer(CriteriaSpecification.ALIAS_TO_ENTITY_MAP);
            List list = sql.list();
            tx.commit();
            if (list.isEmpty()) {
                String string = null;
                return string;
            }
            String string = (String)((Map)list.get(0)).get("id");
            return string;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public List<String> getOpenActivityIdsFromProcess(String processId, String userId, String activityDefId) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        SharkTransaction st = null;
        try {
            String actDefId;
            String actId;
            WfActivity a;
            int i;
            st = Shark.getInstance().createTransaction();
            String username = Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername").replaceAll("[\"]", "");
            String password = SystemProperties.getPassword((DefinedSystemParameter)DefinedSystemParameter.ADMIN_PASSWORD);
            ExecutionAdministration ea = Shark.getInstance().getAdminInterface().getExecutionAdministration();
            ea.connect(st, username, password, "KlientTestowy", null);
            WfProcess wfProcess = ea.getProcess(st, processId);
            WfActivityIterator wai1 = wfProcess.get_activities_in_state(st, "open.running");
            int actCount1 = wai1.how_many(st);
            log.info((Object)("act_OPEN_RUNNING_COUNT: " + actCount1));
            WfActivityIterator wai2 = wfProcess.get_activities_in_state(st, "open.not_running.not_started");
            int actCount2 = wai2.how_many(st);
            log.info((Object)("act_OPEN_NOT_RUNNING_COUNT: " + actCount2));
            WfActivityIterator wai3 = wfProcess.get_activities_in_state(st, "open.not_running.suspended");
            int actCount3 = wai3.how_many(st);
            log.info((Object)("act_OPEN_SUSPENDED_COUNT: " + actCount3));
            for (i = 0; i < actCount1; ++i) {
                a = wai1.get_next_object(st);
                actId = a.key(st);
                actDefId = Shark.getInstance().getAdminInterface().getAdminMisc().getActivityDefinitionId(st, processId, actId);
                log.info((Object)("actDefId: " + actDefId));
                if (!actDefId.equalsIgnoreCase(activityDefId) || !this.isUserAssignendToActivity(userId, processId, actId) || ids.contains(actId)) continue;
                ids.add(actId);
            }
            for (i = 0; i < actCount2; ++i) {
                a = wai2.get_next_object(st);
                actId = a.key(st);
                actDefId = Shark.getInstance().getAdminInterface().getAdminMisc().getActivityDefinitionId(st, processId, actId);
                log.info((Object)("actDefId: " + actDefId));
                if (!actDefId.equalsIgnoreCase(activityDefId) || !this.isUserAssignendToActivity(userId, processId, actId) || ids.contains(actId)) continue;
                ids.add(a.key(st));
            }
            for (i = 0; i < actCount3; ++i) {
                a = wai3.get_next_object(st);
                actId = a.key(st);
                actDefId = Shark.getInstance().getAdminInterface().getAdminMisc().getActivityDefinitionId(st, processId, actId);
                log.info((Object)("actDefId: " + actDefId));
                if (!actDefId.equalsIgnoreCase(activityDefId) || !this.isUserAssignendToActivity(userId, processId, actId) || ids.contains(actId)) continue;
                ids.add(a.key(st));
            }
            ea.disconnect(st);
            st.commit();
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            Shark.getInstance().unlockProcesses(st);
            st.release();
        }
    }

    public boolean isUserAssignendToActivity(String userId, String processId, String activityId) throws Exception {
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            String query = "select count(*) from assignmentstable where ";
            query = query + "activityid=:activityId and ";
            query = query + "activityprocessid=:processId and ";
            query = query + "resourceid=:userId ";
            SQLQuery sql = hs.createSQLQuery(query);
            sql.setString("activityId", activityId);
            sql.setString("processId", processId);
            sql.setString("userId", userId);
            BigInteger count = (BigInteger)sql.uniqueResult();
            tx.commit();
            if (count.intValue() == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public List<String> getProcessIds(String processDefId) throws Exception {
        ArrayList<String> ids = new ArrayList();
        Session hs = null;
        Transaction tx = null;
        try {
            String idName = NativeDatabase.getSharkObjectIdColumnName();
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            String query = "select distinct p.id from processdefinitions pd ";
            query = query + "join processes p on p.processdefinition=pd." + idName + " ";
            query = query + "where pd.processdefinitionid=:processDefId and p.state<1000006 ";
            SQLQuery sql = hs.createSQLQuery(query);
            sql.addScalar("p.id", (Type)StandardBasicTypes.STRING);
            sql.setString("processDefId", processDefId);
            ids = sql.list();
            tx.commit();
            ArrayList<String> arrayList = ids;
            return arrayList;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public void acceptActivitiesFromProcess(String userId, String processDefId, String activityDefId, String actionName) throws Throwable {
        try {
            List<String> processIds = this.getProcessIds(processDefId);
            for (String procId : processIds) {
                log.info((Object)("procId: " + procId));
                List<String> actIds = this.getOpenActivityIdsFromProcess(procId, userId, activityDefId);
                for (String actId : actIds) {
                    log.info((Object)("Akceptuje dla actId: " + actId));
                    this.acceptActivity(actId, procId, userId, actionName, null, true);
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)e, e);
            throw e;
        }
    }

    public String getProcessIdByActivityId(String activityId) throws Exception {
        log.info((Object)"getProcessId**************************************");
        log.info((Object)("actId:" + activityId));
        Session hs = null;
        Transaction tx = null;
        String processId = null;
        try {
            log.info((Object)"przed pobraniem sessji");
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            log.info((Object)"pobralem sesje");
            tx = hs.beginTransaction();
            log.info((Object)"utworzylem transakcje");
            SQLQuery sql = hs.createSQLQuery("select processid from activities where id=:actId ");
            sql.addScalar("processid", (Type)StandardBasicTypes.STRING);
            sql.setString("actId", activityId);
            log.info((Object)"ustawilem parametry zapytania");
            List o = sql.list();
            log.info((Object)("pobralem obiekt: " + o));
            if (!o.isEmpty()) {
                processId = (String)o.get(0);
            }
            log.info((Object)("procId: " + processId));
            tx.commit();
            log.info((Object)"tx zakonczona");
            if (processId == null || processId.isEmpty()) {
                log.warn((Object)("There is no activity with activityId=" + activityId));
            }
            String string = processId;
            return string;
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                log.info((Object)"transakcja jest aktywna");
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public static List<Map<String, Object>> getButtonsFromActivity(String processId, String activityId) {
        ArrayList<Map<String, Object>> alAdditionalButtons = new ArrayList<Map<String, Object>>();
        try {
            String[][] ValName = Shark.getInstance().getAdminInterface().getAdminMisc().getActivitiesExtendedAttributeNameValuePairs(processId, activityId);
            for (int i = 0; i < ValName.length; ++i) {
                if (ValName[i][0].compareToIgnoreCase("ACTION_ACCEPT_BUTTON") != 0) continue;
                String sDefinition = ValName[i][1];
                log.info((Object)("ACTION_ACCEPT_BUTTON:" + sDefinition));
                String[] sLines = sDefinition.split("\n");
                String sButtonName = "";
                String sActionName = "";
                String jsAction = "";
                String checkForm = "";
                String confirmButton = "";
                String saveButton = "";
                String destination = "";
                HashMap<String, String[]> actions = new HashMap<String, String[]>();
                for (int p = 0; p < sLines.length; ++p) {
                    Object s;
                    String[] sLine = sLines[p].split("=");
                    if (sLine[0].compareToIgnoreCase("actionName") == 0) {
                        sActionName = sLine[1];
                        continue;
                    }
                    if (sLine[0].compareToIgnoreCase("buttonName") == 0) {
                        sButtonName = sLine[1];
                        continue;
                    }
                    if (sLine[0].compareToIgnoreCase("jsAction") == 0) {
                        jsAction = sLine[1];
                        continue;
                    }
                    if (sLine[0].compareToIgnoreCase("checkForm") == 0) {
                        checkForm = sLine[1];
                        continue;
                    }
                    if (sLine[0].compareToIgnoreCase("confirmButton") == 0) {
                        confirmButton = sLine[1];
                        continue;
                    }
                    if (sLine[0].compareToIgnoreCase("saveButton") == 0) {
                        saveButton = sLine[1];
                        continue;
                    }
                    if (sLine[0].compareToIgnoreCase("destination") == 0) {
                        destination = sLine[1];
                        continue;
                    }
                    if (sLine[0].startsWith("action")) {
                        s = new String[]{sLine[0], ""};
                        actions.put(sLine[0], (String[])s);
                        continue;
                    }
                    if (!sLine[0].startsWith("condition") || p <= 0 || !actions.containsKey(s = sLines[p - 1].split("=")[0])) continue;
                    ((String[])actions.get((Object)s))[1] = sLine[1];
                }
                HashMap<String, Object> button = new HashMap<String, Object>();
                button.put("actionName", sActionName);
                button.put("checkForm", checkForm);
                button.put("jsAction", jsAction);
                button.put("buttonName", sButtonName);
                button.put("confirmButton", confirmButton);
                button.put("saveButton", saveButton);
                button.put("destination", destination);
                button.put("actions", actions);
                alAdditionalButtons.add(button);
            }
            return alAdditionalButtons;
        }
        catch (BaseException e) {
            log.info((Object)e.getMessage());
            return null;
        }
    }

    public long openActivity(String userName, String password, String processId, String activityId) throws Exception {
        log.trace((Object)("***********************openActivity( userName=" + userName + ", processId=" + processId + ", " + activityId + ")*******************"));
        SharkTransaction sharkTransaction = null;
        ExecutionAdministration ea1 = Shark.getInstance().getAdminInterface().getExecutionAdministration();
        try {
            ea1.connect(userName, password, "KlientTestowy", null);
            WfResource newResourcer = ea1.getResource(userName);
            WfAssignment currentAssignment = null;
            currentAssignment = SharkFunctions.GetWfAssignment((ExecutionAdministration)ea1, (String)processId, (String)activityId, (String)userName);
            if (currentAssignment == null || !newResourcer.is_member_of_work_items(currentAssignment)) {
                log.info((Object)("U\u017cytkownik: " + userName + " nie mo\u017ce wykona\u0107 tego zadania"));
                throw new Exception("U\u017cytkownik: " + userName + " nie mo\u017ce wykona\u0107 tego zadania");
            }
            String sActivityState = currentAssignment.activity().state();
            if (sActivityState.compareTo("open.not_running.suspended") == 0) {
                log.warn((Object)("U\u017cytkownik: " + userName + " nie mo\u017ce wykona\u0107 tego zadania gdyz jest ono zawieszone"));
                throw new Exception("U\u017cytkownik: " + userName + " nie mo\u017ce wykona\u0107 tego zadania gdyz jest ono zawieszone");
            }
            String activityState = "";
            WfActivity currentActivity = null;
            try {
                currentActivity = currentAssignment.activity();
            }
            catch (Exception e) {
                log.info((Object)"zadanie zosta\u0142o ju\u017c wykonane");
                throw e;
            }
            if (!currentAssignment.get_accepted_status()) {
                activityState = currentActivity.state();
                log.info((Object)("Current state:" + activityState));
                if (activityState.compareToIgnoreCase("open.running") != 0) {
                    log.info((Object)"zmieniam stan na OPEN.");
                    for (int jj = 0; jj < 5; ++jj) {
                        try {
                            currentActivity.change_state("open.running");
                            break;
                        }
                        catch (Exception e) {
                            log.error((Object)"Error - ProcessActivityAction", (Throwable)e);
                            continue;
                        }
                    }
                    log.info((Object)"zmieniam stan na OPEN OK.");
                }
                DBManagement.SaveAcceptedTime((String)activityId, (boolean)true);
            } else {
                log.info((Object)"zadanie zosta\u0142o ju\u017c przetworzone");
                activityState = currentActivity.state(sharkTransaction);
            }
            long l = ActivityState.fromString(activityState);
            return l;
        }
        catch (Exception e) {
            try {
                Shark.getInstance().emptyCaches(sharkTransaction);
            }
            catch (Exception e1) {
                log.error((Object)e1.getMessage(), (Throwable)e1);
            }
            try {
                sharkTransaction.rollback();
            }
            catch (Exception e2) {
                log.error((Object)e2.getMessage(), (Throwable)e2);
            }
            throw e;
        }
        finally {
            if (sharkTransaction != null && ea1 != null) {
                ea1.disconnect(sharkTransaction);
            }
            if (sharkTransaction != null) {
                SharkFunctions.ClearSharkTransaction(sharkTransaction);
            }
        }
    }

    public void changeUser(String processId, String activityId, String userName) throws Exception {
        log.info((Object)"ChangeUser");
        Session hs = null;
        Transaction tx = null;
        try {
            hs = HibernateUtil.getSessionFactory().getCurrentSession();
            tx = hs.beginTransaction();
            String q1 = "select objectid from assignmentstable ";
            q1 = q1 + "where activityprocessid=:processId and ";
            q1 = q1 + "activityid=:activityId ";
            SQLQuery sql = hs.createSQLQuery(q1);
            sql.addScalar("objectid", (Type)StandardBasicTypes.BIG_DECIMAL);
            sql.setString("activityId", activityId);
            sql.setString("processId", processId);
            List list = sql.list();
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Zadanie o podanych parametrach nie istnieje");
            }
            BigDecimal objectId = (BigDecimal)list.get(0);
            String q2 = "update assignmentstable set resourceid=:userName where ";
            q2 = q2 + "activityid=:activityId and activityprocessid=:processId and ";
            q2 = q2 + "objectid=:objectId ";
            sql = hs.createSQLQuery(q2);
            sql.setString("userName", userName);
            sql.setString("activityId", activityId);
            sql.setString("processId", processId);
            sql.setParameter("objectId", (Object)objectId.longValue());
            sql.executeUpdate();
            String q3 = "delete from assignmentstable where ";
            q3 = q3 + "activityid=:activityId and activityprocessid=:processId and ";
            q3 = q3 + "objectid!=:objectId ";
            sql = hs.createSQLQuery(q3);
            sql.setString("activityId", activityId);
            sql.setString("processId", processId);
            sql.setParameter("objectId", (Object)objectId.longValue());
            sql.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)e, (Throwable)e);
            throw e;
        }
        finally {
            if (hs != null && hs.isOpen()) {
                hs.close();
            }
        }
    }

    public String getActivityDefIdByName(String processDefId, String name) {
        DBManagement dbm = new DBManagement();
        Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(processDefId);
        WorkflowProcesses wp = pack.getWorkflowProcesses();
        WorkflowProcess process = wp.getWorkflowProcess(processDefId);
        Activities acts = process.getActivities();
        int size = acts.size();
        for (int i = 0; i < size; ++i) {
            Activity act = (Activity)acts.get(i);
            if (!act.getName().equals(name)) continue;
            return act.getId();
        }
        return null;
    }
}

