/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.plannedtask.administration.structure;

import com.suncode.cuf.io.office.ExcelReader;
import com.suncode.cuf.io.office.model.ImportSheetDefinition;
import com.suncode.cuf.io.office.model.SheetDefinition;
import com.suncode.cuf.io.office.model.reader.StringValueReader;
import com.suncode.cuf.io.office.model.reader.ValueReader;
import com.suncode.cuf.plannedtask.administration.structure.helper.ImportStructureMode;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureData;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureImporter;
import com.suncode.cuf.plannedtask.administration.structure.helper.StructureMappings;
import com.suncode.pwfl.util.SpringContext;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportStructureUtils {
    private static final Logger taskLog = LoggerFactory.getLogger((String)"ScheduledTask");
    public static final String APPEND = "APPEND";
    public static final String STANDARD = "STANDARD";
    public static final String OVERRIDE = "OVERRIDE";

    public static void checkFileExist(String path) {
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            taskLog.error("Brak pliku lub praw do odczytu. Prosz\u0119 sprawdzi\u0107 czy podany plik istnieje na serwerze, gdzie zainstalowany jest system lub prawa dost\u0119pu do pliku: " + path);
        }
    }

    public static ImportSheetDefinition getSheetDefinitionForStructure(String name, StructureMappings structureMappings) {
        ImportSheetDefinition sheet = new ImportSheetDefinition(name, structureMappings);
        HashMap<String, ValueReader> valueReaders = new HashMap<String, ValueReader>();
        for (String key : structureMappings.getReverseColumnMappings().keySet()) {
            valueReaders.put(key, new StringValueReader());
        }
        sheet.setValueReaders(valueReaders);
        return sheet;
    }

    public static StructureData importDataFromXls(List<ImportSheetDefinition> importSheetDefinitions, String path) {
        List<SheetDefinition> sheetDefinitions = new ArrayList<SheetDefinition>();
        try (FileInputStream is = new FileInputStream(path);){
            ExcelReader reader = new ExcelReader();
            sheetDefinitions = reader.read(importSheetDefinitions, is);
        }
        catch (Exception e) {
            taskLog.error("B\u0142\u0105d odczytu pliku: " + e);
        }
        return new StructureData(sheetDefinitions);
    }

    public static void exportDataToDatabase(StructureData data, String mode, String unusedUsersHandleType, String assignmentUsers) {
        StructureImporter importer = new StructureImporter();
        importer.importStructure(data, ImportStructureUtils.resolveMode(mode), unusedUsersHandleType, assignmentUsers);
    }

    public static ImportStructureMode resolveMode(String mode) {
        if (mode.equalsIgnoreCase(APPEND)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importOrgStructureAppendMode");
        }
        if (mode.equalsIgnoreCase(STANDARD)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importOrgStructureStandardMode");
        }
        if (mode.equalsIgnoreCase(OVERRIDE)) {
            return (ImportStructureMode)SpringContext.getBean((String)"importOrgStructureOverrideMode");
        }
        throw new IllegalArgumentException("Nie obs\u0142ugiwany tryb importu: " + mode);
    }
}

