/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.hibernate.support;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.engine.spi.TypedValue;

public class ConcatenableIlikeCriterion
implements Criterion {
    private static final long serialVersionUID = 1L;
    private String value;
    private String[] columns;

    public ConcatenableIlikeCriterion(String value, MatchMode match, String ... columns) {
        if (columns == null || columns.length == 0) {
            throw new RuntimeException("At least one column must be specified");
        }
        MatchMode matchMode = match = match != null ? match : MatchMode.EXACT;
        if (MatchMode.ANYWHERE.equals((Object)match) || MatchMode.START.equals((Object)match)) {
            value = value + "%";
        }
        if (MatchMode.ANYWHERE.equals((Object)match) || MatchMode.END.equals((Object)match)) {
            value = "%" + value;
        }
        this.value = value;
        this.columns = columns;
    }

    public TypedValue[] getTypedValues(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        return new TypedValue[]{criteriaQuery.getTypedValue(criteria, this.columns[0], (Object)this.value.toString().toLowerCase())};
    }

    public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
        Dialect dialect = criteriaQuery.getFactory().getDialect();
        String[] realColumns = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            realColumns[i] = criteriaQuery.getColumnsUsingProjection(criteria, this.columns[i])[0];
        }
        if (dialect instanceof HSQLDialect) {
            String query = "";
            for (int i = 0; i < this.columns.length; ++i) {
                query = query + realColumns[i] + (i < this.columns.length - 1 ? ", ' '," : "");
            }
            query = "upper(concat(" + query + ")) like upper(?)";
            return query;
        }
        if (dialect instanceof SQLServerDialect) {
            String query = "";
            for (int i = 0; i < this.columns.length; ++i) {
                query = query + realColumns[i] + (i < this.columns.length - 1 ? "+ ' ' +" : "");
            }
            query = "upper(" + query + ") like upper(?)";
            return query;
        }
        String query = "";
        for (int i = 0; i < this.columns.length; ++i) {
            query = query + realColumns[i] + (i < this.columns.length - 1 ? " || ' ' || " : "");
        }
        query = "upper(" + query + ") like upper(?)";
        return query;
    }

    public static ConcatenableIlikeCriterion ilike(String value, MatchMode match, String ... columns) {
        return new ConcatenableIlikeCriterion(value, match, columns);
    }
}

