/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.currency;

import com.suncode.cuf.currency.Exchange;
import com.suncode.cuf.currency.ExchangeService;
import com.suncode.cuf.currency.Rate;
import com.suncode.cuf.currency.RateDto;
import com.suncode.plugin.framework.service.Provides;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Provides
@Service(value="exchangeService")
public class ExchangeServiceImpl
implements ExchangeService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeServiceImpl.class);

    @Override
    public HashMap<String, Rate> getLastNbpExchanges(Set<String> exchangesSymbols, LocalDate date) throws Exception {
        log.info("Wybrana data: {}.", (Object)date);
        HashMap<String, Rate> results = new HashMap<String, Rate>();
        for (String symbol : exchangesSymbols) {
            Rate lastExchange = this.getLastNbpExchange(symbol, date);
            if (lastExchange == null) continue;
            results.put(symbol, lastExchange);
        }
        return results;
    }

    @Override
    public RateDto getLastNbpExchangeWithTableSymbol(String exchangeSymbol, LocalDate date) throws Exception {
        RestTemplate restTemplate = new RestTemplate();
        Exchange ex = this.getTenDaysNbpExchanges(restTemplate, exchangeSymbol, date);
        RateDto result = this.selectLastExchange(ex, date);
        return result;
    }

    @Override
    public Rate getLastNbpExchange(String exchangeSymbol, LocalDate date) throws Exception {
        RateDto rateDto = this.getLastNbpExchangeWithTableSymbol(exchangeSymbol, date);
        Rate result = new Rate();
        result.setEffectiveDate(rateDto.getEffectiveDate());
        result.setMid(rateDto.getMid());
        result.setNo(rateDto.getNo());
        return result;
    }

    private Exchange getTenDaysNbpExchanges(RestTemplate restTemplate, String exchangeSymbol, LocalDate endDate) {
        HashMap<String, String> urlVariables = new HashMap<String, String>();
        urlVariables.put("exchangeSymbol", exchangeSymbol);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        urlVariables.put("startDate", endDate.minusDays(9L).format(formatter));
        urlVariables.put("endDate", endDate.format(formatter));
        urlVariables.put("table", "A");
        Exchange result = this.getPeriodNbpExchanges(restTemplate, urlVariables);
        if (result == null) {
            urlVariables.put("table", "B");
            result = this.getPeriodNbpExchanges(restTemplate, urlVariables);
        }
        return result;
    }

    protected Exchange getPeriodNbpExchanges(RestTemplate restTemplate, Map<String, String> urlVariables) {
        Exchange result;
        String url = "http://api.nbp.pl/api/exchangerates/rates/{table}/{exchangeSymbol}/{startDate}/{endDate}?format=json";
        try {
            result = (Exchange)restTemplate.getForObject(url, Exchange.class, urlVariables);
        }
        catch (RestClientException e) {
            log.info("Not received NBP exchanges for table : {}, symbol: {}, from: {},  to: {}, due to : {}", new Object[]{urlVariables.get("table"), urlVariables.get("exchangeSymbol"), urlVariables.get("startDate"), urlVariables.get("endDate"), e.getLocalizedMessage()});
            result = null;
        }
        return result;
    }

    private RateDto selectLastExchange(Exchange exchanges, LocalDate date) {
        if (exchanges == null) {
            return null;
        }
        List<Rate> rates = exchanges.getRates();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        for (int i = 0; i <= 9; ++i) {
            LocalDate dateToCheck = date.minusDays(i);
            ListIterator<Rate> it = rates.listIterator(rates.size());
            while (it.hasPrevious()) {
                Rate rate = it.previous();
                LocalDate rateDate = LocalDate.parse(rate.getEffectiveDate(), formatter);
                if (!dateToCheck.equals(rateDate)) continue;
                RateDto rateDto = new RateDto();
                rateDto.setEffectiveDate(rate.getEffectiveDate());
                rateDto.setMid(rate.getMid());
                rateDto.setNo(rate.getNo());
                rateDto.setTable(exchanges.getTable());
                return rateDto;
            }
        }
        return null;
    }
}

