/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail.receivers;

import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.SendMailSender;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.FinderFactory;
import java.util.List;
import javax.mail.MessagingException;
import org.springframework.stereotype.Component;

@Component
public class PositionSymbolReceiver
implements Receiver {
    private String positionSymbol;

    @Override
    public ReceiverTypes getType() {
        return ReceiverTypes.POSITION_BY_SYMBOL;
    }

    @Override
    public void send(String receiverId, String subject, String content, List<WfDocument> attachments, List<String> excludedEmails, String processId) throws MessagingException {
        this.positionSymbol = receiverId;
        PositionFinder positionFinder = FinderFactory.getPositionFinder();
        Position position = positionFinder.findBySymbol(this.positionSymbol, new String[]{"user"});
        User user = position.getUser();
        if (!excludedEmails.contains(user.getEmail())) {
            SendMailSender.getInstance().send(user.getEmail(), subject, content, attachments);
            excludedEmails.add(user.getEmail());
        }
    }
}

