/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.cuf.automatictask.mail.receivers;

import com.suncode.cuf.automatictask.mail.ReceiverTypes;
import com.suncode.cuf.automatictask.mail.SendMailSender;
import com.suncode.cuf.automatictask.mail.receivers.Receiver;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.StructureService;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.List;
import javax.mail.MessagingException;
import org.springframework.stereotype.Component;

@Component
public class OrganizationalUnitSymbolReceiver
implements Receiver {
    private String organizationalUnitSymbol;

    @Override
    public ReceiverTypes getType() {
        return ReceiverTypes.OU_BY_SYMBOL;
    }

    @Override
    public void send(String receiverId, String subject, String content, List<WfDocument> attachments, List<String> excludedEmails, String processId) throws MessagingException {
        this.organizationalUnitSymbol = receiverId;
        PositionFinder positionFinder = FinderFactory.getPositionFinder();
        StructureService structureService = ServiceFactory.getStructureService();
        OrganizationalUnit organizationalUnit = structureService.getOrganizationalUnit(this.organizationalUnitSymbol, new String[0]);
        for (Position position : positionFinder.getAll(new String[]{"organizationalUnit", "user"})) {
            User user;
            if (!position.getOrganizationalUnit().equals((Object)organizationalUnit) || excludedEmails.contains((user = position.getUser()).getEmail())) continue;
            SendMailSender.getInstance().send(user.getEmail(), subject, content, attachments);
            excludedEmails.add(user.getEmail());
        }
    }
}

