/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.ArchiveServices;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.archive.ArchiveStorageService;
import com.suncode.pwfl.archive.Device;
import com.suncode.pwfl.archive.Directory;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import org.apache.log4j.Logger;

public class ImportDirectories
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ImportDirectories.class);

    @AdvancedTask(name="ImportDirectoriesFromXLS", description="ImportDirectoriesFromXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ImportDirectoriesFromXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ImportDirectoriesFromXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = null;
        WorkbookSettings wbs = null;
        Workbook workbook = null;
        HashMap<String, Integer> header = new HashMap<String, Integer>();
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        DBManagement dbm = new DBManagement();
        try {
            int i;
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            xls = new File(sXLSPath);
            if (xls == null || !xls.exists()) {
                throw new CUFException("Plik xls nie istnieje w lokalizacji " + sXLSPath);
            }
            wbs = new WorkbookSettings();
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.getWorkbook((File)xls, (WorkbookSettings)wbs);
            Sheet sheet = workbook.getSheet("Katalogi");
            if (sheet == null) {
                throw new CUFException("Brak arkusza Katalogi w pliku xls w lokalizacji " + sXLSPath);
            }
            for (i = 0; i < 5; ++i) {
                String cell = sheet.getCell(i, 0).getContents();
                header.put(cell, i);
            }
            log.info((Object)"Poprawne rozpoznanie arkusza z katalogami");
            for (i = 1; i < sheet.getRows(); ++i) {
                try {
                    String sDirName = sheet.getCell(((Integer)header.get("Nazwa katalogu")).intValue(), i).getContents();
                    String sRootDirName = sheet.getCell(((Integer)header.get("Katalog nadrz\u0119dny")).intValue(), i).getContents();
                    long lRootDirId = -1L;
                    String sSize = sheet.getCell(((Integer)header.get("Rozmiar [MB]")).intValue(), i).getContents();
                    Long lSize = new Long(-1L);
                    String sDirTreshold = sheet.getCell(((Integer)header.get("Pr\u00f3g przepe\u0142nienia [%]")).intValue(), i).getContents();
                    Long lDirTreshold = new Long(-1L);
                    String sDeviceName = sheet.getCell(((Integer)header.get("Nazwa urz\u0105dzenia")).intValue(), i).getContents();
                    long lDeviceId = -1L;
                    if (Tools.isNullOrEmpty((String)sDirName) || Tools.isNullOrEmpty((String)sSize) || Tools.isNullOrEmpty((String)sDirTreshold) || Tools.isNullOrEmpty((String)sDeviceName)) {
                        throw new CUFException("Brak danych dla katalogu w arkuszu w linii " + (i + 1));
                    }
                    if (ArchiveServices.DoesDirectoryExist(sDirName, sDeviceName)) {
                        throw new CUFException("Katalog o nazwie " + sDirName + " istnieje juz w systemie w urzadzeniu o nazwie " + sDeviceName);
                    }
                    try {
                        lSize = Long.parseLong(sSize);
                        if (lSize <= 0L) {
                            throw new CUFException("Rozmiar dla katalogu o nazwie " + sDirName + " jest wartoscia ujemna");
                        }
                    }
                    catch (NumberFormatException e) {
                        taskLog.error((Object)e.getMessage());
                        throw new CUFException("Rozmiar dla katalogu o nazwie " + sDirName + " nie jest wartoscia liczbowa");
                    }
                    try {
                        lDirTreshold = Long.parseLong(sDirTreshold);
                        if (lDirTreshold <= 0L || lDirTreshold > 100L) {
                            throw new CUFException("Prog przepelnienia dla katalogu o nazwie " + sDirName + " nie wyraza wartosci procentowej z przedzialu od 0 do 100");
                        }
                    }
                    catch (NumberFormatException e) {
                        taskLog.error((Object)e.getMessage());
                        throw new CUFException("Prog przepelnienia dla katalogu o nazwie " + sDirName + " nie jest wartoscia liczbowa");
                    }
                    lDeviceId = ImportDirectories.getDeviceId(sDeviceName);
                    if (lDeviceId == -1L) {
                        throw new CUFException("Urzadzenie o nazwie " + sDeviceName + " przypisane do katalogu o nazwie " + sDirName + " nie istnieje w systemie");
                    }
                    Device device = as.getDeviceById(Long.valueOf(lDeviceId), new String[0]);
                    if (device != null && device.getDeviceFreeSpace() < lSize) {
                        throw new CUFException("Brak miejsca w urzadzeniu o nazwie " + sDeviceName + " dla katalogu o nazwie " + sDirName);
                    }
                    if (!Tools.isNullOrEmpty((String)sRootDirName) && !sRootDirName.equalsIgnoreCase("brak")) {
                        lRootDirId = ImportDirectories.getRootDirId(sRootDirName);
                        if (lRootDirId == -1L) {
                            throw new CUFException("Katalog nadrzedny o nazwie " + sRootDirName + " przypisany do katalogu o nazwie " + sDirName + " nie istnieje w systemie");
                        }
                    } else {
                        lRootDirId = 0L;
                        sRootDirName = "";
                    }
                    Directory directory = new Directory();
                    directory.setRootDir(new Directory(Long.valueOf(lRootDirId)));
                    directory.setDevice(new Device(Long.valueOf(lDeviceId)));
                    directory.setDirectoryName(sDeviceName);
                    directory.setDirectorySize(lSize);
                    directory.setDirectoryFreeSpace(lSize);
                    directory.setDirectoryThreshold(lDirTreshold);
                    as.createDirectory(directory);
                    long id = directory.getId();
                    if (id == -1L) {
                        throw new CUFException("Blad podczas dodawania katalogu o nazwie " + sDirName + " do systemu");
                    }
                    log.info((Object)("Poprawnie dodano katalog o nazwie " + sDirName + " do systemu"));
                    continue;
                }
                catch (CUFException e) {
                    taskLog.error((Object)e.getMessage());
                    log.warn((Object)e.getMessage());
                    continue;
                }
                catch (Exception e) {
                    taskLog.error((Object)e.getMessage());
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            log.info((Object)"Zakonczono import katalogow");
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ImportDirectoriesFromXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private static long getDeviceId(String sDeviceName) throws Exception {
        log.trace((Object)("************ getDeviceId(sDeviceName=" + sDeviceName + ") ************"));
        long id = -1L;
        DBManagement dbm = new DBManagement();
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        List allDevices = as.getAllDevices(new String[0]);
        if (allDevices != null && allDevices.size() > 0) {
            for (Device oneDevice : allDevices) {
                String sThisDeviceName;
                if (oneDevice == null || (sThisDeviceName = oneDevice.getDeviceName()) == null || !sThisDeviceName.equalsIgnoreCase(sDeviceName)) continue;
                Long lId = oneDevice.getId();
                if (lId == null) break;
                id = lId;
                break;
            }
        }
        return id;
    }

    private static long getRootDirId(String sRootDirName) throws Exception {
        log.trace((Object)("************ getRootDirId(sRootDirName=" + sRootDirName + ") ************"));
        long id = -1L;
        DBManagement dbm = new DBManagement();
        ArchiveStorageService as = ServiceFactory.getArchiveStorageService();
        List allDirs = as.getAllDirectories(new String[0]);
        if (allDirs != null && allDirs.size() > 0) {
            for (Directory oneDir : allDirs) {
                String sThisDirName;
                if (oneDir == null || (sThisDirName = oneDir.getDirectoryName()) == null || !sThisDirName.equalsIgnoreCase(sRootDirName)) continue;
                Long lId = oneDir.getId();
                if (lId == null) break;
                id = lId;
                break;
            }
        }
        return id;
    }
}

