/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.AutoUpdates.defs;

import com.plusmpm.CUF.util.AutoUpdates.defs.DefReader;
import com.plusmpm.util.form.autoupdate.DataSource;
import com.plusmpm.util.form.autoupdate.Definition;
import com.plusmpm.util.form.autoupdate.Destination;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DefReaderImpl
implements DefReader {
    public static Logger log = Logger.getLogger(DefReaderImpl.class);
    private static final String defFileExtension = "xml";
    private static final String definitionElName = "Definition";
    private static final String taskNameElName = "TaskName";
    private static final String typeElName = "Type";
    private static final String nameElName = "Name";
    private static final String descrElName = "Description";
    private static final String dataSourceElName = "DataSource";
    private static final String destinationElName = "Destination";
    private static final String valueAttributeName = "value";
    private static final String descrAttributeName = "description";

    @Override
    public Definition getDefinition(String id, String lang) {
        Definition definition = null;
        Document doc = null;
        Element defEl = null;
        String taskName = null;
        try {
            doc = this.getResource(id, lang);
            defEl = (Element)doc.getElementsByTagName(definitionElName).item(0);
            taskName = this.getElementsElementAttribute(defEl, taskNameElName, valueAttributeName);
            try {
                Class.forName(taskName);
            }
            catch (ClassNotFoundException e) {
                return new Definition();
            }
            definition = new Definition();
            definition.setTaskName(taskName);
            definition.setType(this.getElementsElementAttribute(defEl, typeElName, valueAttributeName));
            definition.setName(this.getElementsElementAttribute(defEl, nameElName, valueAttributeName));
            definition.setDescr(this.getElementsElementAttribute(defEl, descrElName, valueAttributeName));
            return definition;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new Definition();
        }
    }

    @Override
    public List<DataSource> getDataSources(String id, String lang) {
        ArrayList<DataSource> dataSources = null;
        Document doc = null;
        NodeList dsList = null;
        try {
            doc = this.getResource(id, lang);
            dsList = doc.getElementsByTagName(dataSourceElName);
            if (dsList == null || dsList.getLength() == 0) {
                return new ArrayList<DataSource>();
            }
            dataSources = new ArrayList<DataSource>();
            for (int i = 0; i < dsList.getLength(); ++i) {
                Element dsEl = (Element)dsList.item(i);
                DataSource ds = new DataSource();
                ds.setValue(dsEl.getAttribute(valueAttributeName));
                ds.setDescr(dsEl.getAttribute(descrAttributeName));
                dataSources.add(ds);
            }
            return dataSources;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new ArrayList<DataSource>();
        }
    }

    @Override
    public List<Destination> getDestinations(String id, String lang) {
        ArrayList<Destination> destinations = null;
        Document doc = null;
        NodeList dList = null;
        try {
            doc = this.getResource(id, lang);
            dList = doc.getElementsByTagName(destinationElName);
            if (dList == null || dList.getLength() == 0) {
                return new ArrayList<Destination>();
            }
            destinations = new ArrayList<Destination>();
            for (int i = 0; i < dList.getLength(); ++i) {
                Element dEl = (Element)dList.item(i);
                Destination d = new Destination();
                d.setValue(dEl.getAttribute(valueAttributeName));
                d.setDescr(dEl.getAttribute(descrAttributeName));
                destinations.add(d);
            }
            return destinations;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new ArrayList<Destination>();
        }
    }

    private String getElementsElementAttribute(Element el, String elName, String attrName) {
        return ((Element)el.getElementsByTagName(elName).item(0)).getAttribute(attrName);
    }

    private Document getResource(String id, String lang) throws Exception {
        InputStream is = this.getClass().getResourceAsStream(id + "_" + lang + "." + defFileExtension);
        Document doc = this.getXMLFromInputStream(is);
        doc.normalize();
        return doc;
    }

    private Document getXMLFromInputStream(InputStream inputStream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = null;
        InputSource inputSource = null;
        try (InputStreamReader reader = null;){
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            reader = new InputStreamReader(inputStream, "UTF-8");
            inputSource = new InputSource(reader);
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            return document;
        }
    }
}

