/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.util.Authorization;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.plusmpm.util.workflowData.ProcessData;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;

public class ExportProcessesProtection
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportProcessesProtection.class);
    private static String[] rightLevelsTable = new String[]{"System.Workflow.Processes.view.", "System.Workflow.Processes.create.", "System.Workflow.Processes.delete.", "System.Workflow.Processes.stats."};
    private static int currentRowPos;

    @AdvancedTask(name="ExportProcessesProtectionToXLS", description="ExportProcessesProtectionToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportProcessesProtectionToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportProcessesProtectionToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook w = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        HashMap<String, List<String>> rightsList = null;
        Map processDefIdsAndNamesMap = null;
        int colPos = 0;
        try {
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            w = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet rightsSheet = w.createSheet("Ochrona proces\u00f3w", 0);
            log.info((Object)"Utworzono arkusz do eksportu ochrony procesow");
            currentRowPos = 0;
            String[] colIDs = new String[]{"Nazwa procesu", "Nazwa grupy", "Nazwa u\u017cytkownika", "Podgl\u0105d", "Tworzenie", "Usuwanie", "Statystyki"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (int i = 0; i < colIDs.length; ++i) {
                CUFTools.addCellToXLSSheet(rightsSheet, colPos, 0, colIDs[i], times12format, cellView);
                ++colPos;
            }
            ++currentRowPos;
            log.info((Object)"Utworzono naglowki w arkuszu");
            ProcessData processData = new ProcessData();
            processDefIdsAndNamesMap = processData.getProcessDefIdsNames();
            if (processDefIdsAndNamesMap != null && processDefIdsAndNamesMap.size() > 0) {
                for (String sProcDefId : processDefIdsAndNamesMap.keySet()) {
                    if (Tools.isNullOrEmpty((String)sProcDefId)) continue;
                    boolean bForGroup = true;
                    rightsList = this.getRightsList(bForGroup, sProcDefId);
                    this.sendToXLS(rightsSheet, cellView, rightsList, bForGroup, sProcDefId);
                    bForGroup = false;
                    rightsList = this.getRightsList(bForGroup, sProcDefId);
                    this.sendToXLS(rightsSheet, cellView, rightsList, bForGroup, sProcDefId);
                }
            } else {
                log.warn((Object)"Brak procesow w systemie");
            }
            w.write();
            w.close();
            log.info((Object)("Eksport ochrony procesow do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania ochrony procesow. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    w.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportProcessesProtectionToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }

    private HashMap<String, List<String>> getRightsList(boolean bForGroup, String sProcDefId) throws Exception {
        log.trace((Object)("************ getRightsList(bForGroup=" + String.valueOf(bForGroup) + ", sProcDefId=" + sProcDefId + ") ************"));
        HashMap<String, List<String>> rightsList = new HashMap<String, List<String>>();
        Set resourceIdsForRight = null;
        String sWhoLog = "";
        String sRightFroundLog = "";
        String sNoRightFoundLog = "";
        if (bForGroup) {
            sWhoLog = "grup";
            sRightFroundLog = "Sa grupy, ktore";
            sNoRightFoundLog = "Zadna grupa";
        } else {
            sWhoLog = "uzytkownikow";
            sRightFroundLog = "Sa uzytkownicy, ktorzy";
            sNoRightFoundLog = "Zaden uzytkownik";
        }
        log.info((Object)("Pobieranie z systemu praw dla " + sWhoLog));
        for (String rightLevelName : rightLevelsTable) {
            log.info((Object)("Pobieranie nazw " + sWhoLog + " posiadajacych prawo " + rightLevelName + sProcDefId));
            resourceIdsForRight = Authorization.listRights((String)(rightLevelName + sProcDefId), (boolean)bForGroup);
            if (resourceIdsForRight != null && resourceIdsForRight.size() > 0) {
                log.info((Object)(sRightFroundLog + " posiadaja prawo " + rightLevelName + sProcDefId));
                for (String sResourceId : resourceIdsForRight) {
                    List<Object> rightsForResourceList;
                    if (Tools.isNullOrEmpty((String)sResourceId) || sResourceId.equals("admin") || sResourceId.equals("SharkGroup") || sResourceId.equals("Administrators")) continue;
                    if (rightsList.containsKey(sResourceId)) {
                        rightsForResourceList = rightsList.get(sResourceId);
                        rightsForResourceList.add(rightLevelName + sProcDefId);
                        rightsList.put(sResourceId, rightsForResourceList);
                        continue;
                    }
                    rightsForResourceList = new ArrayList();
                    rightsForResourceList.add(rightLevelName + sProcDefId);
                    rightsList.put(sResourceId, rightsForResourceList);
                }
                continue;
            }
            log.info((Object)(sNoRightFoundLog + " nie posiada prawa " + rightLevelName + sProcDefId));
        }
        return rightsList;
    }

    private void sendToXLS(WritableSheet rightsSheet, CellView cellView, HashMap<String, List<String>> rightsList, boolean bForGroup, String sProcDefId) throws Exception {
        log.trace((Object)("************ sendToXLS(WritableSheet, CellView, HashMap<String, List<String>>, bForGroup=" + String.valueOf(bForGroup) + ", sProcDefId=" + sProcDefId + ") ************"));
        if (rightsList != null && rightsList.size() > 0) {
            Iterator<String> iterator = rightsList.keySet().iterator();
            while (iterator.hasNext()) {
                int colPos = 0;
                String sProcessName = CUFTools.getProcessNameForProcDefId(sProcDefId);
                CUFTools.addCellToXLSSheet(rightsSheet, colPos, currentRowPos, sProcessName, null, cellView);
                ++colPos;
                String sResourceId = iterator.next();
                colPos = bForGroup ? 1 : 2;
                CUFTools.addCellToXLSSheet(rightsSheet, colPos, currentRowPos, sResourceId, null, cellView);
                ++colPos;
                List<String> rightsForResourceList = rightsList.get(sResourceId);
                colPos = 3;
                for (String rightLevelName : rightLevelsTable) {
                    if (rightsForResourceList.contains(rightLevelName = rightLevelName + sProcDefId)) {
                        CUFTools.addCellToXLSSheet(rightsSheet, colPos, currentRowPos, "TAK", null, cellView);
                    } else {
                        CUFTools.addCellToXLSSheet(rightsSheet, colPos, currentRowPos, "NIE", null, cellView);
                    }
                    ++colPos;
                }
                ++currentRowPos;
            }
        }
    }
}

