/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.servlet.extension.CUF;

import com.plusmpm.CUF.database.storage.DynamicTableStorageManager;
import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.util.Tools;
import com.plusmpm.util.json.extjs.gson.GsonCustomUtils;
import com.plusmpm.util.json.extjs.objects.JsonStore;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DynamicTableStorageGetColumnIds
extends HttpServlet {
    public static Logger log = Logger.getLogger(DynamicTableStorageGetColumnIds.class);
    private static final long serialVersionUID = 1L;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace((Object)"************************* DynamicTableStorageGetColumnIds Servlet ****************************");
        PrintWriter printWriter = null;
        JsonStore jsonStore = null;
        GsonCustomUtils gsonCustomUtils = null;
        ArrayList records = null;
        boolean bSuccess = false;
        String answerMessage = "";
        try {
            records = new ArrayList();
            String storageName = request.getParameter("storageName");
            String owner = request.getParameter("owner");
            String tabTitle = request.getParameter("tabTitle");
            if (Tools.isNullOrEmpty((String)storageName)) {
                throw new CUFException("Brak nazwy zestawu danych.");
            }
            if (Tools.isNullOrEmpty((String)owner)) {
                throw new CUFException("Nie zidentyfikowano w\u0142a\u015bciciela zestawu. Nie mo\u017cna pobra\u0107 identyfikator\u00f3w kolumn domy\u015blnego zestawu danych o nazwie " + storageName + ".");
            }
            if (Tools.isNullOrEmpty((String)tabTitle)) {
                throw new CUFException("Tabela nie posiada tytu\u0142u. Nie mo\u017cna pobra\u0107 identyfikator\u00f3w kolumn domy\u015blnego zestawu danych o nazwie " + storageName + ".");
            }
            List<String> columnIds = DynamicTableStorageManager.getDynamicTableStorageColumnIds(storageName, owner, tabTitle);
            if (columnIds == null || columnIds.size() == 0) {
                throw new CUFException("Brak identyfikator\u00f3w kolumn tabeli " + tabTitle);
            }
            for (String columnId : columnIds) {
                HashMap<String, String> record = new HashMap<String, String>();
                record.put("columnId", columnId);
                records.add(record);
            }
            bSuccess = true;
            answerMessage = "Pobrano indetyfikatory kolumn domy\u015blnego zestawu danych o nazwie " + storageName + ".";
            log.info((Object)("Pobrano indetyfikatory kolumn domy\u015blnego zestawu danych o nazwie " + storageName));
        }
        catch (CUFException e) {
            bSuccess = false;
            answerMessage = e.getMessage();
            log.warn((Object)answerMessage);
        }
        catch (Exception e) {
            bSuccess = false;
            answerMessage = "B\u0142\u0105d odczytu identyfikator\u00f3w kolumn domy\u015blnego zestawu danych.";
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                jsonStore = new JsonStore();
                jsonStore.setSuccess(Boolean.valueOf(bSuccess));
                jsonStore.setMessage(answerMessage);
                jsonStore.setRecords(records);
                gsonCustomUtils = new GsonCustomUtils();
                String sJsonData = gsonCustomUtils.getJsonForExtJsonStore(jsonStore);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(sJsonData);
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

