/*
 * Decompiled with CFR 0.152.
 */
package com.plusmpm.CUF.util.PlannedExternalTask;

import com.plusmpm.CUF.util.extension.CUFException;
import com.plusmpm.CUF.util.extension.CUFTools;
import com.plusmpm.database.DBManagement;
import com.plusmpm.database.UserDelegationsTable;
import com.plusmpm.util.SharkFunctions;
import com.plusmpm.util.Tools;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.enhydra.shark.xpdl.elements.Package;

public class ExportDelegations
extends AbstractAdvancedTask {
    public static Logger log = Logger.getLogger(ExportDelegations.class);

    @AdvancedTask(name="ExportDelegationsToXLS", description="ExportDelegationsToXLS_desc", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void ExportDelegationsToXLS(@TaskParam(name="pathXls", description="pathXls_desc") String sXLSPath) {
        log.info((Object)("************ ExportDelegationsToXLS(sXLSPath=" + sXLSPath + ") ************"));
        long startTime = new Date().getTime();
        File xls = new File(sXLSPath);
        WorkbookSettings wbs = new WorkbookSettings();
        WritableWorkbook workbook = null;
        WritableFont times12font = null;
        WritableCellFormat times12format = null;
        CellView cellView = null;
        DBManagement dbm = new DBManagement();
        ArrayList delegations = null;
        int colPos = 0;
        int rowPos = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            sXLSPath = CUFTools.convertBackslashesToSlashes(sXLSPath);
            if (!sXLSPath.endsWith("xls") && !sXLSPath.endsWith("XLS")) {
                throw new CUFException("Sciezka do pliku postaci " + sXLSPath + " nie odnosi sie do pliku xls");
            }
            wbs.setEncoding("ISO-8859-2");
            workbook = Workbook.createWorkbook((File)xls, (WorkbookSettings)wbs);
            WritableSheet devicesSheet = workbook.createSheet("Zast\u0119pstwa", 0);
            log.info((Object)"Utworzono arkusz do eksportu zastepstw");
            String[] colIDs = new String[]{"Nazwa procesu", "Uczestnik procesu", "U\u017cytkownik", "Zast\u0119pca", "Od", "Do"};
            times12font = new WritableFont(WritableFont.TIMES, 12);
            times12font.setBoldStyle(WritableFont.BOLD);
            times12font.setColour(Colour.BLACK);
            cellView = new CellView();
            cellView.setAutosize(true);
            times12format = new WritableCellFormat(times12font);
            times12format.setAlignment(Alignment.CENTRE);
            times12format.setBorder(Border.ALL, BorderLineStyle.MEDIUM);
            times12format.setBackground(Colour.AQUA);
            for (int i = 0; i < colIDs.length; ++i) {
                CUFTools.addCellToXLSSheet(devicesSheet, colPos, 0, colIDs[i], times12format, cellView);
                ++colPos;
            }
            log.info((Object)"Utworzono naglowki w arkuszu");
            log.info((Object)"Pobieranie zastepstw");
            delegations = dbm.GetUsersDelegations("", "", "");
            if (delegations != null && delegations.size() > 0) {
                AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
                for (UserDelegationsTable delegation : delegations) {
                    if (delegation == null) continue;
                    colPos = 0;
                    ++rowPos;
                    String procDefId = delegation.getSProcesId();
                    String processName = "";
                    String participantId = delegation.getSParticipantId();
                    String participantName = "";
                    String user = delegation.getSUser();
                    String delegatedUser = delegation.getSDelegatedUser();
                    Long lStartDate = delegation.getLStartDate();
                    Date dStartDate = null;
                    String startDate = "";
                    Long lFinishDate = delegation.getLFinishDate();
                    Date dFinishDate = null;
                    String finishDate = "";
                    processName = procDefId.equalsIgnoreCase("*") ? "Wszystkie" : CUFTools.getProcessNameForProcDefId(procDefId);
                    CUFTools.addCellToXLSSheet(devicesSheet, colPos, rowPos, processName, null, cellView);
                    ++colPos;
                    Package pack = SharkFunctions.getPackageManager().getPackageByProcessDefinitionId(procDefId);
                    if (pack == null) {
                        log.warn((Object)("Brak pakietu dla procesu o identyfikatorze definicji " + procDefId));
                        continue;
                    }
                    String packageId = pack.getId();
                    if (Tools.isNullOrEmpty((String)packageId)) {
                        log.warn((Object)("Brak identyfikatora pakietu dla procesu o identyfikatorze definicji " + procDefId));
                        continue;
                    }
                    participantName = participantId.equalsIgnoreCase("*") ? "Wszyscy" : adminMisc.getParticipantName(packageId, procDefId, participantId);
                    CUFTools.addCellToXLSSheet(devicesSheet, colPos, rowPos, participantName, null, cellView);
                    CUFTools.addCellToXLSSheet(devicesSheet, ++colPos, rowPos, user, null, cellView);
                    CUFTools.addCellToXLSSheet(devicesSheet, ++colPos, rowPos, delegatedUser, null, cellView);
                    dStartDate = new Date(lStartDate);
                    startDate = sdf.format(dStartDate);
                    CUFTools.addCellToXLSSheet(devicesSheet, ++colPos, rowPos, startDate, null, cellView);
                    dFinishDate = new Date(lFinishDate);
                    finishDate = sdf.format(dFinishDate);
                    CUFTools.addCellToXLSSheet(devicesSheet, ++colPos, rowPos, finishDate, null, cellView);
                    ++colPos;
                }
            } else {
                log.info((Object)"Brak aktywnych zastepstw w systemie");
            }
            workbook.write();
            workbook.close();
            log.info((Object)("Eksport zastepstw do pliku " + sXLSPath + " zakonczony sukcesem"));
        }
        catch (CUFException e) {
            taskLog.error((Object)e.getMessage());
            log.warn((Object)e.getMessage());
        }
        catch (Exception e) {
            taskLog.error((Object)e.getMessage());
            log.error((Object)e.getMessage(), (Throwable)e);
            try {
                if (xls != null && xls.exists()) {
                    log.warn((Object)("Blad podczas eksportowania zastepstw. Usuwanie niepoprawnie utworzonego pliku xls z lokalizacji " + sXLSPath));
                    workbook.close();
                    xls.delete();
                    log.info((Object)"Niepoprawnie utworzony plik xls zostal usuniety");
                }
            }
            catch (Exception ex) {
                taskLog.error((Object)e.getMessage());
                log.error((Object)e.getMessage(), (Throwable)ex);
            }
        }
        long stopTime = new Date().getTime();
        log.info((Object)("Czas wykonywania zadania zaplanowanego ExportDelegationsToXLS: " + CUFTools.plannedTaskDuration(stopTime - startTime)));
    }
}

