/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.hash;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.data.redis.hash.HashMapper;

public class BeanUtilsHashMapper<T>
implements HashMapper<T, String, String> {
    private final Class<T> type;

    public BeanUtilsHashMapper(Class<T> type) {
        this.type = type;
    }

    @Override
    public T fromHash(Map<String, String> hash) {
        Object instance = org.springframework.beans.BeanUtils.instantiateClass(this.type);
        try {
            BeanUtils.populate((Object)instance, hash);
            return (T)instance;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Map<String, String> toHash(T object) {
        try {
            Map map = BeanUtils.describe(object);
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot describe object %s".formatted(object), ex);
        }
    }
}

