/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public interface RedisHashCommands {
    @Nullable
    public Boolean hSet(byte[] var1, byte[] var2, byte[] var3);

    @Nullable
    public Boolean hSetNX(byte[] var1, byte[] var2, byte[] var3);

    @Nullable
    public byte[] hGet(byte[] var1, byte[] var2);

    @Nullable
    public List<byte[]> hMGet(byte[] var1, byte[] ... var2);

    public void hMSet(byte[] var1, Map<byte[], byte[]> var2);

    @Nullable
    public Long hIncrBy(byte[] var1, byte[] var2, long var3);

    @Nullable
    public Double hIncrBy(byte[] var1, byte[] var2, double var3);

    @Nullable
    public Boolean hExists(byte[] var1, byte[] var2);

    @Nullable
    public Long hDel(byte[] var1, byte[] ... var2);

    @Nullable
    public Long hLen(byte[] var1);

    @Nullable
    public Set<byte[]> hKeys(byte[] var1);

    @Nullable
    public List<byte[]> hVals(byte[] var1);

    @Nullable
    public Map<byte[], byte[]> hGetAll(byte[] var1);

    @Nullable
    public byte[] hRandField(byte[] var1);

    @Nullable
    public Map.Entry<byte[], byte[]> hRandFieldWithValues(byte[] var1);

    @Nullable
    public List<byte[]> hRandField(byte[] var1, long var2);

    @Nullable
    public List<Map.Entry<byte[], byte[]>> hRandFieldWithValues(byte[] var1, long var2);

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] var1, ScanOptions var2);

    @Nullable
    public Long hStrLen(byte[] var1, byte[] var2);

    @Nullable
    default public List<Long> applyHashFieldExpiration(byte[] key, Expiration expiration, byte[] ... fields) {
        return this.applyHashFieldExpiration(key, expiration, ExpirationOptions.none(), fields);
    }

    @Nullable
    default public List<Long> applyHashFieldExpiration(byte[] key, Expiration expiration, ExpirationOptions options, byte[] ... fields) {
        if (expiration.isPersistent()) {
            return this.hPersist(key, fields);
        }
        if (ObjectUtils.nullSafeEquals((Object)ExpirationOptions.none(), (Object)options)) {
            if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
                if (expiration.isUnixTimestamp()) {
                    return this.hpExpireAt(key, expiration.getExpirationTimeInMilliseconds(), fields);
                }
                return this.hpExpire(key, expiration.getExpirationTimeInMilliseconds(), fields);
            }
            if (expiration.isUnixTimestamp()) {
                return this.hExpireAt(key, expiration.getExpirationTimeInSeconds(), fields);
            }
            return this.hExpire(key, expiration.getExpirationTimeInSeconds(), fields);
        }
        if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
            if (expiration.isUnixTimestamp()) {
                return this.hpExpireAt(key, expiration.getExpirationTimeInMilliseconds(), options.getCondition(), fields);
            }
            return this.hpExpire(key, expiration.getExpirationTimeInMilliseconds(), options.getCondition(), fields);
        }
        if (expiration.isUnixTimestamp()) {
            return this.hExpireAt(key, expiration.getExpirationTimeInSeconds(), options.getCondition(), fields);
        }
        return this.hExpire(key, expiration.getExpirationTimeInSeconds(), options.getCondition(), fields);
    }

    @Nullable
    default public List<Long> hExpire(byte[] key, long seconds, byte[] ... fields) {
        return this.hExpire(key, seconds, ExpirationOptions.Condition.ALWAYS, fields);
    }

    @Nullable
    default public List<Long> hExpire(byte[] key, Duration ttl, byte[] ... fields) {
        return this.hExpire(key, ttl.toSeconds(), fields);
    }

    @Nullable
    public List<Long> hExpire(byte[] var1, long var2, ExpirationOptions.Condition var4, byte[] ... var5);

    @Nullable
    default public List<Long> hpExpire(byte[] key, long millis, byte[] ... fields) {
        return this.hpExpire(key, millis, ExpirationOptions.Condition.ALWAYS, fields);
    }

    @Nullable
    default public List<Long> hpExpire(byte[] key, Duration ttl, byte[] ... fields) {
        return this.hpExpire(key, ttl.toMillis(), fields);
    }

    @Nullable
    public List<Long> hpExpire(byte[] var1, long var2, ExpirationOptions.Condition var4, byte[] ... var5);

    @Nullable
    default public List<Long> hExpireAt(byte[] key, long unixTime, byte[] ... fields) {
        return this.hExpireAt(key, unixTime, ExpirationOptions.Condition.ALWAYS, fields);
    }

    @Nullable
    public List<Long> hExpireAt(byte[] var1, long var2, ExpirationOptions.Condition var4, byte[] ... var5);

    @Nullable
    default public List<Long> hpExpireAt(byte[] key, long unixTimeInMillis, byte[] ... fields) {
        return this.hpExpireAt(key, unixTimeInMillis, ExpirationOptions.Condition.ALWAYS, fields);
    }

    @Nullable
    public List<Long> hpExpireAt(byte[] var1, long var2, ExpirationOptions.Condition var4, byte[] ... var5);

    @Nullable
    public List<Long> hPersist(byte[] var1, byte[] ... var2);

    @Nullable
    public List<Long> hTtl(byte[] var1, byte[] ... var2);

    @Nullable
    public List<Long> hTtl(byte[] var1, TimeUnit var2, byte[] ... var3);

    @Nullable
    public List<Long> hpTtl(byte[] var1, byte[] ... var2);
}

