/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.StringJoiner;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class KeyScanOptions
extends ScanOptions {
    public static KeyScanOptions NONE = new KeyScanOptions(null, null, null, null);
    @Nullable
    private final String type;

    KeyScanOptions(@Nullable Long count, @Nullable String pattern, @Nullable byte[] bytePattern, @Nullable String type) {
        super(count, pattern, bytePattern);
        this.type = type;
    }

    public static ScanOptions.ScanOptionsBuilder scanOptions(DataType type) {
        return new ScanOptions.ScanOptionsBuilder().type(type);
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    public String toOptionString() {
        if (this.equals(NONE)) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(", ").add(super.toOptionString());
        if (StringUtils.hasText((String)this.type)) {
            joiner.add("'type' '" + this.type + "'");
        }
        return joiner.toString();
    }
}

