/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.query.KeyValuePartTreeQuery;
import org.springframework.data.keyvalue.repository.query.PredicateQueryCreator;
import org.springframework.data.keyvalue.repository.support.QuerydslKeyValuePredicateExecutor;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class KeyValueRepositoryFactory
extends RepositoryFactorySupport {
    private static final Class<PredicateQueryCreator> DEFAULT_QUERY_CREATOR = PredicateQueryCreator.class;
    private final KeyValueOperations keyValueOperations;
    private final MappingContext<?, ?> context;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    private final Class<? extends RepositoryQuery> repositoryQueryType;

    public KeyValueRepositoryFactory(KeyValueOperations keyValueOperations) {
        this(keyValueOperations, DEFAULT_QUERY_CREATOR);
    }

    public KeyValueRepositoryFactory(KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        this(keyValueOperations, queryCreator, KeyValuePartTreeQuery.class);
    }

    public KeyValueRepositoryFactory(KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType) {
        Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null");
        Assert.notNull(queryCreator, (String)"Query creator type must not be null");
        Assert.notNull(repositoryQueryType, (String)"RepositoryQueryType type must not be null");
        this.queryCreator = queryCreator;
        this.keyValueOperations = keyValueOperations;
        this.context = keyValueOperations.getMappingContext();
        this.repositoryQueryType = repositoryQueryType;
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        PersistentEntity entity = this.context.getRequiredPersistentEntity(domainClass);
        return new PersistentEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        EntityInformation entityInformation = this.getEntityInformation(repositoryInformation.getDomainType());
        return super.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{entityInformation, this.keyValueOperations});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleKeyValueRepository.class;
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        return this.getRepositoryFragments(metadata, this.keyValueOperations);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata, KeyValueOperations operations) {
        if (KeyValueRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface())) {
            if (metadata.isReactiveRepository()) {
                throw new InvalidDataAccessApiUsageException("Cannot combine Querydsl and reactive repository support in a single interface");
            }
            return RepositoryComposition.RepositoryFragments.just((Object[])new Object[]{new QuerydslKeyValuePredicateExecutor(this.getEntityInformation(metadata.getDomainType()), this.getProjectionFactory(), operations, (EntityPathResolver)SimpleEntityPathResolver.INSTANCE)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new KeyValueQueryLookupStrategy(key, evaluationContextProvider, this.keyValueOperations, this.queryCreator, this.repositoryQueryType));
    }

    private static class KeyValueQueryLookupStrategy
    implements QueryLookupStrategy {
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;
        private final KeyValueOperations keyValueOperations;
        private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
        private final Class<? extends RepositoryQuery> repositoryQueryType;

        public KeyValueQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType) {
            Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null");
            Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null");
            Assert.notNull(queryCreator, (String)"Query creator type must not be null");
            Assert.notNull(repositoryQueryType, (String)"RepositoryQueryType type must not be null");
            this.evaluationContextProvider = evaluationContextProvider;
            this.keyValueOperations = keyValueOperations;
            this.queryCreator = queryCreator;
            this.repositoryQueryType = repositoryQueryType;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            QueryMethod queryMethod = new QueryMethod(method, metadata, factory);
            Constructor constructor = ClassUtils.getConstructorIfAvailable(this.repositoryQueryType, (Class[])new Class[]{QueryMethod.class, QueryMethodEvaluationContextProvider.class, KeyValueOperations.class, Class.class});
            Assert.state((constructor != null ? 1 : 0) != 0, (String)String.format("Constructor %s(QueryMethod, EvaluationContextProvider, KeyValueOperations, Class) not available", ClassUtils.getShortName(this.repositoryQueryType)));
            return (RepositoryQuery)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{queryMethod, this.evaluationContextProvider, this.keyValueOperations, this.queryCreator});
        }
    }
}

