/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web.config;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.web.querydsl.ReactiveQuerydslPredicateArgumentResolver;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

@Configuration(proxyBeanMethods=false)
public class ReactiveQuerydslWebConfiguration
implements WebFluxConfigurer {
    @Autowired
    @Qualifier(value="webFluxConversionService")
    ObjectProvider<ConversionService> conversionService;
    @Autowired
    ObjectProvider<EntityPathResolver> resolver;
    @Autowired
    BeanFactory beanFactory;

    @Lazy
    @Bean
    public ReactiveQuerydslPredicateArgumentResolver querydslPredicateArgumentResolver() {
        return new ReactiveQuerydslPredicateArgumentResolver((QuerydslBindingsFactory)this.beanFactory.getBean("querydslBindingsFactory", QuerydslBindingsFactory.class), (ConversionService)this.conversionService.getIfUnique(DefaultConversionService::getSharedInstance));
    }

    @Lazy
    @Bean
    public QuerydslBindingsFactory querydslBindingsFactory() {
        return new QuerydslBindingsFactory((EntityPathResolver)this.resolver.getIfUnique(() -> SimpleEntityPathResolver.INSTANCE));
    }

    public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
        configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{(HandlerMethodArgumentResolver)this.beanFactory.getBean("querydslPredicateArgumentResolver", ReactiveQuerydslPredicateArgumentResolver.class)});
    }
}

