/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.util.Collections;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.domain.ManagedTypes;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class ManagedTypesBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final Log logger = LogFactory.getLog(BeanFactoryInitializationAotProcessor.class);

    @Nullable
    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        this.processManagedTypes(beanFactory);
        return null;
    }

    private void processManagedTypes(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            for (String beanName : beanFactory.getBeanNamesForType(ManagedTypes.class)) {
                this.postProcessManagedTypes(beanFactory, registry, beanName);
            }
        }
    }

    private void postProcessManagedTypes(ConfigurableListableBeanFactory beanFactory, BeanDefinitionRegistry registry, String beanName) {
        ConstructorArgumentValues.ValueHolder argumentValue;
        Object object;
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
        if (this.hasConstructorArguments(beanDefinition) && (object = (argumentValue = beanDefinition.getConstructorArgumentValues().getArgumentValue(0, null, null, null)).getValue()) instanceof Supplier) {
            Supplier supplier = (Supplier)object;
            if (logger.isDebugEnabled()) {
                logger.info((Object)String.format("Replacing ManagedType bean definition %s.", beanName));
            }
            Object value = ManagedTypesBeanFactoryInitializationAotProcessor.potentiallyWrapToIterable(supplier.get());
            BeanDefinition beanDefinitionReplacement = this.newManagedTypeBeanDefinition(beanDefinition.getBeanClassName(), value);
            registry.removeBeanDefinition(beanName);
            registry.registerBeanDefinition(beanName, beanDefinitionReplacement);
        }
    }

    private static Object potentiallyWrapToIterable(Object value) {
        if (ObjectUtils.isArray((Object)value)) {
            return CollectionUtils.arrayToList((Object)value);
        }
        if (value instanceof Iterable) {
            return value;
        }
        return Collections.singleton(value);
    }

    private boolean hasConstructorArguments(BeanDefinition beanDefinition) {
        return !beanDefinition.getConstructorArgumentValues().isEmpty();
    }

    private BeanDefinition newManagedTypeBeanDefinition(String managedTypesClassName, Object constructorArgumentValue) {
        return BeanDefinitionBuilder.rootBeanDefinition((String)managedTypesClassName).setFactoryMethod("fromIterable").addConstructorArgValue(constructorArgumentValue).getBeanDefinition();
    }
}

