/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.util;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.MimeMessage;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.internal.batchsupport.LifecycleDelegatingTransport;
import org.simplejavamail.internal.moduleloader.ModuleLoader;
import org.simplejavamail.internal.modules.BatchModule;
import org.simplejavamail.mailer.internal.SessionBasedEmailToMimeMessageConverter;
import org.simplejavamail.mailer.internal.util.TransportConnectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportRunner.class);

    public static void sendMessage(@NotNull UUID clusterKey, Session session, @NotNull Email email) throws MessagingException {
        TransportRunner.runOnSessionTransport(clusterKey, session, false, (transport, actualSessionUsed) -> {
            MimeMessage message = SessionBasedEmailToMimeMessageConverter.convertAndLogMimeMessage(actualSessionUsed, email);
            transport.sendMessage((Message)message, message.getAllRecipients());
            LOGGER.trace("...email sent");
        });
    }

    public static void connect(@NotNull UUID clusterKey, Session session) throws MessagingException {
        TransportRunner.runOnSessionTransport(clusterKey, session, true, (transport, actualSessionUsed) -> LOGGER.debug("...connection successful"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runOnSessionTransport(@NotNull UUID clusterKey, Session session, boolean stickySession, TransportRunnable runnable) throws MessagingException {
        if (ModuleLoader.batchModuleAvailable()) {
            TransportRunner.sendUsingConnectionPool(ModuleLoader.loadBatchModule(), clusterKey, session, stickySession, runnable);
        } else {
            try (Transport transport = session.getTransport();){
                TransportConnectionHelper.connectTransport(transport, session);
                runnable.run(transport, session);
            }
            finally {
                LOGGER.trace("closing transport");
            }
        }
    }

    private static void sendUsingConnectionPool(@NotNull BatchModule batchModule, @NotNull UUID clusterKey, Session session, boolean stickySession, TransportRunnable runnable) throws MessagingException {
        LifecycleDelegatingTransport delegatingTransport = batchModule.acquireTransport(clusterKey, session, stickySession);
        try {
            runnable.run(delegatingTransport.getTransport(), delegatingTransport.getSessionUsedToObtainTransport());
        }
        catch (Throwable t) {
            delegatingTransport.signalTransportFailed();
            throw t;
        }
        delegatingTransport.signalTransportUsed();
    }

    public static interface TransportRunnable {
        public void run(Transport var1, Session var2) throws MessagingException;
    }
}

