/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal.mailsender;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;

public class OperationalConfig {
    private final int sessionTimeout;
    private final Properties properties;
    private final int threadPoolSize;
    private final boolean transportModeLoggingOnly;
    private final boolean debugLogging;
    private final List<String> sslHostsToTrust;
    private final boolean trustAllSSLHost;
    private final boolean verifyingServerIdentity;

    public OperationalConfig(@Nonnull Properties properties, int sessionTimeout, int threadPoolSize, boolean transportModeLoggingOnly, boolean debugLogging, List<String> sslHostsToTrust, boolean trustAllSSLHost, boolean verifyingServerIdentity) {
        this.properties = properties;
        this.sessionTimeout = sessionTimeout;
        this.threadPoolSize = threadPoolSize;
        this.transportModeLoggingOnly = transportModeLoggingOnly;
        this.debugLogging = debugLogging;
        this.sslHostsToTrust = Collections.unmodifiableList(sslHostsToTrust);
        this.trustAllSSLHost = trustAllSSLHost;
        this.verifyingServerIdentity = verifyingServerIdentity;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public boolean isTransportModeLoggingOnly() {
        return this.transportModeLoggingOnly;
    }

    public boolean isDebugLogging() {
        return this.debugLogging;
    }

    public List<String> getSslHostsToTrust() {
        return this.sslHostsToTrust;
    }

    public boolean isTrustAllSSLHost() {
        return this.trustAllSSLHost;
    }

    public boolean isVerifyingServerIdentity() {
        return this.verifyingServerIdentity;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

