/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Session;
import org.simplejavamail.mailer.Mailer;
import org.simplejavamail.mailer.MailerFromSessionBuilder;
import org.simplejavamail.mailer.MailerGenericBuilder;
import org.simplejavamail.mailer.ServerConfig;
import org.simplejavamail.mailer.config.TransportStrategy;
import org.simplejavamail.util.ConfigLoader;

public class MailerBuilder {
    public static MailerFromSessionBuilder usingSession(@Nonnull Session session) {
        return new MailerFromSessionBuilder().usingSession(session);
    }

    public static MailerRegularBuilder withTransportStrategy(@Nonnull TransportStrategy transportStrategy) {
        return new MailerRegularBuilder().withTransportStrategy(transportStrategy);
    }

    public static MailerRegularBuilder withSMTPServer(@Nullable String host, @Nullable Integer port, @Nullable String username, @Nullable String password) {
        return new MailerRegularBuilder().withSMTPServer(host, port, username, password);
    }

    public static MailerRegularBuilder withSMTPServer(@Nullable String host, @Nullable Integer port, @Nullable String username) {
        return new MailerRegularBuilder().withSMTPServer(host, port, username);
    }

    public static MailerRegularBuilder withSMTPServer(@Nullable String host, @Nullable Integer port) {
        return new MailerRegularBuilder().withSMTPServer(host, port);
    }

    public static MailerRegularBuilder withSMTPServerHost(@Nullable String host) {
        return new MailerRegularBuilder().withSMTPServerHost(host);
    }

    public static MailerRegularBuilder withSMTPServerPort(@Nullable Integer port) {
        return new MailerRegularBuilder().withSMTPServerPort(port);
    }

    public static MailerRegularBuilder withSMTPServerUsername(@Nullable String username) {
        return new MailerRegularBuilder().withSMTPServerUsername(username);
    }

    public static MailerRegularBuilder withSMTPServerPassword(@Nullable String password) {
        return new MailerRegularBuilder().withSMTPServerPassword(password);
    }

    public static MailerRegularBuilder withDebugLogging(Boolean debugLogging) {
        return (MailerRegularBuilder)new MailerRegularBuilder().withDebugLogging(debugLogging);
    }

    public static Mailer buildMailer() {
        return new MailerRegularBuilder().buildMailer();
    }

    private MailerBuilder() {
    }

    public static class MailerRegularBuilder
    extends MailerGenericBuilder<MailerRegularBuilder> {
        private String host;
        private Integer port;
        private String username;
        private String password;
        private TransportStrategy transportStrategy;

        MailerRegularBuilder() {
            if (ConfigLoader.hasProperty(ConfigLoader.Property.SMTP_HOST)) {
                this.withSMTPServerHost(ConfigLoader.getStringProperty(ConfigLoader.Property.SMTP_HOST));
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.SMTP_PORT)) {
                this.withSMTPServerPort(ConfigLoader.getIntegerProperty(ConfigLoader.Property.SMTP_PORT));
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.SMTP_USERNAME)) {
                this.withSMTPServerUsername(ConfigLoader.getStringProperty(ConfigLoader.Property.SMTP_USERNAME));
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.SMTP_PASSWORD)) {
                this.withSMTPServerPassword(ConfigLoader.getStringProperty(ConfigLoader.Property.SMTP_PASSWORD));
            }
            this.withTransportStrategy(TransportStrategy.SMTP);
            if (ConfigLoader.hasProperty(ConfigLoader.Property.TRANSPORT_STRATEGY)) {
                this.withTransportStrategy((TransportStrategy)((Object)ConfigLoader.getProperty(ConfigLoader.Property.TRANSPORT_STRATEGY)));
            }
        }

        public MailerRegularBuilder withTransportStrategy(@Nonnull TransportStrategy transportStrategy) {
            this.transportStrategy = transportStrategy;
            return this;
        }

        public MailerRegularBuilder withSMTPServer(@Nullable String host, @Nullable Integer port, @Nullable String username, @Nullable String password) {
            return this.withSMTPServerHost(host).withSMTPServerPort(port).withSMTPServerUsername(username).withSMTPServerPassword(password);
        }

        public MailerRegularBuilder withSMTPServer(@Nullable String host, @Nullable Integer port, @Nullable String username) {
            return this.withSMTPServerHost(host).withSMTPServerPort(port).withSMTPServerUsername(username);
        }

        public MailerRegularBuilder withSMTPServer(@Nullable String host, @Nullable Integer port) {
            return this.withSMTPServerHost(host).withSMTPServerPort(port);
        }

        public MailerRegularBuilder withSMTPServerHost(@Nullable String host) {
            this.host = host;
            return this;
        }

        public MailerRegularBuilder withSMTPServerPort(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public MailerRegularBuilder withSMTPServerUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        public MailerRegularBuilder withSMTPServerPassword(@Nullable String password) {
            this.password = password;
            return this;
        }

        public Mailer buildMailer() {
            return new Mailer(this);
        }

        ServerConfig buildServerConfig() {
            return new ServerConfig(this.getHost(), this.getPort(), this.getUsername(), this.getPassword());
        }

        public String getHost() {
            return this.host;
        }

        public Integer getPort() {
            return this.port;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public TransportStrategy getTransportStrategy() {
            return this.transportStrategy;
        }
    }
}

