/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.email;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.EmailException;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.util.ConfigLoader;

public class EmailPopulatingBuilder {
    private String id;
    private Recipient fromRecipient;
    private Recipient replyToRecipient;
    private Recipient bounceToRecipient;
    private String subject;
    private String text;
    private String textHTML;
    private final Set<Recipient> recipients = new HashSet<Recipient>();
    private final List<AttachmentResource> embeddedImages = new ArrayList<AttachmentResource>();
    private final List<AttachmentResource> attachments = new ArrayList<AttachmentResource>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private File dkimPrivateKeyFile;
    private InputStream dkimPrivateKeyInputStream;
    private String dkimSigningDomain;
    private String dkimSelector;
    private boolean useDispositionNotificationTo;
    private Recipient dispositionNotificationTo;
    private boolean useReturnReceiptTo;
    private Recipient returnReceiptTo;
    private MimeMessage emailToForward;

    EmailPopulatingBuilder(boolean applyDefaults) {
        if (applyDefaults) {
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS)) {
                this.from((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_FROM_ADDRESS));
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS)) {
                this.withReplyTo((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_REPLYTO_ADDRESS));
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BOUNCETO_ADDRESS)) {
                this.withBounceTo((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BOUNCETO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BOUNCETO_ADDRESS));
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS)) {
                if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_TO_NAME)) {
                    this.to((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS));
                } else {
                    this.to((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_TO_ADDRESS));
                }
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS)) {
                if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_CC_NAME)) {
                    this.cc((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS));
                } else {
                    this.cc((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_CC_ADDRESS));
                }
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS)) {
                if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_BCC_NAME)) {
                    this.bcc((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_NAME), (String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS));
                } else {
                    this.bcc((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_BCC_ADDRESS));
                }
            }
            if (ConfigLoader.hasProperty(ConfigLoader.Property.DEFAULT_SUBJECT)) {
                this.withSubject((String)ConfigLoader.getProperty(ConfigLoader.Property.DEFAULT_SUBJECT));
            }
        }
    }

    public Email buildEmail() {
        return new Email(this);
    }

    public EmailPopulatingBuilder fixingMessageId(@Nullable String id) {
        this.id = id;
        return this;
    }

    public EmailPopulatingBuilder from(@Nonnull String fromAddress) {
        return this.from(null, fromAddress);
    }

    public EmailPopulatingBuilder from(@Nullable String name, @Nonnull String fromAddress) {
        return this.from(new Recipient(name, Preconditions.checkNonEmptyArgument(fromAddress, "fromAddress"), null));
    }

    public EmailPopulatingBuilder from(@Nullable String fixedName, @Nonnull InternetAddress fromAddress) {
        Preconditions.checkNonEmptyArgument(fromAddress, "fromAddress");
        return this.from(new Recipient(fixedName, fromAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder from(@Nonnull InternetAddress fromAddress) {
        Preconditions.checkNonEmptyArgument(fromAddress, "fromAddress");
        return this.from(new Recipient(fromAddress.getPersonal(), fromAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder from(@Nonnull Recipient recipient) {
        Preconditions.checkNonEmptyArgument(recipient, "from recipient");
        this.fromRecipient = new Recipient(recipient.getName(), recipient.getAddress(), null);
        return this;
    }

    public EmailPopulatingBuilder withReplyTo(@Nullable String replyToAddress) {
        return this.withReplyTo(replyToAddress != null ? new Recipient(null, replyToAddress, null) : null);
    }

    public EmailPopulatingBuilder withReplyTo(@Nullable String fixedName, @Nonnull String replyToAddress) {
        Preconditions.checkNonEmptyArgument(replyToAddress, "replyToAddress");
        return this.withReplyTo(new Recipient(fixedName, replyToAddress, null));
    }

    public EmailPopulatingBuilder withReplyTo(@Nonnull InternetAddress replyToAddress) {
        Preconditions.checkNonEmptyArgument(replyToAddress, "replyToAddress");
        return this.withReplyTo(new Recipient(replyToAddress.getPersonal(), replyToAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder withReplyTo(@Nullable String fixedName, @Nonnull InternetAddress replyToAddress) {
        Preconditions.checkNonEmptyArgument(replyToAddress, "replyToAddress");
        return this.withReplyTo(new Recipient(fixedName, replyToAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder withReplyTo(@Nullable Recipient recipient) {
        this.replyToRecipient = recipient != null ? new Recipient(recipient.getName(), recipient.getAddress(), null) : null;
        return this;
    }

    public EmailPopulatingBuilder withBounceTo(@Nullable String bounceToAddress) {
        return this.withBounceTo(bounceToAddress != null ? new Recipient(null, bounceToAddress, null) : null);
    }

    public EmailPopulatingBuilder withBounceTo(@Nullable String name, @Nonnull String bounceToAddress) {
        return this.withBounceTo(new Recipient(name, Preconditions.checkNonEmptyArgument(bounceToAddress, "bounceToAddress"), null));
    }

    public EmailPopulatingBuilder withBounceTo(@Nonnull InternetAddress bounceToAddress) {
        Preconditions.checkNonEmptyArgument(bounceToAddress, "bounceToAddress");
        return this.withBounceTo(new Recipient(bounceToAddress.getPersonal(), bounceToAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder withBounceTo(@Nullable String name, @Nonnull InternetAddress bounceToAddress) {
        Preconditions.checkNonEmptyArgument(bounceToAddress, "bounceToAddress");
        return this.withBounceTo(new Recipient(name, bounceToAddress.getAddress(), null));
    }

    public EmailPopulatingBuilder withBounceTo(@Nullable Recipient recipient) {
        this.bounceToRecipient = recipient != null ? new Recipient(recipient.getName(), recipient.getAddress(), null) : null;
        return this;
    }

    public EmailPopulatingBuilder withSubject(@Nullable String subject) {
        this.subject = subject;
        return this;
    }

    EmailPopulatingBuilder withForward(@Nullable MimeMessage emailMessageToForward) {
        this.emailToForward = emailMessageToForward;
        return this;
    }

    public EmailPopulatingBuilder withPlainText(@Nullable String text) {
        this.text = text;
        return this;
    }

    public EmailPopulatingBuilder prependText(@Nonnull String text) {
        this.text = text + MiscUtil.defaultTo(this.text, "");
        return this;
    }

    public EmailPopulatingBuilder appendText(@Nonnull String text) {
        this.text = MiscUtil.defaultTo(this.text, "") + text;
        return this;
    }

    public EmailPopulatingBuilder withHTMLText(@Nullable String textHTML) {
        this.textHTML = textHTML;
        return this;
    }

    public EmailPopulatingBuilder prependTextHTML(@Nonnull String textHTML) {
        this.textHTML = textHTML + MiscUtil.defaultTo(this.textHTML, "");
        return this;
    }

    public EmailPopulatingBuilder appendTextHTML(@Nonnull String textHTML) {
        this.textHTML = MiscUtil.defaultTo(this.textHTML, "") + textHTML;
        return this;
    }

    public EmailPopulatingBuilder to(Recipient ... recipients) {
        return this.withRecipients(Arrays.asList(recipients), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder to(@Nonnull Collection<Recipient> recipients) {
        return this.withRecipients(recipients, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder to(@Nullable String name, String address) {
        return this.toWithFixedName(name, address);
    }

    public EmailPopulatingBuilder to(@Nonnull String oneOrMoreAddresses) {
        return this.withRecipientsWithDefaultName(null, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder to(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.toWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder to(@Nullable String name, @Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.toWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder toMultiple(String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toMultiple(@Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toWithFixedName(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toWithDefaultName(@Nonnull String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toWithFixedName(@Nullable String name, @Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toWithDefaultName(@Nonnull String name, @Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder to(@Nullable String name, InternetAddress address) {
        return this.toAddressesWithFixedName(name, address);
    }

    public EmailPopulatingBuilder to(@Nonnull InternetAddress address) {
        return this.withAddressesWithDefaultName(null, Collections.singletonList(address), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder to(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        return this.toAddressesWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder toAddresses(@Nullable String name, @Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.toAddressesWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder toMultiple(InternetAddress ... oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toMultipleAddresses(@Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toAddressesWithFixedName(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        return this.withAddressesWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toAddressesWithDefaultName(@Nonnull String name, InternetAddress ... oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toAddressesWithFixedName(@Nullable String name, @Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.withAddressesWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder toAddressesWithDefaultName(@Nonnull String name, @Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.TO);
    }

    public EmailPopulatingBuilder cc(Recipient ... recipients) {
        return this.withRecipients(Arrays.asList(recipients), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder cc(@Nonnull Collection<Recipient> recipients) {
        return this.withRecipients(recipients, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder cc(@Nullable String name, String address) {
        return this.ccWithFixedName(name, address);
    }

    public EmailPopulatingBuilder cc(@Nonnull String oneOrMoreAddresses) {
        return this.withRecipientsWithDefaultName(null, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder cc(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.ccWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder cc(@Nullable String name, @Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.ccWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder ccMultiple(String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccAddresses(@Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccWithFixedName(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccWithDefaultName(@Nonnull String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccWithFixedName(@Nullable String name, @Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccWithDefaultName(@Nonnull String name, @Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder cc(@Nullable String name, InternetAddress address) {
        return this.ccAddressesWithFixedName(name, address);
    }

    public EmailPopulatingBuilder cc(@Nonnull InternetAddress address) {
        return this.withAddressesWithDefaultName(null, Collections.singletonList(address), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder cc(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        return this.ccAddressesWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder ccAddresses(@Nullable String name, @Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.ccAddressesWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder ccMultiple(InternetAddress ... oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccMultipleAddresses(@Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccAddressesWithFixedName(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        return this.withAddressesWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccAddressesWithDefaultName(@Nonnull String name, InternetAddress ... oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccAddressesWithFixedName(@Nullable String name, @Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.withAddressesWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder ccAddressesWithDefaultName(@Nonnull String name, @Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.CC);
    }

    public EmailPopulatingBuilder bcc(Recipient ... recipients) {
        return this.withRecipients(Arrays.asList(recipients), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bcc(@Nonnull Collection<Recipient> recipients) {
        return this.withRecipients(recipients, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, String address) {
        return this.bccWithFixedName(name, address);
    }

    public EmailPopulatingBuilder bcc(@Nonnull String oneOrMoreAddresses) {
        return this.withRecipientsWithDefaultName(null, Collections.singletonList(oneOrMoreAddresses), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.bccWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, @Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.bccWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder bccMultiple(String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccAddresses(@Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccWithFixedName(@Nullable String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccWithDefaultName(@Nonnull String name, String ... oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccWithFixedName(@Nullable String name, @Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccWithDefaultName(@Nonnull String name, @Nonnull Collection<String> oneOrMoreAddressesEach) {
        return this.withRecipientsWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, InternetAddress address) {
        return this.bccAddressesWithFixedName(name, address);
    }

    public EmailPopulatingBuilder bcc(@Nonnull InternetAddress address) {
        return this.withAddressesWithDefaultName(null, Collections.singletonList(address), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bcc(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        return this.bccAddressesWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder bccAddresses(@Nullable String name, @Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.bccAddressesWithFixedName(name, oneOrMoreAddressesEach);
    }

    public EmailPopulatingBuilder bccMultiple(InternetAddress ... oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(null, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccMultipleAddresses(@Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(null, oneOrMoreAddressesEach, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccAddressesWithFixedName(@Nullable String name, InternetAddress ... oneOrMoreAddressesEach) {
        return this.withAddressesWithFixedName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccAddressesWithDefaultName(@Nonnull String name, InternetAddress ... oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(name, Arrays.asList(oneOrMoreAddressesEach), Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccAddressesWithFixedName(@Nullable String name, @Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.withAddressesWithFixedName(name, oneOrMoreAddressesEach, Message.RecipientType.BCC);
    }

    public EmailPopulatingBuilder bccAddressesWithDefaultName(@Nonnull String name, @Nonnull Collection<InternetAddress> oneOrMoreAddressesEach) {
        return this.withAddressesWithDefaultName(name, oneOrMoreAddressesEach, Message.RecipientType.BCC);
    }

    @Nonnull
    public EmailPopulatingBuilder withRecipientsWithDefaultName(@Nullable String defaultName, @Nonnull Collection<String> oneOrMoreAddressesEach, @Nullable Message.RecipientType recipientType) {
        return this.withRecipients(defaultName, false, oneOrMoreAddressesEach, recipientType);
    }

    @Nonnull
    public EmailPopulatingBuilder withRecipientsWithFixedName(@Nullable String fixedName, @Nonnull Collection<String> oneOrMoreAddressesEach, @Nullable Message.RecipientType recipientType) {
        return this.withRecipients(fixedName, true, oneOrMoreAddressesEach, recipientType);
    }

    @Nonnull
    public EmailPopulatingBuilder withRecipientsWithDefaultName(@Nullable String name, @Nullable Message.RecipientType recipientType, String ... oneOrMoreAddressesEach) {
        return this.withRecipients(name, false, Arrays.asList(oneOrMoreAddressesEach), recipientType);
    }

    @Nonnull
    public EmailPopulatingBuilder withRecipientsWithFixedName(@Nullable String name, @Nullable Message.RecipientType recipientType, String ... oneOrMoreAddressesEach) {
        return this.withRecipients(name, true, Arrays.asList(oneOrMoreAddressesEach), recipientType);
    }

    @Nonnull
    public EmailPopulatingBuilder withRecipients(@Nullable String name, boolean fixedName, @Nullable Message.RecipientType recipientType, String ... oneOrMoreAddressesEach) {
        return this.withRecipients(name, fixedName, Arrays.asList(oneOrMoreAddressesEach), recipientType);
    }

    @Nonnull
    public EmailPopulatingBuilder withRecipients(@Nullable String name, boolean fixedName, @Nonnull Collection<String> oneOrMoreAddressesEach, @Nullable Message.RecipientType recipientType) {
        for (String oneOrMoreAddresses : oneOrMoreAddressesEach) {
            for (String emailAddress : MiscUtil.extractEmailAddresses(oneOrMoreAddresses)) {
                this.withRecipient(MiscUtil.interpretRecipient(name, fixedName, emailAddress, recipientType));
            }
        }
        return this;
    }

    @Nonnull
    public EmailPopulatingBuilder withAddressesWithDefaultName(@Nullable String defaultName, @Nonnull Collection<InternetAddress> addresses, @Nullable Message.RecipientType recipientType) {
        return this.withAddresses(defaultName, false, addresses, recipientType);
    }

    @Nonnull
    public EmailPopulatingBuilder withAddressesWithFixedName(@Nullable String fixedName, @Nonnull Collection<InternetAddress> addresses, @Nullable Message.RecipientType recipientType) {
        return this.withAddresses(fixedName, true, addresses, recipientType);
    }

    @Nonnull
    public EmailPopulatingBuilder withAddresses(@Nullable String name, boolean fixedName, @Nonnull Collection<InternetAddress> addresses, @Nullable Message.RecipientType recipientType) {
        for (InternetAddress address : addresses) {
            String effectiveName = fixedName || MiscUtil.valueNullOrEmpty(address.getPersonal()) ? name : address.getPersonal();
            this.withRecipient(effectiveName, address.getAddress(), recipientType);
        }
        return this;
    }

    public EmailPopulatingBuilder withRecipients(@Nonnull Collection<Recipient> recipients) {
        return this.withRecipients(recipients, null);
    }

    public EmailPopulatingBuilder withRecipients(Recipient ... recipients) {
        return this.withRecipients(Arrays.asList(recipients), null);
    }

    @Nonnull
    public EmailPopulatingBuilder withRecipients(@Nonnull Collection<Recipient> recipients, @Nullable Message.RecipientType fixedRecipientType) {
        for (Recipient recipient : recipients) {
            this.withRecipient(recipient.getName(), recipient.getAddress(), MiscUtil.defaultTo(fixedRecipientType, recipient.getType()));
        }
        return this;
    }

    public EmailPopulatingBuilder withRecipient(@Nonnull String singleAddress, @Nullable Message.RecipientType recipientType) {
        return this.withRecipient(null, singleAddress, recipientType);
    }

    public EmailPopulatingBuilder withRecipient(@Nullable String name, @Nonnull String singleAddress, @Nullable Message.RecipientType recipientType) {
        this.recipients.add(MiscUtil.interpretRecipient(name, true, singleAddress, recipientType));
        return this;
    }

    public EmailPopulatingBuilder withRecipient(@Nonnull Recipient recipient) {
        this.recipients.add(new Recipient(recipient.getName(), recipient.getAddress(), recipient.getType()));
        return this;
    }

    public EmailPopulatingBuilder withEmbeddedImage(@Nonnull String name, @Nonnull byte[] data, @Nonnull String mimetype) {
        Preconditions.checkNonEmptyArgument(name, "name");
        Preconditions.checkNonEmptyArgument(data, "data");
        Preconditions.checkNonEmptyArgument(mimetype, "mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(name);
        return this.withEmbeddedImage(name, (DataSource)dataSource);
    }

    public EmailPopulatingBuilder withEmbeddedImage(@Nullable String name, @Nonnull DataSource imagedata) {
        Preconditions.checkNonEmptyArgument(imagedata, "imagedata");
        if (MiscUtil.valueNullOrEmpty(name) && MiscUtil.valueNullOrEmpty(imagedata.getName())) {
            throw new EmailException("No name given for embedded image nor passed inside the data source");
        }
        this.embeddedImages.add(new AttachmentResource(name, imagedata));
        return this;
    }

    public EmailPopulatingBuilder withEmbeddedImages(@Nonnull List<AttachmentResource> embeddedImages) {
        for (AttachmentResource embeddedImage : embeddedImages) {
            this.withEmbeddedImage(embeddedImage.getName(), embeddedImage.getDataSource());
        }
        return this;
    }

    public <T> EmailPopulatingBuilder withHeaders(@Nonnull Map<String, T> headers) {
        for (Map.Entry<String, T> headerEntry : headers.entrySet()) {
            this.withHeader(headerEntry.getKey(), headerEntry.getValue());
        }
        return this;
    }

    public EmailPopulatingBuilder withHeader(@Nonnull String name, @Nullable Object value) {
        Preconditions.checkNonEmptyArgument(name, "name");
        this.headers.put(name, value != null ? String.valueOf(value) : null);
        return this;
    }

    public EmailPopulatingBuilder withAttachment(@Nullable String name, @Nonnull byte[] data, @Nonnull String mimetype) {
        Preconditions.checkNonEmptyArgument(data, "data");
        Preconditions.checkNonEmptyArgument(mimetype, "mimetype");
        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, mimetype);
        dataSource.setName(MiscUtil.encodeText(name));
        this.withAttachment(name, (DataSource)dataSource);
        return this;
    }

    public EmailPopulatingBuilder withAttachment(@Nullable String name, @Nonnull DataSource filedata) {
        Preconditions.checkNonEmptyArgument(filedata, "filedata");
        this.attachments.add(new AttachmentResource(MiscUtil.encodeText(name), filedata));
        return this;
    }

    public EmailPopulatingBuilder withAttachments(@Nonnull List<AttachmentResource> attachments) {
        for (AttachmentResource attachment : attachments) {
            this.withAttachment(attachment.getName(), attachment.getDataSource());
        }
        return this;
    }

    public EmailPopulatingBuilder signWithDomainKey(@Nonnull byte[] dkimPrivateKey, @Nonnull String signingDomain, @Nonnull String dkimSelector) {
        Preconditions.checkNonEmptyArgument(dkimPrivateKey, "dkimPrivateKey");
        return this.signWithDomainKey(new ByteArrayInputStream(dkimPrivateKey), signingDomain, dkimSelector);
    }

    public EmailPopulatingBuilder signWithDomainKey(@Nonnull String dkimPrivateKey, @Nonnull String signingDomain, @Nonnull String dkimSelector) {
        Preconditions.checkNonEmptyArgument(dkimPrivateKey, "dkimPrivateKey");
        return this.signWithDomainKey(new ByteArrayInputStream(dkimPrivateKey.getBytes(StandardCharsets.UTF_8)), signingDomain, dkimSelector);
    }

    public EmailPopulatingBuilder signWithDomainKey(@Nonnull InputStream dkimPrivateKeyInputStream, @Nonnull String signingDomain, @Nonnull String dkimSelector) {
        this.dkimPrivateKeyInputStream = Preconditions.checkNonEmptyArgument(dkimPrivateKeyInputStream, "dkimPrivateKeyInputStream");
        this.dkimSigningDomain = Preconditions.checkNonEmptyArgument(signingDomain, "dkimSigningDomain");
        this.dkimSelector = Preconditions.checkNonEmptyArgument(dkimSelector, "dkimSelector");
        return this;
    }

    public EmailPopulatingBuilder signWithDomainKey(@Nonnull File dkimPrivateKeyFile, @Nonnull String signingDomain, @Nonnull String dkimSelector) {
        this.dkimPrivateKeyFile = Preconditions.checkNonEmptyArgument(dkimPrivateKeyFile, "dkimPrivateKeyFile");
        this.dkimSigningDomain = Preconditions.checkNonEmptyArgument(signingDomain, "dkimSigningDomain");
        this.dkimSelector = Preconditions.checkNonEmptyArgument(dkimSelector, "dkimSelector");
        return this;
    }

    public EmailPopulatingBuilder withDispositionNotificationTo() {
        this.useDispositionNotificationTo = true;
        this.dispositionNotificationTo = null;
        return this;
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nonnull String address) {
        Preconditions.checkNonEmptyArgument(address, "dispositionNotificationToAddress");
        return this.withDispositionNotificationTo(new Recipient(null, address, null));
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nullable String name, @Nonnull String address) {
        Preconditions.checkNonEmptyArgument(address, "dispositionNotificationToAddress");
        return this.withDispositionNotificationTo(new Recipient(name, address, null));
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nonnull InternetAddress address) {
        Preconditions.checkNonEmptyArgument(address, "dispositionNotificationToAddress");
        return this.withDispositionNotificationTo(new Recipient(address.getPersonal(), address.getAddress(), null));
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nullable String fixedName, @Nonnull InternetAddress address) {
        Preconditions.checkNonEmptyArgument(address, "dispositionNotificationToAddress");
        return this.withDispositionNotificationTo(new Recipient(fixedName, address.getAddress(), null));
    }

    public EmailPopulatingBuilder withDispositionNotificationTo(@Nonnull Recipient recipient) {
        Preconditions.checkNonEmptyArgument(recipient.getAddress(), "recipient.address");
        this.useDispositionNotificationTo = true;
        this.dispositionNotificationTo = new Recipient(recipient.getName(), recipient.getAddress(), null);
        return this;
    }

    public EmailPopulatingBuilder withReturnReceiptTo() {
        this.useReturnReceiptTo = true;
        this.returnReceiptTo = null;
        return this;
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@Nonnull String address) {
        Preconditions.checkNonEmptyArgument(address, "address");
        return this.withReturnReceiptTo(new Recipient(null, address, null));
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@Nullable String name, @Nonnull String address) {
        Preconditions.checkNonEmptyArgument(address, "address");
        return this.withReturnReceiptTo(new Recipient(name, address, null));
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@Nonnull InternetAddress address) {
        Preconditions.checkNonEmptyArgument(address, "address");
        return this.withReturnReceiptTo(new Recipient(address.getPersonal(), address.getAddress(), null));
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@Nullable String fixedName, @Nonnull InternetAddress address) {
        Preconditions.checkNonEmptyArgument(address, "address");
        return this.withReturnReceiptTo(new Recipient(fixedName, address.getAddress(), null));
    }

    public EmailPopulatingBuilder withReturnReceiptTo(@Nonnull Recipient recipient) {
        Preconditions.checkNonEmptyArgument(recipient.getAddress(), "recipient.address");
        this.useReturnReceiptTo = true;
        this.returnReceiptTo = new Recipient(recipient.getName(), recipient.getAddress(), null);
        return this;
    }

    public EmailPopulatingBuilder clearId() {
        this.id = null;
        return this;
    }

    public EmailPopulatingBuilder clearFromRecipient() {
        this.fromRecipient = null;
        return this;
    }

    public EmailPopulatingBuilder clearReplyTo() {
        this.replyToRecipient = null;
        return this;
    }

    public EmailPopulatingBuilder clearBounceTo() {
        this.bounceToRecipient = null;
        return this;
    }

    public EmailPopulatingBuilder clearPlainText() {
        this.text = null;
        return this;
    }

    public EmailPopulatingBuilder clearHTMLText() {
        this.textHTML = null;
        return this;
    }

    public EmailPopulatingBuilder clearSubject() {
        this.subject = null;
        return this;
    }

    public EmailPopulatingBuilder clearRecipients() {
        this.recipients.clear();
        return this;
    }

    public EmailPopulatingBuilder clearEmbeddedImages() {
        this.embeddedImages.clear();
        return this;
    }

    public EmailPopulatingBuilder clearAttachments() {
        this.attachments.clear();
        return this;
    }

    public EmailPopulatingBuilder clearHeaders() {
        this.headers.clear();
        return this;
    }

    public EmailPopulatingBuilder clearDkim() {
        this.dkimPrivateKeyFile = null;
        this.dkimPrivateKeyInputStream = null;
        this.dkimSigningDomain = null;
        this.dkimSelector = null;
        return this;
    }

    public EmailPopulatingBuilder clearDispositionNotificationTo() {
        this.useDispositionNotificationTo = false;
        this.dispositionNotificationTo = null;
        return this;
    }

    public EmailPopulatingBuilder clearReturnReceiptTo() {
        this.useReturnReceiptTo = false;
        this.returnReceiptTo = null;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Recipient getFromRecipient() {
        return this.fromRecipient;
    }

    public Recipient getReplyToRecipient() {
        return this.replyToRecipient;
    }

    public Recipient getBounceToRecipient() {
        return this.bounceToRecipient;
    }

    public String getText() {
        return this.text;
    }

    public String getTextHTML() {
        return this.textHTML;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<Recipient> getRecipients() {
        return new ArrayList<Recipient>(this.recipients);
    }

    public List<AttachmentResource> getEmbeddedImages() {
        return new ArrayList<AttachmentResource>(this.embeddedImages);
    }

    public List<AttachmentResource> getAttachments() {
        return new ArrayList<AttachmentResource>(this.attachments);
    }

    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public File getDkimPrivateKeyFile() {
        return this.dkimPrivateKeyFile;
    }

    public InputStream getDkimPrivateKeyInputStream() {
        return this.dkimPrivateKeyInputStream;
    }

    public String getDkimSigningDomain() {
        return this.dkimSigningDomain;
    }

    public String getDkimSelector() {
        return this.dkimSelector;
    }

    public boolean isUseDispositionNotificationTo() {
        return this.useDispositionNotificationTo;
    }

    public Recipient getDispositionNotificationTo() {
        return this.dispositionNotificationTo;
    }

    public boolean isUseReturnReceiptTo() {
        return this.useReturnReceiptTo;
    }

    public Recipient getReturnReceiptTo() {
        return this.returnReceiptTo;
    }

    public MimeMessage getEmailToForward() {
        return this.emailToForward;
    }
}

