/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter.internal.mimemessage;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParameterList;
import org.simplejavamail.converter.internal.mimemessage.IDKIMSigner;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParseException;
import org.simplejavamail.converter.internal.mimemessage.NamedDataSource;
import org.simplejavamail.email.AttachmentResource;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.Recipient;
import org.simplejavamail.internal.util.MiscUtil;

public final class MimeMessageHelper {
    private static final String CHARACTER_ENCODING = StandardCharsets.UTF_8.name();

    private MimeMessageHelper() {
    }

    public static MimeMessage produceMimeMessage(final @Nonnull Email email, @Nonnull Session session) throws MessagingException, UnsupportedEncodingException {
        MiscUtil.checkArgumentNotEmpty(email, "email is missing");
        MiscUtil.checkArgumentNotEmpty(session, "session is needed, it cannot be attached later");
        MimeEmailMessageWrapper messageRoot = new MimeEmailMessageWrapper();
        MimeMessage message = new MimeMessage(session){

            protected void updateMessageID() throws MessagingException {
                if (MiscUtil.valueNullOrEmpty(email.getId())) {
                    super.updateMessageID();
                } else {
                    this.setHeader("Message-ID", email.getId());
                }
            }
        };
        message.setSubject(email.getSubject(), CHARACTER_ENCODING);
        message.setFrom((Address)new InternetAddress(email.getFromRecipient().getAddress(), email.getFromRecipient().getName(), CHARACTER_ENCODING));
        MimeMessageHelper.setReplyTo(email, (Message)message);
        MimeMessageHelper.setRecipients(email, (Message)message);
        MimeMessageHelper.setTexts(email, messageRoot.multipartAlternativeMessages);
        MimeMessageHelper.configureForwarding(email, messageRoot.multipartRootMixed);
        MimeMessageHelper.setEmbeddedImages(email, messageRoot.multipartRelated);
        MimeMessageHelper.setAttachments(email, messageRoot.multipartRootMixed);
        message.setContent((Multipart)messageRoot.multipartRootMixed);
        MimeMessageHelper.setHeaders(email, (Message)message);
        message.setSentDate(new Date());
        if (!MiscUtil.valueNullOrEmpty(email.getDkimSigningDomain())) {
            return MimeMessageHelper.signMessageWithDKIM(message, email);
        }
        return message;
    }

    private static void setRecipients(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        for (Recipient recipient : email.getRecipients()) {
            InternetAddress address = new InternetAddress(recipient.getAddress(), recipient.getName(), CHARACTER_ENCODING);
            message.addRecipient(recipient.getType(), (Address)address);
        }
    }

    private static void setReplyTo(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        Recipient replyToRecipient = email.getReplyToRecipient();
        if (replyToRecipient != null) {
            InternetAddress replyToAddress = new InternetAddress(replyToRecipient.getAddress(), replyToRecipient.getName(), CHARACTER_ENCODING);
            message.setReplyTo(new Address[]{replyToAddress});
        }
    }

    private static void setTexts(Email email, MimeMultipart multipartAlternativeMessages) throws MessagingException {
        if (email.getPlainText() != null) {
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(email.getPlainText(), CHARACTER_ENCODING);
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePart);
        }
        if (email.getHTMLText() != null) {
            MimeBodyPart messagePartHTML = new MimeBodyPart();
            messagePartHTML.setContent((Object)email.getHTMLText(), "text/html; charset=\"" + CHARACTER_ENCODING + "\"");
            multipartAlternativeMessages.addBodyPart((BodyPart)messagePartHTML);
        }
    }

    private static void configureForwarding(@Nonnull Email email, @Nonnull MimeMultipart multipartRootMixed) {
        if (email.getEmailToForward() != null) {
            try {
                MimeBodyPart fordwardedMessage = new MimeBodyPart();
                fordwardedMessage.setContent((Object)email.getEmailToForward(), "message/rfc822");
                multipartRootMixed.addBodyPart((BodyPart)fordwardedMessage);
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }

    private static void setEmbeddedImages(Email email, MimeMultipart multipartRelated) throws MessagingException {
        for (AttachmentResource embeddedImage : email.getEmbeddedImages()) {
            multipartRelated.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(embeddedImage, "inline"));
        }
    }

    private static void setAttachments(Email email, MimeMultipart multipartRoot) throws MessagingException {
        for (AttachmentResource resource : email.getAttachments()) {
            multipartRoot.addBodyPart(MimeMessageHelper.getBodyPartFromDatasource(resource, "attachment"));
        }
    }

    private static void setHeaders(Email email, Message message) throws UnsupportedEncodingException, MessagingException {
        InternetAddress address;
        for (Map.Entry<String, String> header : email.getHeaders().entrySet()) {
            String headerName = header.getKey();
            String headerValue = MimeUtility.encodeText((String)header.getValue(), (String)CHARACTER_ENCODING, null);
            String foldedHeaderValue = MimeUtility.fold((int)(headerName.length() + 2), (String)headerValue);
            message.addHeader(header.getKey(), foldedHeaderValue);
        }
        if (email.isUseDispositionNotificationTo()) {
            address = new InternetAddress(email.getDispositionNotificationTo().getAddress(), email.getDispositionNotificationTo().getName(), CHARACTER_ENCODING);
            message.setHeader("Disposition-Notification-To", address.toString());
        }
        if (email.isUseReturnReceiptTo()) {
            address = new InternetAddress(email.getReturnReceiptTo().getAddress(), email.getReturnReceiptTo().getName(), CHARACTER_ENCODING);
            message.setHeader("Return-Receipt-To", address.toString());
        }
    }

    private static BodyPart getBodyPartFromDatasource(AttachmentResource attachmentResource, String dispositionType) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        String resourceName = MimeMessageHelper.determineResourceName(attachmentResource, false);
        String fileName = MimeMessageHelper.determineResourceName(attachmentResource, true);
        attachmentPart.setDataHandler(new DataHandler((DataSource)new NamedDataSource(fileName, attachmentResource.getDataSource())));
        attachmentPart.setFileName(fileName);
        String contentType = attachmentResource.getDataSource().getContentType();
        ParameterList pl = new ParameterList();
        pl.set("filename", fileName);
        pl.set("name", resourceName);
        attachmentPart.setHeader("Content-Type", contentType + pl.toString());
        attachmentPart.setHeader("Content-ID", String.format("<%s>", resourceName));
        attachmentPart.setDisposition(dispositionType);
        return attachmentPart;
    }

    static String determineResourceName(AttachmentResource attachmentResource, boolean includeExtension) {
        String datasourceName = attachmentResource.getDataSource().getName();
        String resourceName = !MiscUtil.valueNullOrEmpty(attachmentResource.getName()) ? attachmentResource.getName() : (!MiscUtil.valueNullOrEmpty(datasourceName) ? datasourceName : "resource" + UUID.randomUUID());
        if (includeExtension && !MiscUtil.valueNullOrEmpty(datasourceName)) {
            String extension;
            String possibleFilename = datasourceName;
            if (possibleFilename.contains(".") && !resourceName.endsWith(extension = possibleFilename.substring(possibleFilename.lastIndexOf("."), possibleFilename.length()))) {
                resourceName = resourceName + extension;
            }
        } else if (!includeExtension && resourceName.contains(".") && resourceName.equals(datasourceName)) {
            String extension = resourceName.substring(resourceName.lastIndexOf("."), resourceName.length());
            resourceName = resourceName.replace(extension, "");
        }
        return resourceName;
    }

    public static MimeMessage signMessageWithDKIM(MimeMessage messageToSign, Email emailContainingSigningDetails) {
        if (!MiscUtil.classAvailable("net.markenwerk.utils.mail.dkim.DkimSigner")) {
            throw new MimeMessageParseException("DKIM library not found, make sure it is on the classpath (https://github.com/markenwerk/java-utils-mail-dkim)", null);
        }
        try {
            return ((IDKIMSigner)Class.forName("org.simplejavamail.converter.internal.mimemessage.DKIMSigner").newInstance()).signMessageWithDKIM(messageToSign, emailContainingSigningDetails);
        }
        catch (Exception e) {
            throw new MimeMessageParseException(e.getMessage(), e);
        }
    }

    private static class MimeEmailMessageWrapper {
        private final MimeMultipart multipartRootMixed = new MimeMultipart("mixed");
        private final MimeMultipart multipartRelated;
        private final MimeMultipart multipartAlternativeMessages;

        MimeEmailMessageWrapper() {
            MimeBodyPart contentRelated = new MimeBodyPart();
            this.multipartRelated = new MimeMultipart("related");
            MimeBodyPart contentAlternativeMessages = new MimeBodyPart();
            this.multipartAlternativeMessages = new MimeMultipart("alternative");
            try {
                this.multipartRootMixed.addBodyPart((BodyPart)contentRelated);
                contentRelated.setContent((Multipart)this.multipartRelated);
                this.multipartRelated.addBodyPart((BodyPart)contentAlternativeMessages);
                contentAlternativeMessages.setContent((Multipart)this.multipartAlternativeMessages);
            }
            catch (MessagingException e) {
                throw new MimeMessageParseException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

