/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataSource;
import javax.annotation.Nonnull;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.simplejavamail.converter.EmailConverterException;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageHelper;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageParser;
import org.simplejavamail.converter.internal.msgparser.OutlookMessageParser;
import org.simplejavamail.email.Email;
import org.simplejavamail.email.EmailBuilder;
import org.simplejavamail.email.EmailPopulatingBuilder;
import org.simplejavamail.internal.util.MiscUtil;
import org.simplejavamail.internal.util.Preconditions;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookFileAttachment;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookMessage;
import org.simplejavamail.outlookmessageparser.simplejavamail.model.OutlookRecipient;

public final class EmailConverter {
    private EmailConverter() {
    }

    public static Email mimeMessageToEmail(@Nonnull MimeMessage mimeMessage) {
        return EmailConverter.mimeMessageToEmailBuilder(mimeMessage).buildEmail();
    }

    public static EmailPopulatingBuilder mimeMessageToEmailBuilder(@Nonnull MimeMessage mimeMessage) {
        Preconditions.checkNonEmptyArgument(mimeMessage, "mimeMessage");
        EmailPopulatingBuilder emailPopulatingBuilder = EmailBuilder.ignoringDefaults().startingBlank();
        EmailConverter.buildEmailFromMimeMessage(emailPopulatingBuilder, MimeMessageParser.parseMimeMessage(mimeMessage));
        return emailPopulatingBuilder;
    }

    public static Email outlookMsgToEmail(@Nonnull String msgData) {
        EmailPopulatingBuilder emailPopulatingBuilder = EmailBuilder.ignoringDefaults().startingBlank();
        OutlookMessage outlookMessage = OutlookMessageParser.parseOutlookMsg(Preconditions.checkNonEmptyArgument(msgData, "msgData"));
        EmailConverter.buildEmailFromOutlookMessage(emailPopulatingBuilder, outlookMessage);
        return emailPopulatingBuilder.buildEmail();
    }

    public static Email outlookMsgToEmail(@Nonnull File msgfile) {
        EmailPopulatingBuilder emailPopulatingBuilder = EmailBuilder.ignoringDefaults().startingBlank();
        OutlookMessage outlookMessage = OutlookMessageParser.parseOutlookMsg(Preconditions.checkNonEmptyArgument(msgfile, "msgfile"));
        EmailConverter.buildEmailFromOutlookMessage(emailPopulatingBuilder, outlookMessage);
        return emailPopulatingBuilder.buildEmail();
    }

    public static Email outlookMsgToEmail(@Nonnull InputStream msgInputStream) {
        return EmailConverter.outlookMsgToEmailBuilder(msgInputStream).buildEmail();
    }

    public static EmailPopulatingBuilder outlookMsgToEmailBuilder(@Nonnull InputStream msgInputStream) {
        EmailPopulatingBuilder emailPopulatingBuilder = EmailBuilder.ignoringDefaults().startingBlank();
        OutlookMessage outlookMessage = OutlookMessageParser.parseOutlookMsg(Preconditions.checkNonEmptyArgument(msgInputStream, "msgInputStream"));
        EmailConverter.buildEmailFromOutlookMessage(emailPopulatingBuilder, outlookMessage);
        return emailPopulatingBuilder;
    }

    public static Email emlToEmail(@Nonnull String eml) {
        MimeMessage mimeMessage = EmailConverter.emlToMimeMessage(Preconditions.checkNonEmptyArgument(eml, "eml"), EmailConverter.createDummySession());
        return EmailConverter.mimeMessageToEmail(mimeMessage);
    }

    @Nonnull
    public static MimeMessage outlookMsgToMimeMessage(@Nonnull String outlookMsgData) {
        Preconditions.checkNonEmptyArgument(outlookMsgData, "outlookMsgData");
        return EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(outlookMsgData));
    }

    @Nonnull
    public static MimeMessage outlookMsgToMimeMessage(@Nonnull File outlookMsgFile) {
        Preconditions.checkNonEmptyArgument(outlookMsgFile, "outlookMsgFile");
        return EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(outlookMsgFile));
    }

    @Nonnull
    public static MimeMessage outlookMsgToMimeMessage(@Nonnull InputStream outloookMsgInputStream) {
        Preconditions.checkNonEmptyArgument(outloookMsgInputStream, "outloookMsgInputStream");
        return EmailConverter.emailToMimeMessage(EmailConverter.outlookMsgToEmail(outloookMsgInputStream));
    }

    public static MimeMessage emailToMimeMessage(@Nonnull Email email) {
        return EmailConverter.emailToMimeMessage(Preconditions.checkNonEmptyArgument(email, "email"), EmailConverter.createDummySession());
    }

    public static MimeMessage emailToMimeMessage(@Nonnull Email email, @Nonnull Session session) {
        try {
            return MimeMessageHelper.produceMimeMessage(Preconditions.checkNonEmptyArgument(email, "email"), Preconditions.checkNonEmptyArgument(session, "session"));
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static MimeMessage emlToMimeMessage(@Nonnull String eml) {
        return EmailConverter.emlToMimeMessage(Preconditions.checkNonEmptyArgument(eml, "eml"), EmailConverter.createDummySession());
    }

    public static MimeMessage emlToMimeMessage(@Nonnull String eml, @Nonnull Session session) {
        Preconditions.checkNonEmptyArgument(session, "session");
        Preconditions.checkNonEmptyArgument(eml, "eml");
        try {
            return new MimeMessage(session, (InputStream)new ByteArrayInputStream(eml.getBytes(StandardCharsets.UTF_8)));
        }
        catch (MessagingException e) {
            throw new EmailConverterException(String.format("Error parsing EML data: %s", e.getMessage()), (Exception)((Object)e));
        }
    }

    public static String mimeMessageToEML(@Nonnull MimeMessage mimeMessage) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            Preconditions.checkNonEmptyArgument(mimeMessage, "mimeMessage").writeTo((OutputStream)os);
            return os.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException | MessagingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String emailToEML(@Nonnull Email email) {
        return EmailConverter.mimeMessageToEML(EmailConverter.emailToMimeMessage(Preconditions.checkNonEmptyArgument(email, "email")));
    }

    @Nonnull
    public static String outlookMsgToEML(@Nonnull String outlookMsgData) {
        Preconditions.checkNonEmptyArgument(outlookMsgData, "outlookMsgData");
        return EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(outlookMsgData));
    }

    @Nonnull
    public static String outlookMsgToEML(@Nonnull File outlookMsgFile) {
        Preconditions.checkNonEmptyArgument(outlookMsgFile, "outlookMsgFile");
        return EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(outlookMsgFile));
    }

    @Nonnull
    public static String outlookMsgToEML(@Nonnull InputStream outloookMsgInputStream) {
        Preconditions.checkNonEmptyArgument(outloookMsgInputStream, "outloookMsgInputStream");
        return EmailConverter.emailToEML(EmailConverter.outlookMsgToEmail(outloookMsgInputStream));
    }

    private static void buildEmailFromMimeMessage(@Nonnull EmailPopulatingBuilder builder, @Nonnull MimeMessageParser.ParsedMimeMessageComponents parsed) {
        InternetAddress bTo;
        InternetAddress rrTo;
        Preconditions.checkNonEmptyArgument(builder, "emailBuilder");
        Preconditions.checkNonEmptyArgument(parsed, "parsedMimeMessageComponents");
        if (parsed.getFromAddress() != null) {
            builder.from(parsed.getFromAddress().getPersonal(), parsed.getFromAddress().getAddress());
        }
        if (parsed.getReplyToAddresses() != null) {
            builder.withReplyTo(parsed.getReplyToAddresses().getPersonal(), parsed.getReplyToAddresses().getAddress());
        }
        builder.withHeaders(parsed.getHeaders());
        InternetAddress dnTo = parsed.getDispositionNotificationTo();
        if (dnTo != null) {
            builder.withDispositionNotificationTo(dnTo);
        }
        if ((rrTo = parsed.getReturnReceiptTo()) != null) {
            builder.withReturnReceiptTo(rrTo);
        }
        if ((bTo = parsed.getBounceToAddress()) != null) {
            builder.withBounceTo(bTo);
        }
        builder.fixingMessageId(parsed.getMessageId());
        for (InternetAddress internetAddress : parsed.getToAddresses()) {
            builder.to(internetAddress);
        }
        for (InternetAddress internetAddress : parsed.getCcAddresses()) {
            builder.cc(internetAddress);
        }
        for (InternetAddress internetAddress : parsed.getBccAddresses()) {
            builder.bcc(internetAddress);
        }
        builder.withSubject(parsed.getSubject() != null ? parsed.getSubject() : "");
        builder.withPlainText(parsed.getPlainContent());
        builder.withHTMLText(parsed.getHtmlContent());
        for (Map.Entry entry : parsed.getCidMap().entrySet()) {
            String cidName = (String)Preconditions.checkNonEmptyArgument(entry.getKey(), "cid.key");
            builder.withEmbeddedImage(MiscUtil.extractCID(cidName), (DataSource)entry.getValue());
        }
        for (Map.Entry entry : parsed.getAttachmentList()) {
            builder.withAttachment(MiscUtil.extractCID((String)entry.getKey()), (DataSource)entry.getValue());
        }
    }

    private static void buildEmailFromOutlookMessage(@Nonnull EmailPopulatingBuilder builder, @Nonnull OutlookMessage outlookMessage) {
        Preconditions.checkNonEmptyArgument(builder, "emailBuilder");
        Preconditions.checkNonEmptyArgument(outlookMessage, "outlookMessage");
        builder.from(outlookMessage.getFromName(), outlookMessage.getFromEmail());
        if (!MiscUtil.valueNullOrEmpty(outlookMessage.getReplyToEmail())) {
            builder.withReplyTo(outlookMessage.getReplyToName(), outlookMessage.getReplyToEmail());
        }
        for (OutlookRecipient outlookRecipient : outlookMessage.getRecipients()) {
            builder.to(outlookRecipient.getName(), outlookRecipient.getAddress());
        }
        for (OutlookRecipient outlookRecipient : outlookMessage.getCcRecipients()) {
            builder.cc(outlookRecipient.getName(), outlookRecipient.getAddress());
        }
        for (OutlookRecipient outlookRecipient : outlookMessage.getBccRecipients()) {
            builder.bcc(outlookRecipient.getName(), outlookRecipient.getAddress());
        }
        builder.withSubject(outlookMessage.getSubject());
        builder.withPlainText(outlookMessage.getBodyText());
        builder.withHTMLText(outlookMessage.getBodyHTML() != null ? outlookMessage.getBodyHTML() : outlookMessage.getConvertedBodyHTML());
        for (Map.Entry entry : outlookMessage.fetchCIDMap().entrySet()) {
            String cidName = (String)Preconditions.checkNonEmptyArgument(entry.getKey(), "cid.key");
            builder.withEmbeddedImage(MiscUtil.extractCID(cidName), ((OutlookFileAttachment)entry.getValue()).getData(), ((OutlookFileAttachment)entry.getValue()).getMimeTag());
        }
        for (OutlookFileAttachment outlookFileAttachment : outlookMessage.fetchTrueAttachments()) {
            builder.withAttachment(outlookFileAttachment.getLongFilename(), outlookFileAttachment.getData(), outlookFileAttachment.getMimeTag());
        }
    }

    private static Session createDummySession() {
        return Session.getDefaultInstance((Properties)new Properties());
    }
}

