/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.internal.util;

import jakarta.activation.DataSource;
import jakarta.mail.EncodingAware;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.internal.util.MiscUtil;

public class NamedDataSource
implements DataSource,
EncodingAware {
    private final DataSource dataSource;
    private final String name;

    public NamedDataSource(String name, DataSource dataSource) {
        this.dataSource = dataSource;
        this.name = name;
    }

    public InputStream getInputStream() throws IOException {
        return this.dataSource.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.dataSource.getOutputStream();
    }

    public String getContentType() {
        return MiscUtil.parseBaseMimeType(this.dataSource.getContentType());
    }

    public String getName() {
        return !MiscUtil.valueNullOrEmpty(this.name) ? this.name : this.dataSource.getName();
    }

    @Nullable
    public String getEncoding() {
        return this.dataSource instanceof EncodingAware ? ((EncodingAware)this.dataSource).getEncoding() : null;
    }
}

