/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.emulation.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v142.emulation.model.ScreenId;
import org.openqa.selenium.devtools.v142.emulation.model.ScreenOrientation;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ScreenInfo {
    private final Integer left;
    private final Integer top;
    private final Integer width;
    private final Integer height;
    private final Integer availLeft;
    private final Integer availTop;
    private final Integer availWidth;
    private final Integer availHeight;
    private final Number devicePixelRatio;
    private final ScreenOrientation orientation;
    private final Integer colorDepth;
    private final Boolean isExtended;
    private final Boolean isInternal;
    private final Boolean isPrimary;
    private final String label;
    private final ScreenId id;

    public ScreenInfo(Integer left, Integer top, Integer width, Integer height, Integer availLeft, Integer availTop, Integer availWidth, Integer availHeight, Number devicePixelRatio, ScreenOrientation orientation, Integer colorDepth, Boolean isExtended, Boolean isInternal, Boolean isPrimary, String label, ScreenId id) {
        this.left = Objects.requireNonNull(left, "left is required");
        this.top = Objects.requireNonNull(top, "top is required");
        this.width = Objects.requireNonNull(width, "width is required");
        this.height = Objects.requireNonNull(height, "height is required");
        this.availLeft = Objects.requireNonNull(availLeft, "availLeft is required");
        this.availTop = Objects.requireNonNull(availTop, "availTop is required");
        this.availWidth = Objects.requireNonNull(availWidth, "availWidth is required");
        this.availHeight = Objects.requireNonNull(availHeight, "availHeight is required");
        this.devicePixelRatio = Objects.requireNonNull(devicePixelRatio, "devicePixelRatio is required");
        this.orientation = Objects.requireNonNull(orientation, "orientation is required");
        this.colorDepth = Objects.requireNonNull(colorDepth, "colorDepth is required");
        this.isExtended = Objects.requireNonNull(isExtended, "isExtended is required");
        this.isInternal = Objects.requireNonNull(isInternal, "isInternal is required");
        this.isPrimary = Objects.requireNonNull(isPrimary, "isPrimary is required");
        this.label = Objects.requireNonNull(label, "label is required");
        this.id = Objects.requireNonNull(id, "id is required");
    }

    public Integer getLeft() {
        return this.left;
    }

    public Integer getTop() {
        return this.top;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getAvailLeft() {
        return this.availLeft;
    }

    public Integer getAvailTop() {
        return this.availTop;
    }

    public Integer getAvailWidth() {
        return this.availWidth;
    }

    public Integer getAvailHeight() {
        return this.availHeight;
    }

    public Number getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    public ScreenOrientation getOrientation() {
        return this.orientation;
    }

    public Integer getColorDepth() {
        return this.colorDepth;
    }

    public Boolean getIsExtended() {
        return this.isExtended;
    }

    public Boolean getIsInternal() {
        return this.isInternal;
    }

    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    public String getLabel() {
        return this.label;
    }

    public ScreenId getId() {
        return this.id;
    }

    private static ScreenInfo fromJson(JsonInput input) {
        Integer left = 0;
        Integer top = 0;
        Integer width = 0;
        Integer height = 0;
        Integer availLeft = 0;
        Integer availTop = 0;
        Integer availWidth = 0;
        Integer availHeight = 0;
        Number devicePixelRatio = 0;
        ScreenOrientation orientation = null;
        Integer colorDepth = 0;
        Boolean isExtended = false;
        Boolean isInternal = false;
        Boolean isPrimary = false;
        String label = null;
        ScreenId id = null;
        input.beginObject();
        block36: while (input.hasNext()) {
            switch (input.nextName()) {
                case "left": {
                    left = input.nextNumber().intValue();
                    continue block36;
                }
                case "top": {
                    top = input.nextNumber().intValue();
                    continue block36;
                }
                case "width": {
                    width = input.nextNumber().intValue();
                    continue block36;
                }
                case "height": {
                    height = input.nextNumber().intValue();
                    continue block36;
                }
                case "availLeft": {
                    availLeft = input.nextNumber().intValue();
                    continue block36;
                }
                case "availTop": {
                    availTop = input.nextNumber().intValue();
                    continue block36;
                }
                case "availWidth": {
                    availWidth = input.nextNumber().intValue();
                    continue block36;
                }
                case "availHeight": {
                    availHeight = input.nextNumber().intValue();
                    continue block36;
                }
                case "devicePixelRatio": {
                    devicePixelRatio = input.nextNumber();
                    continue block36;
                }
                case "orientation": {
                    orientation = (ScreenOrientation)input.read(ScreenOrientation.class);
                    continue block36;
                }
                case "colorDepth": {
                    colorDepth = input.nextNumber().intValue();
                    continue block36;
                }
                case "isExtended": {
                    isExtended = input.nextBoolean();
                    continue block36;
                }
                case "isInternal": {
                    isInternal = input.nextBoolean();
                    continue block36;
                }
                case "isPrimary": {
                    isPrimary = input.nextBoolean();
                    continue block36;
                }
                case "label": {
                    label = input.nextString();
                    continue block36;
                }
                case "id": {
                    id = (ScreenId)input.read(ScreenId.class);
                    continue block36;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ScreenInfo(left, top, width, height, availLeft, availTop, availWidth, availHeight, devicePixelRatio, orientation, colorDepth, isExtended, isInternal, isPrimary, label, id);
    }
}

