/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v141.css.model.SourceRange;
import org.openqa.selenium.devtools.v141.css.model.Specificity;
import org.openqa.selenium.json.JsonInput;

public class Value {
    private final String text;
    private final Optional<SourceRange> range;
    private final Optional<Specificity> specificity;

    public Value(String text, Optional<SourceRange> range, Optional<Specificity> specificity) {
        this.text = Objects.requireNonNull(text, "text is required");
        this.range = range;
        this.specificity = specificity;
    }

    public String getText() {
        return this.text;
    }

    public Optional<SourceRange> getRange() {
        return this.range;
    }

    @Beta
    public Optional<Specificity> getSpecificity() {
        return this.specificity;
    }

    private static Value fromJson(JsonInput input) {
        String text = null;
        Optional<SourceRange> range = Optional.empty();
        Optional<Specificity> specificity = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "text": {
                    text = input.nextString();
                    continue block10;
                }
                case "range": {
                    range = Optional.ofNullable((SourceRange)input.read(SourceRange.class));
                    continue block10;
                }
                case "specificity": {
                    specificity = Optional.ofNullable((Specificity)input.read(Specificity.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Value(text, range, specificity);
    }
}

