/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeMessageEndpoint;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNIMethodScope;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativebridge.BinaryInput;
import org.graalvm.nativebridge.BinaryMarshaller;
import org.graalvm.nativebridge.BinaryOutput;
import org.graalvm.nativebridge.ForeignException;
import org.graalvm.nativebridge.JNIConfig;
import org.graalvm.nativebridge.NativeIsolate;
import org.graalvm.nativebridge.NativeIsolateThread;
import org.graalvm.nativebridge.NativeObjectHandles;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.polyglot.io.MessageEndpoint;
import org.graalvm.word.PointerBase;

final class NativeMessageEndpointGen {
    NativeMessageEndpointGen() {
    }

    static NativeMessageEndpoint createHSToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeMessageEndpoint createNativeToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeMessageEndpoint create(NativeIsolate nativeIsolate, long l2) {
        if (ImageInfo.inImageCode()) {
            return NativeMessageEndpointGen.createNativeToNative(nativeIsolate, l2);
        }
        return NativeMessageEndpointGen.createHSToNative(nativeIsolate, l2);
    }

    private static final class StartPoint
    extends NativeMessageEndpoint {
        private static final BinaryMarshaller<ByteBuffer> byteBufferMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(NativeIsolate nativeIsolate, long l2) {
            super(nativeIsolate, l2);
        }

        public void sendBinary(ByteBuffer byteBuffer) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n2 = byteBufferMarshaller.inferSize((Object)byteBuffer);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create((int)n2);
                byteBufferMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)byteBuffer);
                StartPoint.sendBinary0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), byteArrayBinaryOutput.getArray());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public void sendClose() throws IOException {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                StartPoint.sendClose0(nativeIsolateThread.getIsolateThreadId(), this.getHandle());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public void sendPing(ByteBuffer byteBuffer) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n2 = byteBufferMarshaller.inferSize((Object)byteBuffer);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create((int)n2);
                byteBufferMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)byteBuffer);
                StartPoint.sendPing0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), byteArrayBinaryOutput.getArray());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public void sendPong(ByteBuffer byteBuffer) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                int n2 = byteBufferMarshaller.inferSize((Object)byteBuffer);
                BinaryOutput.ByteArrayBinaryOutput byteArrayBinaryOutput = BinaryOutput.ByteArrayBinaryOutput.create((int)n2);
                byteBufferMarshaller.write((BinaryOutput)byteArrayBinaryOutput, (Object)byteBuffer);
                StartPoint.sendPong0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), byteArrayBinaryOutput.getArray());
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        public void sendText(String string) throws IOException {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                StartPoint.sendText0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), string);
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native void sendBinary0(long var0, long var2, byte[] var4) throws IOException;

        private static native void sendClose0(long var0, long var2) throws IOException;

        private static native void sendPing0(long var0, long var2, byte[] var4) throws IOException;

        private static native void sendPong0(long var0, long var2, byte[] var4) throws IOException;

        private static native void sendText0(long var0, long var2, String var4) throws IOException;

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            byteBufferMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<ByteBuffer> byteBufferMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeMessageEndpointGen_00024StartPoint_sendBinary0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void sendBinary(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JByteArray jByteArray) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeMessageEndpointGen::sendBinary", jNIEnv);){
                MessageEndpoint messageEndpoint = (MessageEndpoint)NativeObjectHandles.resolve((long)l3, MessageEndpoint.class);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                int n2 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray);
                CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc((int)n2);
                try {
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n2, (CCharPointer)cCharPointer2);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n2);
                    ByteBuffer byteBuffer = (ByteBuffer)byteBufferMarshaller.read(binaryInput);
                    messageEndpoint.sendBinary(byteBuffer);
                }
                finally {
                    if (cCharPointer2 != cCharPointer) {
                        UnmanagedMemory.free((PointerBase)cCharPointer2);
                    }
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeMessageEndpointGen_00024StartPoint_sendClose0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void sendClose(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeMessageEndpointGen::sendClose", jNIEnv);){
                MessageEndpoint messageEndpoint = (MessageEndpoint)NativeObjectHandles.resolve((long)l3, MessageEndpoint.class);
                messageEndpoint.sendClose();
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeMessageEndpointGen_00024StartPoint_sendPing0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void sendPing(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JByteArray jByteArray) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeMessageEndpointGen::sendPing", jNIEnv);){
                MessageEndpoint messageEndpoint = (MessageEndpoint)NativeObjectHandles.resolve((long)l3, MessageEndpoint.class);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                int n2 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray);
                CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc((int)n2);
                try {
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n2, (CCharPointer)cCharPointer2);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n2);
                    ByteBuffer byteBuffer = (ByteBuffer)byteBufferMarshaller.read(binaryInput);
                    messageEndpoint.sendPing(byteBuffer);
                }
                finally {
                    if (cCharPointer2 != cCharPointer) {
                        UnmanagedMemory.free((PointerBase)cCharPointer2);
                    }
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeMessageEndpointGen_00024StartPoint_sendPong0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void sendPong(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JByteArray jByteArray) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeMessageEndpointGen::sendPong", jNIEnv);){
                MessageEndpoint messageEndpoint = (MessageEndpoint)NativeObjectHandles.resolve((long)l3, MessageEndpoint.class);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get((int)256);
                int n2 = JNIUtil.GetArrayLength((JNI.JNIEnv)jNIEnv, (JNI.JArray)jByteArray);
                CCharPointer cCharPointer2 = n2 <= 256 ? cCharPointer : (CCharPointer)UnmanagedMemory.malloc((int)n2);
                try {
                    JNIUtil.GetByteArrayRegion((JNI.JNIEnv)jNIEnv, (JNI.JByteArray)jByteArray, (int)0, (int)n2, (CCharPointer)cCharPointer2);
                    BinaryInput binaryInput = BinaryInput.create((CCharPointer)cCharPointer2, (int)n2);
                    ByteBuffer byteBuffer = (ByteBuffer)byteBufferMarshaller.read(binaryInput);
                    messageEndpoint.sendPong(byteBuffer);
                }
                finally {
                    if (cCharPointer2 != cCharPointer) {
                        UnmanagedMemory.free((PointerBase)cCharPointer2);
                    }
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeMessageEndpointGen_00024StartPoint_sendText0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static void sendText(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JString jString) {
            try (JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeMessageEndpointGen::sendText", jNIEnv);){
                MessageEndpoint messageEndpoint = (MessageEndpoint)NativeObjectHandles.resolve((long)l3, MessageEndpoint.class);
                messageEndpoint.sendText(JNIUtil.createString((JNI.JNIEnv)jNIEnv, (JNI.JString)jString));
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable((Throwable)throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
            }
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            byteBufferMarshaller = jNIConfig.lookupMarshaller(ByteBuffer.class, new Class[0]);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

