/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.IndexOfCodePointSet;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringInternalNodes;
import com.oracle.truffle.api.strings.TStringOpsNodes;
import com.oracle.truffle.api.strings.TStringOpsNodesFactory;
import com.oracle.truffle.api.strings.TranscodingErrorHandler;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderFactory;
import com.oracle.truffle.api.strings.TruffleStringFactory;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import com.oracle.truffle.api.strings.TruffleStringIteratorFactory;
import java.lang.invoke.MethodHandles;

@GeneratedBy(value=TStringInternalNodes.class)
final class TStringInternalNodesFactory {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final TruffleString.CompactionLevel[] COMPACTION_LEVEL_VALUES = (TruffleString.CompactionLevel[])DSLSupport.lookupEnumConstants(TruffleString.CompactionLevel.class);

    TStringInternalNodesFactory() {
    }

    private static TruffleString.CompactionLevel decodeCompactionLevel(int state) {
        if (state >= 0) {
            return COMPACTION_LEVEL_VALUES[state];
        }
        return null;
    }

    private static int encodeCompactionLevel(TruffleString.CompactionLevel e) {
        if (e != null) {
            return e.ordinal();
        }
        return -1;
    }

    @GeneratedBy(value=TStringInternalNodes.TransCodeIntlNode.class)
    static final class TransCodeIntlNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        TransCodeIntlNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException8LLLIILLL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, int arg4Value, Object arg5Value, Object arg6Value, Object arg7Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
        }

        @NeverDefault
        public static TStringInternalNodes.TransCodeIntlNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.TransCodeIntlNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=32, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=23, value=InlineSupport.StateField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.TransCodeIntlNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.TransCodeIntlNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, TruffleString.Encoding arg5Value, TruffleString.Encoding arg6Value, TranscodingErrorHandler arg7Value) {
                if (TStringGuards.isSupportedEncoding(arg5Value) && (TStringGuards.isAscii(arg6Value) || TStringGuards.isBytes(arg6Value))) {
                    return TStringInternalNodes.TransCodeIntlNode.targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached());
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && TStringGuards.isLatin1(arg6Value)) {
                    return TStringInternalNodes.TransCodeIntlNode.latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached());
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF8(arg6Value)) {
                    return TStringInternalNodes.TransCodeIntlNode.utf8TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF8(arg6Value)) {
                    return TStringInternalNodes.TransCodeIntlNode.utf8TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), InlinedConditionProfile.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (TStringGuards.isUTF32(arg5Value) && TStringGuards.isUTF16(arg6Value)) {
                    return this.utf16Fixed32Bit(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF16(arg6Value)) {
                    return TStringInternalNodes.TransCodeIntlNode.utf16TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF16(arg6Value)) {
                    return TStringInternalNodes.TransCodeIntlNode.utf16TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                if (!TStringGuards.isUTF16(arg5Value) && TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF32(arg6Value)) {
                    return TStringInternalNodes.TransCodeIntlNode.utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached());
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF32(arg6Value)) {
                    return TStringInternalNodes.TransCodeIntlNode.utf32TranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF16(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF32(arg6Value)) {
                    return TStringInternalNodes.TransCodeIntlNode.utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached());
                }
                if (TStringGuards.isUnsupportedEncoding(arg5Value) || TStringGuards.isUnsupportedEncoding(arg6Value)) {
                    return TStringInternalNodes.TransCodeIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, FromBufferWithStringCompactionNodeGen.getUncached());
                }
                throw TransCodeIntlNodeGen.newUnsupportedSpecializationException8LLLIILLL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (Object)arg5Value, (Object)arg6Value, arg7Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.TransCodeIntlNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.TransCodeIntlNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final TruffleStringIterator.InternalNextNode iteratorNextNode;
            private final InlinedConditionProfile brokenProfile;
            private final InlinedBranchProfile outOfMemoryProfile;
            private final TStringInternalNodes.FromBufferWithStringCompactionNode unsupported_fromBufferWithStringCompactionNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.TransCodeIntlNode.class));
                this.state_0_ = target.getState(0, 32);
                this.state_1_ = target.getState(1, 23);
                this.iteratorNextNode = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_0_.subUpdater(11, 21)));
                this.brokenProfile = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_1_.subUpdater(0, 2)));
                this.outOfMemoryProfile = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_1_.subUpdater(2, 1)));
                this.unsupported_fromBufferWithStringCompactionNode_ = FromBufferWithStringCompactionNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.FromBufferWithStringCompactionNode.class, this.state_1_.subUpdater(3, 20)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, TruffleString.Encoding arg5Value, TruffleString.Encoding arg6Value, TranscodingErrorHandler arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x7FF) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isSupportedEncoding(arg5Value) && (TStringGuards.isAscii(arg6Value) || TStringGuards.isBytes(arg6Value))) {
                        return TStringInternalNodes.TransCodeIntlNode.targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isSupportedEncoding(arg5Value) && TStringGuards.isLatin1(arg6Value)) {
                        return TStringInternalNodes.TransCodeIntlNode.latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isSupportedEncoding(arg5Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF8(arg6Value)) {
                        return TStringInternalNodes.TransCodeIntlNode.utf8TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isSupportedEncoding(arg5Value) && TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF8(arg6Value)) {
                        return TStringInternalNodes.TransCodeIntlNode.utf8TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isUTF32(arg5Value) && TStringGuards.isUTF16(arg6Value)) {
                        return this.utf16Fixed32Bit(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 0x20) != 0 && TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF16(arg6Value)) {
                        return TStringInternalNodes.TransCodeIntlNode.utf16TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode, this.outOfMemoryProfile);
                    }
                    if ((state_0 & 0x40) != 0 && TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF16(arg6Value)) {
                        return TStringInternalNodes.TransCodeIntlNode.utf16TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode, this.outOfMemoryProfile);
                    }
                    if ((state_0 & 0x80) != 0 && !TStringGuards.isUTF16(arg5Value) && TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF32(arg6Value)) {
                        return TStringInternalNodes.TransCodeIntlNode.utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode);
                    }
                    if ((state_0 & 0x100) != 0 && TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF32(arg6Value)) {
                        return TStringInternalNodes.TransCodeIntlNode.utf32TranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 0x200) != 0 && TStringGuards.isUTF16(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF32(arg6Value)) {
                        return TStringInternalNodes.TransCodeIntlNode.utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode);
                    }
                    if ((state_0 & 0x400) != 0 && (TStringGuards.isUnsupportedEncoding(arg5Value) || TStringGuards.isUnsupportedEncoding(arg6Value))) {
                        assert (InlineSupport.validate(arg0Value, this.state_1_));
                        return TStringInternalNodes.TransCodeIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.unsupported_fromBufferWithStringCompactionNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private TruffleString executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, TruffleString.Encoding arg5Value, TruffleString.Encoding arg6Value, TranscodingErrorHandler arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isSupportedEncoding(arg5Value) && (TStringGuards.isAscii(arg6Value) || TStringGuards.isBytes(arg6Value))) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return TStringInternalNodes.TransCodeIntlNode.targetAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode);
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && TStringGuards.isLatin1(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return TStringInternalNodes.TransCodeIntlNode.latin1Transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode);
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF8(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return TStringInternalNodes.TransCodeIntlNode.utf8TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF8(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    return TStringInternalNodes.TransCodeIntlNode.utf8TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode, this.brokenProfile, this.outOfMemoryProfile);
                }
                if (TStringGuards.isUTF32(arg5Value) && TStringGuards.isUTF16(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return this.utf16Fixed32Bit(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF16(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    return TStringInternalNodes.TransCodeIntlNode.utf16TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode, this.outOfMemoryProfile);
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF16(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x40);
                    return TStringInternalNodes.TransCodeIntlNode.utf16TranscodeLarge(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode, this.outOfMemoryProfile);
                }
                if (!TStringGuards.isUTF16(arg5Value) && TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF32(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x80);
                    return TStringInternalNodes.TransCodeIntlNode.utf32TranscodeRegular(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode);
                }
                if (TStringGuards.isSupportedEncoding(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF32(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    return TStringInternalNodes.TransCodeIntlNode.utf32TranscodeLarge(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF16(arg5Value) && !TStringGuards.isFixedWidth(arg4Value) && !TStringInternalNodes.TransCodeIntlNode.isLarge(arg3Value) && TStringGuards.isUTF32(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x200);
                    return TStringInternalNodes.TransCodeIntlNode.utf32TranscodeUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.iteratorNextNode);
                }
                if (TStringGuards.isUnsupportedEncoding(arg5Value) || TStringGuards.isUnsupportedEncoding(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x400);
                    assert (InlineSupport.validate(arg0Value, this.state_1_));
                    return TStringInternalNodes.TransCodeIntlNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.unsupported_fromBufferWithStringCompactionNode_);
                }
                throw TransCodeIntlNodeGen.newUnsupportedSpecializationException8LLLIILLL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (Object)arg5Value, (Object)arg6Value, arg7Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.class)
    static final class TransCodeIntlWithErrorHandlerNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        TransCodeIntlWithErrorHandlerNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.TransCodeIntlWithErrorHandlerNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.TransCodeIntlWithErrorHandlerNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=23, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=26, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=24, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=32, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=23, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.TransCodeIntlWithErrorHandlerNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, TruffleString.Encoding arg5Value, TruffleString.Encoding arg6Value, TranscodingErrorHandler arg7Value) {
                if ((TStringGuards.isBroken(arg4Value) || TStringGuards.isAsciiBytesOrLatin1(arg6Value)) && TStringGuards.isSupportedEncoding(arg5Value) && TStringGuards.isSupportedEncoding(arg6Value) && !TStringGuards.isBuiltin(arg7Value)) {
                    return TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.supportedWithCustomErrorHandler(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), TruffleStringBuilderFactory.AppendCodePointIntlNodeGen.getUncached(), TruffleStringBuilderFactory.AppendStringIntlNodeGen.getUncached(), TruffleStringBuilderFactory.ToStringIntlNodeGen.getUncached());
                }
                return TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TransCodeIntlNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.TransCodeIntlWithErrorHandlerNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final InlineSupport.StateField state_2_;
            private final InlineSupport.StateField state_3_;
            private final InlineSupport.StateField state_4_;
            private final InlineSupport.StateField state_5_;
            private final InlineSupport.StateField state_6_;
            private final InlineSupport.StateField state_7_;
            private final InlineSupport.ReferenceField<Node> supportedWithCustomErrorHandler_appendStringNode__field4_;
            private final TruffleStringIterator.InternalNextNode supportedWithCustomErrorHandler_iteratorNextNode_;
            private final TruffleStringBuilder.AppendCodePointIntlNode supportedWithCustomErrorHandler_appendCodePointNode_;
            private final TruffleStringBuilder.AppendStringIntlNode supportedWithCustomErrorHandler_appendStringNode_;
            private final TruffleStringBuilder.ToStringIntlNode supportedWithCustomErrorHandler_toStringNode_;
            private final TStringInternalNodes.TransCodeIntlNode fallback_transCodeIntlNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.class));
                this.state_0_ = target.getState(0, 23);
                this.state_1_ = target.getState(1, 26);
                this.state_2_ = target.getState(2, 25);
                this.state_3_ = target.getState(3, 25);
                this.state_4_ = target.getState(4, 25);
                this.state_5_ = target.getState(5, 24);
                this.state_6_ = target.getState(6, 32);
                this.state_7_ = target.getState(7, 23);
                this.supportedWithCustomErrorHandler_appendStringNode__field4_ = target.getReference(8, Node.class);
                this.supportedWithCustomErrorHandler_iteratorNextNode_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_0_.subUpdater(2, 21)));
                this.supportedWithCustomErrorHandler_appendCodePointNode_ = TruffleStringBuilderFactory.AppendCodePointIntlNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringBuilder.AppendCodePointIntlNode.class, this.state_1_.subUpdater(0, 11)));
                this.supportedWithCustomErrorHandler_appendStringNode_ = TruffleStringBuilderFactory.AppendStringIntlNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringBuilder.AppendStringIntlNode.class, this.state_1_.subUpdater(11, 15), this.state_2_.subUpdater(0, 25), this.state_3_.subUpdater(0, 25), this.state_4_.subUpdater(0, 25), this.supportedWithCustomErrorHandler_appendStringNode__field4_));
                this.supportedWithCustomErrorHandler_toStringNode_ = TruffleStringBuilderFactory.ToStringIntlNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringBuilder.ToStringIntlNode.class, this.state_5_.subUpdater(0, 24)));
                this.fallback_transCodeIntlNode_ = TransCodeIntlNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.TransCodeIntlNode.class, this.state_6_.subUpdater(0, 32), this.state_7_.subUpdater(0, 23)));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, TruffleString.Encoding arg5Value, TruffleString.Encoding arg6Value, TranscodingErrorHandler arg7Value) {
                return (state_0 & 1) != 0 || !TStringGuards.isBroken(arg4Value) && !TStringGuards.isAsciiBytesOrLatin1(arg6Value) || !TStringGuards.isSupportedEncoding(arg5Value) || !TStringGuards.isSupportedEncoding(arg6Value) || TStringGuards.isBuiltin(arg7Value);
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, TruffleString.Encoding arg5Value, TruffleString.Encoding arg6Value, TranscodingErrorHandler arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && (TStringGuards.isBroken(arg4Value) || TStringGuards.isAsciiBytesOrLatin1(arg6Value)) && TStringGuards.isSupportedEncoding(arg5Value) && TStringGuards.isSupportedEncoding(arg6Value) && !TStringGuards.isBuiltin(arg7Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_1_, this.state_2_, this.state_3_, this.state_4_, this.supportedWithCustomErrorHandler_appendStringNode__field4_, this.state_5_));
                        return TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.supportedWithCustomErrorHandler(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.supportedWithCustomErrorHandler_iteratorNextNode_, this.supportedWithCustomErrorHandler_appendCodePointNode_, this.supportedWithCustomErrorHandler_appendStringNode_, this.supportedWithCustomErrorHandler_toStringNode_);
                    }
                    if ((state_0 & 2) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_6_, this.state_7_));
                        return TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_transCodeIntlNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private TruffleString executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, TruffleString.Encoding arg5Value, TruffleString.Encoding arg6Value, TranscodingErrorHandler arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.isBroken(arg4Value) || TStringGuards.isAsciiBytesOrLatin1(arg6Value)) && TStringGuards.isSupportedEncoding(arg5Value) && TStringGuards.isSupportedEncoding(arg6Value) && !TStringGuards.isBuiltin(arg7Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_1_, this.state_2_, this.state_3_, this.state_4_, this.supportedWithCustomErrorHandler_appendStringNode__field4_, this.state_5_));
                    return TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.supportedWithCustomErrorHandler(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.supportedWithCustomErrorHandler_iteratorNextNode_, this.supportedWithCustomErrorHandler_appendCodePointNode_, this.supportedWithCustomErrorHandler_appendStringNode_, this.supportedWithCustomErrorHandler_toStringNode_);
                }
                this.state_0_.set(arg0Value, state_0 |= 2);
                assert (InlineSupport.validate(arg0Value, this.state_6_, this.state_7_));
                return TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fallback_transCodeIntlNode_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.TransCodeNode.class)
    static final class TransCodeNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        TransCodeNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.TransCodeNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.TransCodeNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=26, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=24, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=32, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=23, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.TransCodeNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.TransCodeNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, TruffleString.Encoding arg5Value, TranscodingErrorHandler arg6Value) {
                return TStringInternalNodes.TransCodeNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached(), TransCodeIntlWithErrorHandlerNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.TransCodeNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.TransCodeNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final InlineSupport.StateField state_2_;
            private final InlineSupport.StateField state_3_;
            private final InlineSupport.StateField state_4_;
            private final InlineSupport.StateField state_5_;
            private final InlineSupport.StateField state_6_;
            private final InlineSupport.StateField state_7_;
            private final InlineSupport.ReferenceField<Node> transCodeIntlNode__field8_;
            private final InlinedConditionProfile asciiBytesInvalidProfile_;
            private final TStringInternalNodes.TransCodeIntlWithErrorHandlerNode transCodeIntlNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.TransCodeNode.class));
                this.state_0_ = target.getState(0, 25);
                this.state_1_ = target.getState(1, 26);
                this.state_2_ = target.getState(2, 25);
                this.state_3_ = target.getState(3, 25);
                this.state_4_ = target.getState(4, 25);
                this.state_5_ = target.getState(5, 24);
                this.state_6_ = target.getState(6, 32);
                this.state_7_ = target.getState(7, 23);
                this.transCodeIntlNode__field8_ = target.getReference(8, Node.class);
                this.asciiBytesInvalidProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(0, 2)));
                this.transCodeIntlNode_ = TransCodeIntlWithErrorHandlerNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.TransCodeIntlWithErrorHandlerNode.class, this.state_0_.subUpdater(2, 23), this.state_1_.subUpdater(0, 26), this.state_2_.subUpdater(0, 25), this.state_3_.subUpdater(0, 25), this.state_4_.subUpdater(0, 25), this.state_5_.subUpdater(0, 24), this.state_6_.subUpdater(0, 32), this.state_7_.subUpdater(0, 23), this.transCodeIntlNode__field8_));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, TruffleString.Encoding arg5Value, TranscodingErrorHandler arg6Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_1_, this.state_2_, this.state_3_, this.state_4_, this.state_5_, this.state_6_, this.state_7_, this.transCodeIntlNode__field8_));
                return TStringInternalNodes.TransCodeNode.transcode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.asciiBytesInvalidProfile_, this.transCodeIntlNode_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.ToValidStringNode.class)
    static final class ToValidStringNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        ToValidStringNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException4(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value);
        }

        @NeverDefault
        public static TStringInternalNodes.ToValidStringNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.ToValidStringNode inline(@InlineSupport.RequiredField(bits=8, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.ToValidStringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.ToValidStringNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, TruffleString.Encoding arg3Value) {
                if (TStringGuards.isAscii(arg3Value)) {
                    return TStringInternalNodes.ToValidStringNode.ascii(arg0Value, arg1Value, arg2Value, arg3Value);
                }
                if (TStringGuards.isUTF8(arg3Value)) {
                    return TStringInternalNodes.ToValidStringNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, InlinedBranchProfile.getUncached());
                }
                if (TStringGuards.isUTF16(arg3Value)) {
                    return TStringInternalNodes.ToValidStringNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value);
                }
                if (TStringGuards.isUTF32(arg3Value)) {
                    return TStringInternalNodes.ToValidStringNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUnsupportedEncoding(arg3Value)) {
                    return TStringInternalNodes.ToValidStringNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value);
                }
                throw ToValidStringNodeGen.newUnsupportedSpecializationException4(this, arg0Value, arg1Value, arg2Value, (Object)arg3Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.ToValidStringNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.ToValidStringNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedBranchProfile utf8_outOfMemoryProfile_;
            private final InlinedConditionProfile utf32_strideProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.ToValidStringNode.class));
                this.state_0_ = target.getState(0, 8);
                this.utf8_outOfMemoryProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(5, 1)));
                this.utf32_strideProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(6, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, TruffleString.Encoding arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x1F) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isAscii(arg3Value)) {
                        return TStringInternalNodes.ToValidStringNode.ascii(arg0Value, arg1Value, arg2Value, arg3Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF8(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ToValidStringNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, this.utf8_outOfMemoryProfile_);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF16(arg3Value)) {
                        return TStringInternalNodes.ToValidStringNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value);
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isUTF32(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ToValidStringNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, this.utf32_strideProfile_);
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isUnsupportedEncoding(arg3Value)) {
                        return TStringInternalNodes.ToValidStringNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private TruffleString executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, TruffleString.Encoding arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isAscii(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return TStringInternalNodes.ToValidStringNode.ascii(arg0Value, arg1Value, arg2Value, arg3Value);
                }
                if (TStringGuards.isUTF8(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ToValidStringNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, this.utf8_outOfMemoryProfile_);
                }
                if (TStringGuards.isUTF16(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return TStringInternalNodes.ToValidStringNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value);
                }
                if (TStringGuards.isUTF32(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ToValidStringNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, this.utf32_strideProfile_);
                }
                if (TStringGuards.isUnsupportedEncoding(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return TStringInternalNodes.ToValidStringNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value);
                }
                throw ToValidStringNodeGen.newUnsupportedSpecializationException4(this, arg0Value, arg1Value, arg2Value, (Object)arg3Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.CreateJavaStringNode.class)
    static final class CreateJavaStringNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        CreateJavaStringNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.CreateJavaStringNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.CreateJavaStringNode inline(@InlineSupport.RequiredField(bits=2, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.CreateJavaStringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.CreateJavaStringNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            String execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                return TStringInternalNodes.CreateJavaStringNode.createJavaString(arg0Value, arg1Value, arg2Value, InlinedConditionProfile.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.CreateJavaStringNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.CreateJavaStringNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile reuseProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.CreateJavaStringNode.class));
                this.state_0_ = target.getState(0, 2);
                this.reuseProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(0, 2)));
            }

            @Override
            String execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_));
                return TStringInternalNodes.CreateJavaStringNode.createJavaString(arg0Value, arg1Value, arg2Value, this.reuseProfile_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.FromJavaStringUTF16Node.class)
    static final class FromJavaStringUTF16NodeGen {
        private static final Uncached UNCACHED = new Uncached();

        FromJavaStringUTF16NodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.FromJavaStringUTF16Node getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.FromJavaStringUTF16Node inline(@InlineSupport.RequiredField(bits=2, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.FromJavaStringUTF16Node.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.FromJavaStringUTF16Node
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            TruffleString execute(Node arg0Value, String arg1Value, int arg2Value, int arg3Value, boolean arg4Value) {
                return TStringInternalNodes.FromJavaStringUTF16Node.doNonEmpty(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, InlinedConditionProfile.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.FromJavaStringUTF16Node.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.FromJavaStringUTF16Node
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile utf16CompactProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.FromJavaStringUTF16Node.class));
                this.state_0_ = target.getState(0, 2);
                this.utf16CompactProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(0, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, String arg1Value, int arg2Value, int arg3Value, boolean arg4Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_));
                return TStringInternalNodes.FromJavaStringUTF16Node.doNonEmpty(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.utf16CompactProfile_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.ParseDoubleNode.class)
    static final class ParseDoubleNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        ParseDoubleNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException3(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
        }

        @NeverDefault
        public static TStringInternalNodes.ParseDoubleNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.ParseDoubleNode inline(@InlineSupport.RequiredField(bits=15, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.ParseDoubleNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.ParseDoubleNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            double execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) throws TruffleString.NumberFormatException {
                return TStringInternalNodes.ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), InlinedBranchProfile.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.ParseDoubleNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.ParseDoubleNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedBranchProfile parse0_errorProfile_;
            private final InlinedBranchProfile parse1_errorProfile_;
            private final InlinedBranchProfile parse2_errorProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.ParseDoubleNode.class));
                this.state_0_ = target.getState(0, 15);
                this.parse0_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(12, 1)));
                this.parse1_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(13, 1)));
                this.parse2_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(14, 1)));
            }

            @Override
            double execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) throws TruffleString.NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x111) != 0) {
                    TruffleString.CompactionLevel compaction__;
                    if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2), this.parse0_errorProfile_);
                    }
                    if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2), this.parse1_errorProfile_);
                    }
                    if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2), this.parse2_errorProfile_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private double executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) throws TruffleString.NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.CompactionLevel compaction__ = null;
                boolean Parse0_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    Parse0_duplicateFound_ = true;
                }
                if (!Parse0_duplicateFound_ && (state_0 & 1) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringInternalNodesFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    Parse0_duplicateFound_ = true;
                }
                if (Parse0_duplicateFound_) {
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2), this.parse0_errorProfile_);
                }
                compaction__ = null;
                boolean Parse1_duplicateFound_ = false;
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    Parse1_duplicateFound_ = true;
                }
                if (!Parse1_duplicateFound_ && (state_0 & 0x10) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringInternalNodesFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    Parse1_duplicateFound_ = true;
                }
                if (Parse1_duplicateFound_) {
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2), this.parse1_errorProfile_);
                }
                compaction__ = null;
                boolean Parse2_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    Parse2_duplicateFound_ = true;
                }
                if (!Parse2_duplicateFound_ && (state_0 & 0x100) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringInternalNodesFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    Parse2_duplicateFound_ = true;
                }
                if (Parse2_duplicateFound_) {
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ParseDoubleNode.doParse(arg0Value, arg1Value, arg2Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2), this.parse2_errorProfile_);
                }
                throw ParseDoubleNodeGen.newUnsupportedSpecializationException3(this, arg0Value, arg1Value, arg2Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.ParseLongNode.class)
    static final class ParseLongNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        ParseLongNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException6LLLILI(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        @NeverDefault
        public static TStringInternalNodes.ParseLongNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.ParseLongNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=17, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.ParseLongNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.ParseLongNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value) throws TruffleString.NumberFormatException {
                if (TStringGuards.is7Bit(arg3Value)) {
                    return TStringInternalNodes.ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), InlinedBranchProfile.getUncached());
                }
                if (TStringGuards.is7Bit(arg3Value)) {
                    return TStringInternalNodes.ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), InlinedBranchProfile.getUncached());
                }
                if (TStringGuards.is7Bit(arg3Value)) {
                    return TStringInternalNodes.ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), InlinedBranchProfile.getUncached());
                }
                if (!TStringGuards.is7Bit(arg3Value)) {
                    return TStringInternalNodes.ParseLongNode.parseLong(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                throw ParseLongNodeGen.newUnsupportedSpecializationException6LLLILI(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.ParseLongNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.ParseLongNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final InlinedBranchProfile do7Bit0_errorProfile_;
            private final InlinedBranchProfile do7Bit1_errorProfile_;
            private final InlinedBranchProfile do7Bit2_errorProfile_;
            private final TruffleStringIterator.InternalNextNode parseLong_nextNode_;
            private final InlinedBranchProfile parseLong_errorProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.ParseLongNode.class));
                this.state_0_ = target.getState(0, 17);
                this.state_1_ = target.getState(1, 21);
                this.do7Bit0_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(13, 1)));
                this.do7Bit1_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(14, 1)));
                this.do7Bit2_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(15, 1)));
                this.parseLong_nextNode_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_1_.subUpdater(0, 21)));
                this.parseLong_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(16, 1)));
            }

            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value) throws TruffleString.NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x1111) != 0) {
                    TruffleString.CompactionLevel compaction__;
                    if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2), this.do7Bit0_errorProfile_);
                    }
                    if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2), this.do7Bit1_errorProfile_);
                    }
                    if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2), this.do7Bit2_errorProfile_);
                    }
                    if ((state_0 & 0x1000) != 0 && !TStringGuards.is7Bit(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_1_, this.state_0_));
                        return TStringInternalNodes.ParseLongNode.parseLong(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.parseLong_nextNode_, this.parseLong_errorProfile_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private long executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value) throws TruffleString.NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.CompactionLevel compaction__ = null;
                boolean Do7Bit0_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    Do7Bit0_duplicateFound_ = true;
                }
                if (!Do7Bit0_duplicateFound_ && TStringGuards.is7Bit(arg3Value) && (state_0 & 1) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringInternalNodesFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    Do7Bit0_duplicateFound_ = true;
                }
                if (Do7Bit0_duplicateFound_) {
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2), this.do7Bit0_errorProfile_);
                }
                compaction__ = null;
                boolean Do7Bit1_duplicateFound_ = false;
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    Do7Bit1_duplicateFound_ = true;
                }
                if (!Do7Bit1_duplicateFound_ && TStringGuards.is7Bit(arg3Value) && (state_0 & 0x10) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringInternalNodesFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    Do7Bit1_duplicateFound_ = true;
                }
                if (Do7Bit1_duplicateFound_) {
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2), this.do7Bit1_errorProfile_);
                }
                compaction__ = null;
                boolean Do7Bit2_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    Do7Bit2_duplicateFound_ = true;
                }
                if (!Do7Bit2_duplicateFound_ && TStringGuards.is7Bit(arg3Value) && (state_0 & 0x100) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringInternalNodesFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    Do7Bit2_duplicateFound_ = true;
                }
                if (Do7Bit2_duplicateFound_) {
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ParseLongNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2), this.do7Bit2_errorProfile_);
                }
                if (!TStringGuards.is7Bit(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x1000);
                    assert (InlineSupport.validate(arg0Value, this.state_1_, this.state_0_));
                    return TStringInternalNodes.ParseLongNode.parseLong(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.parseLong_nextNode_, this.parseLong_errorProfile_);
                }
                throw ParseLongNodeGen.newUnsupportedSpecializationException6LLLILI(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.ParseIntNode.class)
    static final class ParseIntNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        ParseIntNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException6LLLILI(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
        }

        @NeverDefault
        public static TStringInternalNodes.ParseIntNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.ParseIntNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=17, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.ParseIntNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.ParseIntNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value) throws TruffleString.NumberFormatException {
                if (TStringGuards.is7Bit(arg3Value)) {
                    return TStringInternalNodes.ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), InlinedBranchProfile.getUncached());
                }
                if (TStringGuards.is7Bit(arg3Value)) {
                    return TStringInternalNodes.ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), InlinedBranchProfile.getUncached());
                }
                if (TStringGuards.is7Bit(arg3Value)) {
                    return TStringInternalNodes.ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), InlinedBranchProfile.getUncached());
                }
                if (!TStringGuards.is7Bit(arg3Value)) {
                    return TStringInternalNodes.ParseIntNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), InlinedBranchProfile.getUncached());
                }
                throw ParseIntNodeGen.newUnsupportedSpecializationException6LLLILI(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.ParseIntNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.ParseIntNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final InlinedBranchProfile do7Bit0_errorProfile_;
            private final InlinedBranchProfile do7Bit1_errorProfile_;
            private final InlinedBranchProfile do7Bit2_errorProfile_;
            private final TruffleStringIterator.InternalNextNode generic_nextNode_;
            private final InlinedBranchProfile generic_errorProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.ParseIntNode.class));
                this.state_0_ = target.getState(0, 17);
                this.state_1_ = target.getState(1, 21);
                this.do7Bit0_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(13, 1)));
                this.do7Bit1_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(14, 1)));
                this.do7Bit2_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(15, 1)));
                this.generic_nextNode_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_1_.subUpdater(0, 21)));
                this.generic_errorProfile_ = InlinedBranchProfile.inline(InlineSupport.InlineTarget.create(InlinedBranchProfile.class, this.state_0_.subUpdater(16, 1)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value) throws TruffleString.NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x1111) != 0) {
                    TruffleString.CompactionLevel compaction__;
                    if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2), this.do7Bit0_errorProfile_);
                    }
                    if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2), this.do7Bit1_errorProfile_);
                    }
                    if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2), this.do7Bit2_errorProfile_);
                    }
                    if ((state_0 & 0x1000) != 0 && !TStringGuards.is7Bit(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_1_, this.state_0_));
                        return TStringInternalNodes.ParseIntNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.generic_nextNode_, this.generic_errorProfile_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value) throws TruffleString.NumberFormatException {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.CompactionLevel compaction__ = null;
                boolean Do7Bit0_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    Do7Bit0_duplicateFound_ = true;
                }
                if (!Do7Bit0_duplicateFound_ && TStringGuards.is7Bit(arg3Value) && (state_0 & 1) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringInternalNodesFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    Do7Bit0_duplicateFound_ = true;
                }
                if (Do7Bit0_duplicateFound_) {
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2), this.do7Bit0_errorProfile_);
                }
                compaction__ = null;
                boolean Do7Bit1_duplicateFound_ = false;
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    Do7Bit1_duplicateFound_ = true;
                }
                if (!Do7Bit1_duplicateFound_ && TStringGuards.is7Bit(arg3Value) && (state_0 & 0x10) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringInternalNodesFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    Do7Bit1_duplicateFound_ = true;
                }
                if (Do7Bit1_duplicateFound_) {
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2), this.do7Bit1_errorProfile_);
                }
                compaction__ = null;
                boolean Do7Bit2_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && TStringGuards.is7Bit(arg3Value) && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    Do7Bit2_duplicateFound_ = true;
                }
                if (!Do7Bit2_duplicateFound_ && TStringGuards.is7Bit(arg3Value) && (state_0 & 0x100) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringInternalNodesFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    Do7Bit2_duplicateFound_ = true;
                }
                if (Do7Bit2_duplicateFound_) {
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ParseIntNode.do7Bit(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringInternalNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2), this.do7Bit2_errorProfile_);
                }
                if (!TStringGuards.is7Bit(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x1000);
                    assert (InlineSupport.validate(arg0Value, this.state_1_, this.state_0_));
                    return TStringInternalNodes.ParseIntNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.generic_nextNode_, this.generic_errorProfile_);
                }
                throw ParseIntNodeGen.newUnsupportedSpecializationException6LLLILI(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.CalcStringAttributesInnerNode.class)
    static final class CalcStringAttributesInnerNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        CalcStringAttributesInnerNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException9LLLIIILII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, Object arg6Value, int arg7Value, int arg8Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
        }

        @NeverDefault
        public static TStringInternalNodes.CalcStringAttributesInnerNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.CalcStringAttributesInnerNode inline(@InlineSupport.RequiredField(bits=13, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.CalcStringAttributesInnerNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.CalcStringAttributesInnerNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, TruffleString.Encoding arg6Value, int arg7Value, int arg8Value) {
                if ((TStringGuards.is8Bit(arg8Value) || TStringGuards.isAsciiBytesOrLatin1(arg6Value)) && arg5Value == 0) {
                    return this.doLatin1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (TStringGuards.isUpTo16Bit(arg8Value) && arg5Value == 1) {
                    return this.doBMP(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (TStringGuards.isUTF8(arg6Value) && !TStringGuards.isFixedWidth(arg8Value)) {
                    return TStringInternalNodes.CalcStringAttributesInnerNode.doUTF8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF16(arg6Value) && TStringGuards.isValid(arg8Value)) {
                    return this.doUTF16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (TStringGuards.isUTF16(arg6Value) && TStringGuards.isBroken(arg8Value)) {
                    return this.doUTF16Unknown(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (arg5Value == 2) {
                    return this.doUTF32(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg6Value)) {
                    return TStringInternalNodes.CalcStringAttributesInnerNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                throw CalcStringAttributesInnerNodeGen.newUnsupportedSpecializationException9LLLIIILII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Object)arg6Value, arg7Value, arg8Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.CalcStringAttributesInnerNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.CalcStringAttributesInnerNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile uTF8_brokenProfile_;
            private final InlinedConditionProfile generic_validCharacterProfile_;
            private final InlinedConditionProfile generic_fixedWidthProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.CalcStringAttributesInnerNode.class));
                this.state_0_ = target.getState(0, 13);
                this.uTF8_brokenProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(7, 2)));
                this.generic_validCharacterProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(9, 2)));
                this.generic_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(11, 2)));
            }

            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, TruffleString.Encoding arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x7F) != 0) {
                    if ((state_0 & 1) != 0 && (TStringGuards.is8Bit(arg8Value) || TStringGuards.isAsciiBytesOrLatin1(arg6Value)) && arg5Value == 0) {
                        return this.doLatin1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUpTo16Bit(arg8Value) && arg5Value == 1) {
                        return this.doBMP(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF8(arg6Value) && !TStringGuards.isFixedWidth(arg8Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.CalcStringAttributesInnerNode.doUTF8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.uTF8_brokenProfile_);
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isUTF16(arg6Value) && TStringGuards.isValid(arg8Value)) {
                        return this.doUTF16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isUTF16(arg6Value) && TStringGuards.isBroken(arg8Value)) {
                        return this.doUTF16Unknown(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                    }
                    if ((state_0 & 0x20) != 0 && arg5Value == 2) {
                        return this.doUTF32(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                    }
                    if ((state_0 & 0x40) != 0 && TStringGuards.isUnsupportedEncoding(arg6Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                        return TStringInternalNodes.CalcStringAttributesInnerNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.generic_validCharacterProfile_, this.generic_fixedWidthProfile_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private long executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, TruffleString.Encoding arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((TStringGuards.is8Bit(arg8Value) || TStringGuards.isAsciiBytesOrLatin1(arg6Value)) && arg5Value == 0) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.doLatin1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (TStringGuards.isUpTo16Bit(arg8Value) && arg5Value == 1) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.doBMP(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (TStringGuards.isUTF8(arg6Value) && !TStringGuards.isFixedWidth(arg8Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.CalcStringAttributesInnerNode.doUTF8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.uTF8_brokenProfile_);
                }
                if (TStringGuards.isUTF16(arg6Value) && TStringGuards.isValid(arg8Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    return this.doUTF16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (TStringGuards.isUTF16(arg6Value) && TStringGuards.isBroken(arg8Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return this.doUTF16Unknown(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (arg5Value == 2) {
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    return this.doUTF32(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x40);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                    return TStringInternalNodes.CalcStringAttributesInnerNode.doGeneric(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.generic_validCharacterProfile_, this.generic_fixedWidthProfile_);
                }
                throw CalcStringAttributesInnerNodeGen.newUnsupportedSpecializationException9LLLIIILII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Object)arg6Value, arg7Value, arg8Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.CalcStringAttributesNode.class)
    static final class CalcStringAttributesNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        CalcStringAttributesNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException9LLLIIILII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, Object arg6Value, int arg7Value, int arg8Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
        }

        @NeverDefault
        public static TStringInternalNodes.CalcStringAttributesNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.CalcStringAttributesNode inline(@InlineSupport.RequiredField(bits=16, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.CalcStringAttributesNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.CalcStringAttributesNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, TruffleString.Encoding arg6Value, int arg7Value, int arg8Value) {
                if (arg4Value == 0) {
                    return this.empty(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (TStringGuards.is7Bit(arg8Value) && arg4Value > 0) {
                    return this.ascii(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (!TStringGuards.is7Bit(arg8Value) && arg4Value > 0) {
                    return TStringInternalNodes.CalcStringAttributesNode.notAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, CalcStringAttributesInnerNodeGen.getUncached());
                }
                throw CalcStringAttributesNodeGen.newUnsupportedSpecializationException9LLLIIILII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Object)arg6Value, arg7Value, arg8Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.CalcStringAttributesNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.CalcStringAttributesNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final TStringInternalNodes.CalcStringAttributesInnerNode notAscii_calcNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.CalcStringAttributesNode.class));
                this.state_0_ = target.getState(0, 16);
                this.notAscii_calcNode_ = CalcStringAttributesInnerNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.CalcStringAttributesInnerNode.class, this.state_0_.subUpdater(3, 13)));
            }

            @Override
            long execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, TruffleString.Encoding arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && arg4Value == 0) {
                        return this.empty(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.is7Bit(arg8Value) && arg4Value > 0) {
                        return this.ascii(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                    }
                    if ((state_0 & 4) != 0 && !TStringGuards.is7Bit(arg8Value) && arg4Value > 0) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.CalcStringAttributesNode.notAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.notAscii_calcNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
            }

            private long executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value, TruffleString.Encoding arg6Value, int arg7Value, int arg8Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (arg4Value == 0) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.empty(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (TStringGuards.is7Bit(arg8Value) && arg4Value > 0) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.ascii(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value);
                }
                if (!TStringGuards.is7Bit(arg8Value) && arg4Value > 0) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.CalcStringAttributesNode.notAscii(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, this.notAscii_calcNode_);
                }
                throw CalcStringAttributesNodeGen.newUnsupportedSpecializationException9LLLIIILII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Object)arg6Value, arg7Value, arg8Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.StrideFromCodeRangeNode.class)
    static final class StrideFromCodeRangeNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        StrideFromCodeRangeNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException3LIL(Node thisNode_, Object arg0Value, int arg1Value, Object arg2Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value);
        }

        @NeverDefault
        public static TStringInternalNodes.StrideFromCodeRangeNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.StrideFromCodeRangeNode inline(@InlineSupport.RequiredField(bits=3, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.StrideFromCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.StrideFromCodeRangeNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, int arg1Value, TruffleString.Encoding arg2Value) {
                if (TStringGuards.isUTF16(arg2Value)) {
                    return this.doUTF16(arg1Value, arg2Value);
                }
                if (TStringGuards.isUTF32(arg2Value)) {
                    return this.doUTF32(arg1Value, arg2Value);
                }
                if (!TStringGuards.isUTF16(arg2Value) && !TStringGuards.isUTF32(arg2Value)) {
                    return this.doOther(arg1Value, arg2Value);
                }
                throw StrideFromCodeRangeNodeGen.newUnsupportedSpecializationException3LIL(this, arg0Value, arg1Value, (Object)arg2Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.StrideFromCodeRangeNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.StrideFromCodeRangeNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.StrideFromCodeRangeNode.class));
                this.state_0_ = target.getState(0, 3);
            }

            @Override
            int execute(Node arg0Value, int arg1Value, TruffleString.Encoding arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isUTF16(arg2Value)) {
                        return this.doUTF16(arg1Value, arg2Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF32(arg2Value)) {
                        return this.doUTF32(arg1Value, arg2Value);
                    }
                    if ((state_0 & 4) != 0 && !TStringGuards.isUTF16(arg2Value) && !TStringGuards.isUTF32(arg2Value)) {
                        return this.doOther(arg1Value, arg2Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private int executeAndSpecialize(Node arg0Value, int arg1Value, TruffleString.Encoding arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isUTF16(arg2Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.doUTF16(arg1Value, arg2Value);
                }
                if (TStringGuards.isUTF32(arg2Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.doUTF32(arg1Value, arg2Value);
                }
                if (!TStringGuards.isUTF16(arg2Value) && !TStringGuards.isUTF32(arg2Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return this.doOther(arg1Value, arg2Value);
                }
                throw StrideFromCodeRangeNodeGen.newUnsupportedSpecializationException3LIL(this, arg0Value, arg1Value, (Object)arg2Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.LastIndexOfStringRawNode.class)
    static final class LastIndexOfStringRawNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        LastIndexOfStringRawNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException11LLLILLIIILL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Object arg9Value, Object arg10Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
        }

        @NeverDefault
        public static TStringInternalNodes.LastIndexOfStringRawNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.LastIndexOfStringRawNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=24, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.LastIndexOfStringRawNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.LastIndexOfStringRawNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, TruffleString.Encoding arg10Value) {
                if (TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.LastIndexOfStringRawNode.lios8SameEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, TStringOpsNodesFactory.RawLastIndexOfStringNodeGen.getUncached());
                }
                if (TStringGuards.isUnsupportedEncoding(arg10Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.LastIndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), TruffleStringIteratorFactory.InternalPreviousNodeGen.getUncached(), TruffleStringIteratorFactory.InternalPreviousNodeGen.getUncached());
                }
                throw LastIndexOfStringRawNodeGen.newUnsupportedSpecializationException11LLLILLIIILL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (Object)arg10Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.LastIndexOfStringRawNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.LastIndexOfStringRawNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final InlineSupport.StateField state_2_;
            private final InlineSupport.ReferenceField<Node> lios8SameEncoding_indexOfStringNode__field1_;
            private final TStringOpsNodes.RawLastIndexOfStringNode lios8SameEncoding_indexOfStringNode_;
            private final TruffleStringIterator.InternalNextNode unsupported_nextNodeA_;
            private final TruffleStringIterator.InternalPreviousNode unsupported_prevNodeA_;
            private final TruffleStringIterator.InternalPreviousNode unsupported_prevNodeB_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.LastIndexOfStringRawNode.class));
                this.state_0_ = target.getState(0, 24);
                this.state_1_ = target.getState(1, 21);
                this.state_2_ = target.getState(2, 21);
                this.lios8SameEncoding_indexOfStringNode__field1_ = target.getReference(3, Node.class);
                this.lios8SameEncoding_indexOfStringNode_ = TStringOpsNodesFactory.RawLastIndexOfStringNodeGen.inline(InlineSupport.InlineTarget.create(TStringOpsNodes.RawLastIndexOfStringNode.class, this.state_0_.subUpdater(2, 1), this.lios8SameEncoding_indexOfStringNode__field1_));
                this.unsupported_nextNodeA_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_0_.subUpdater(3, 21)));
                this.unsupported_prevNodeA_ = TruffleStringIteratorFactory.InternalPreviousNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalPreviousNode.class, this.state_1_.subUpdater(0, 21)));
                this.unsupported_prevNodeB_ = TruffleStringIteratorFactory.InternalPreviousNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalPreviousNode.class, this.state_2_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, TruffleString.Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && (TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value))) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.lios8SameEncoding_indexOfStringNode__field1_));
                        return TStringInternalNodes.LastIndexOfStringRawNode.lios8SameEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.lios8SameEncoding_indexOfStringNode_);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUnsupportedEncoding(arg10Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_2_));
                        return TStringInternalNodes.LastIndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.unsupported_nextNodeA_, this.unsupported_prevNodeA_, this.unsupported_prevNodeB_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, TruffleString.Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.lios8SameEncoding_indexOfStringNode__field1_));
                    return TStringInternalNodes.LastIndexOfStringRawNode.lios8SameEncoding(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.lios8SameEncoding_indexOfStringNode_);
                }
                if (TStringGuards.isUnsupportedEncoding(arg10Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_2_));
                    return TStringInternalNodes.LastIndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.unsupported_nextNodeA_, this.unsupported_prevNodeA_, this.unsupported_prevNodeB_);
                }
                throw LastIndexOfStringRawNodeGen.newUnsupportedSpecializationException11LLLILLIIILL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (Object)arg10Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.LastIndexOfStringNode.class)
    static final class LastIndexOfStringNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        LastIndexOfStringNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException10LLLILLIIIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Object arg9Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
        }

        @NeverDefault
        public static TStringInternalNodes.LastIndexOfStringNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.LastIndexOfStringNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=24, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.LastIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.LastIndexOfStringNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, TruffleString.Encoding arg9Value) {
                if (TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                    return TStringInternalNodes.LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, TStringOpsNodesFactory.RawLastIndexOfStringNodeGen.getUncached());
                }
                if (!TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                    return TStringInternalNodes.LastIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), TruffleStringIteratorFactory.InternalPreviousNodeGen.getUncached(), TruffleStringIteratorFactory.InternalPreviousNodeGen.getUncached());
                }
                throw LastIndexOfStringNodeGen.newUnsupportedSpecializationException10LLLILLIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (Object)arg9Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.LastIndexOfStringNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.LastIndexOfStringNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final InlineSupport.StateField state_2_;
            private final InlineSupport.ReferenceField<Node> direct_indexOfStringNode__field1_;
            private final TStringOpsNodes.RawLastIndexOfStringNode direct_indexOfStringNode_;
            private final TruffleStringIterator.InternalNextNode decode_nextNodeA_;
            private final TruffleStringIterator.InternalPreviousNode decode_prevNodeA_;
            private final TruffleStringIterator.InternalPreviousNode decode_prevNodeB_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.LastIndexOfStringNode.class));
                this.state_0_ = target.getState(0, 24);
                this.state_1_ = target.getState(1, 21);
                this.state_2_ = target.getState(2, 21);
                this.direct_indexOfStringNode__field1_ = target.getReference(3, Node.class);
                this.direct_indexOfStringNode_ = TStringOpsNodesFactory.RawLastIndexOfStringNodeGen.inline(InlineSupport.InlineTarget.create(TStringOpsNodes.RawLastIndexOfStringNode.class, this.state_0_.subUpdater(2, 1), this.direct_indexOfStringNode__field1_));
                this.decode_nextNodeA_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_0_.subUpdater(3, 21)));
                this.decode_prevNodeA_ = TruffleStringIteratorFactory.InternalPreviousNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalPreviousNode.class, this.state_1_.subUpdater(0, 21)));
                this.decode_prevNodeB_ = TruffleStringIteratorFactory.InternalPreviousNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalPreviousNode.class, this.state_2_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, TruffleString.Encoding arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_));
                        return TStringInternalNodes.LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.direct_indexOfStringNode_);
                    }
                    if ((state_0 & 2) != 0 && !TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_2_));
                        return TStringInternalNodes.LastIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.decode_nextNodeA_, this.decode_prevNodeA_, this.decode_prevNodeB_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, TruffleString.Encoding arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_));
                    return TStringInternalNodes.LastIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.direct_indexOfStringNode_);
                }
                if (!TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_2_));
                    return TStringInternalNodes.LastIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.decode_nextNodeA_, this.decode_prevNodeA_, this.decode_prevNodeB_);
                }
                throw LastIndexOfStringNodeGen.newUnsupportedSpecializationException10LLLILLIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (Object)arg9Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.IndexOfStringRawNode.class)
    static final class IndexOfStringRawNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        IndexOfStringRawNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException11LLLILLIIILL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Object arg9Value, Object arg10Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
        }

        @NeverDefault
        public static TStringInternalNodes.IndexOfStringRawNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.IndexOfStringRawNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=24, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.IndexOfStringRawNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.IndexOfStringRawNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, TruffleString.Encoding arg10Value) {
                if (TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, TStringOpsNodesFactory.RawIndexOfStringNodeGen.getUncached());
                }
                if (TStringGuards.isUnsupportedEncoding(arg10Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.IndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), TruffleStringIteratorFactory.InternalNextNodeGen.getUncached());
                }
                throw IndexOfStringRawNodeGen.newUnsupportedSpecializationException11LLLILLIIILL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (Object)arg10Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.IndexOfStringRawNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.IndexOfStringRawNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final InlineSupport.ReferenceField<Node> supported_indexOfStringNode__field1_;
            private final TStringOpsNodes.RawIndexOfStringNode supported_indexOfStringNode_;
            private final TruffleStringIterator.InternalNextNode unsupported_nextNodeA_;
            private final TruffleStringIterator.InternalNextNode unsupported_nextNodeB_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.IndexOfStringRawNode.class));
                this.state_0_ = target.getState(0, 24);
                this.state_1_ = target.getState(1, 21);
                this.supported_indexOfStringNode__field1_ = target.getReference(2, Node.class);
                this.supported_indexOfStringNode_ = TStringOpsNodesFactory.RawIndexOfStringNodeGen.inline(InlineSupport.InlineTarget.create(TStringOpsNodes.RawIndexOfStringNode.class, this.state_0_.subUpdater(2, 1), this.supported_indexOfStringNode__field1_));
                this.unsupported_nextNodeA_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_0_.subUpdater(3, 21)));
                this.unsupported_nextNodeB_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, TruffleString.Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && (TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value))) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.supported_indexOfStringNode__field1_));
                        return TStringInternalNodes.IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.supported_indexOfStringNode_);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUnsupportedEncoding(arg10Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_));
                        return TStringInternalNodes.IndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.unsupported_nextNodeA_, this.unsupported_nextNodeB_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, byte[] arg9Value, TruffleString.Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isSupportedEncoding(arg10Value) || TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.supported_indexOfStringNode__field1_));
                    return TStringInternalNodes.IndexOfStringRawNode.supported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.supported_indexOfStringNode_);
                }
                if (TStringGuards.isUnsupportedEncoding(arg10Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_));
                    return TStringInternalNodes.IndexOfStringRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.unsupported_nextNodeA_, this.unsupported_nextNodeB_);
                }
                throw IndexOfStringRawNodeGen.newUnsupportedSpecializationException11LLLILLIIILL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (Object)arg10Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.InternalIndexOfStringNode.class)
    static final class InternalIndexOfStringNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        InternalIndexOfStringNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException10LLLILLIIIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, Object arg9Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
        }

        @NeverDefault
        public static TStringInternalNodes.InternalIndexOfStringNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.InternalIndexOfStringNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=24, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.InternalIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.InternalIndexOfStringNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, TruffleString.Encoding arg9Value) {
                if (TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                    return TStringInternalNodes.InternalIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, TStringOpsNodesFactory.RawIndexOfStringNodeGen.getUncached());
                }
                if (!TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                    return TStringInternalNodes.InternalIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), TruffleStringIteratorFactory.InternalNextNodeGen.getUncached());
                }
                throw InternalIndexOfStringNodeGen.newUnsupportedSpecializationException10LLLILLIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (Object)arg9Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.InternalIndexOfStringNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.InternalIndexOfStringNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final InlineSupport.ReferenceField<Node> direct_indexOfStringNode__field1_;
            private final TStringOpsNodes.RawIndexOfStringNode direct_indexOfStringNode_;
            private final TruffleStringIterator.InternalNextNode decode_nextNodeA_;
            private final TruffleStringIterator.InternalNextNode decode_nextNodeB_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.InternalIndexOfStringNode.class));
                this.state_0_ = target.getState(0, 24);
                this.state_1_ = target.getState(1, 21);
                this.direct_indexOfStringNode__field1_ = target.getReference(2, Node.class);
                this.direct_indexOfStringNode_ = TStringOpsNodesFactory.RawIndexOfStringNodeGen.inline(InlineSupport.InlineTarget.create(TStringOpsNodes.RawIndexOfStringNode.class, this.state_0_.subUpdater(2, 1), this.direct_indexOfStringNode__field1_));
                this.decode_nextNodeA_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_0_.subUpdater(3, 21)));
                this.decode_nextNodeB_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, TruffleString.Encoding arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_));
                        return TStringInternalNodes.InternalIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.direct_indexOfStringNode_);
                    }
                    if ((state_0 & 2) != 0 && !TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_));
                        return TStringInternalNodes.InternalIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, AbstractTruffleString arg4Value, Object arg5Value, int arg6Value, int arg7Value, int arg8Value, TruffleString.Encoding arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.direct_indexOfStringNode__field1_));
                    return TStringInternalNodes.InternalIndexOfStringNode.direct(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.direct_indexOfStringNode_);
                }
                if (!TStringGuards.isFixedWidth(arg3Value, arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_));
                    return TStringInternalNodes.InternalIndexOfStringNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                }
                throw InternalIndexOfStringNodeGen.newUnsupportedSpecializationException10LLLILLIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, (Object)arg9Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.RegionEqualsNode.class)
    static final class RegionEqualsNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        RegionEqualsNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException11LLLIILLIIIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, int arg4Value, Object arg5Value, Object arg6Value, int arg7Value, int arg8Value, int arg9Value, Object arg10Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
        }

        @NeverDefault
        public static TStringInternalNodes.RegionEqualsNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.RegionEqualsNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=23, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.RegionEqualsNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.RegionEqualsNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            boolean execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, AbstractTruffleString arg5Value, Object arg6Value, int arg7Value, int arg8Value, int arg9Value, TruffleString.Encoding arg10Value) {
                if (TStringGuards.isFixedWidth(arg3Value, arg7Value)) {
                    return this.direct(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
                }
                if (!TStringGuards.isFixedWidth(arg3Value, arg7Value)) {
                    return TStringInternalNodes.RegionEqualsNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached(), TruffleStringIteratorFactory.InternalNextNodeGen.getUncached());
                }
                throw RegionEqualsNodeGen.newUnsupportedSpecializationException11LLLIILLIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (Object)arg10Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.RegionEqualsNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.RegionEqualsNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final TruffleStringIterator.InternalNextNode decode_nextNodeA_;
            private final TruffleStringIterator.InternalNextNode decode_nextNodeB_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.RegionEqualsNode.class));
                this.state_0_ = target.getState(0, 23);
                this.state_1_ = target.getState(1, 21);
                this.decode_nextNodeA_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_0_.subUpdater(2, 21)));
                this.decode_nextNodeB_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_1_.subUpdater(0, 21)));
            }

            @Override
            boolean execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, AbstractTruffleString arg5Value, Object arg6Value, int arg7Value, int arg8Value, int arg9Value, TruffleString.Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isFixedWidth(arg3Value, arg7Value)) {
                        return this.direct(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
                    }
                    if ((state_0 & 2) != 0 && !TStringGuards.isFixedWidth(arg3Value, arg7Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_));
                        return TStringInternalNodes.RegionEqualsNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
            }

            private boolean executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, AbstractTruffleString arg5Value, Object arg6Value, int arg7Value, int arg8Value, int arg9Value, TruffleString.Encoding arg10Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isFixedWidth(arg3Value, arg7Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.direct(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value);
                }
                if (!TStringGuards.isFixedWidth(arg3Value, arg7Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_));
                    return TStringInternalNodes.RegionEqualsNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, this.decode_nextNodeA_, this.decode_nextNodeB_);
                }
                throw RegionEqualsNodeGen.newUnsupportedSpecializationException11LLLIILLIIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, (Object)arg10Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.ConcatMaterializeBytesNode.class)
    static final class ConcatMaterializeBytesNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        ConcatMaterializeBytesNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException8LLLLLLII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, Object arg3Value, Object arg4Value, Object arg5Value, int arg6Value, int arg7Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
        }

        @NeverDefault
        public static TStringInternalNodes.ConcatMaterializeBytesNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.ConcatMaterializeBytesNode inline(@InlineSupport.RequiredField(bits=2, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.ConcatMaterializeBytesNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.ConcatMaterializeBytesNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            byte[] execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, TruffleString.Encoding arg5Value, int arg6Value, int arg7Value) {
                if (TStringGuards.isUTF16(arg5Value) || TStringGuards.isUTF32(arg5Value)) {
                    return this.doWithCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (!TStringGuards.isUTF16(arg5Value) && !TStringGuards.isUTF32(arg5Value)) {
                    return this.doNoCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                throw ConcatMaterializeBytesNodeGen.newUnsupportedSpecializationException8LLLLLLII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (Object)arg5Value, arg6Value, arg7Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.ConcatMaterializeBytesNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.ConcatMaterializeBytesNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.ConcatMaterializeBytesNode.class));
                this.state_0_ = target.getState(0, 2);
            }

            @Override
            byte[] execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, TruffleString.Encoding arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && (TStringGuards.isUTF16(arg5Value) || TStringGuards.isUTF32(arg5Value))) {
                        return this.doWithCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 2) != 0 && !TStringGuards.isUTF16(arg5Value) && !TStringGuards.isUTF32(arg5Value)) {
                        return this.doNoCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private byte[] executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, TruffleString.Encoding arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isUTF16(arg5Value) || TStringGuards.isUTF32(arg5Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.doWithCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (!TStringGuards.isUTF16(arg5Value) && !TStringGuards.isUTF32(arg5Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.doNoCompression(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                throw ConcatMaterializeBytesNodeGen.newUnsupportedSpecializationException8LLLLLLII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, (Object)arg5Value, arg6Value, arg7Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.ConcatEagerNode.class)
    static final class ConcatEagerNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        ConcatEagerNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.ConcatEagerNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.ConcatEagerNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=32, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=27, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.ConcatEagerNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.ConcatEagerNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, AbstractTruffleString arg2Value, TruffleString.Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                return TStringInternalNodes.ConcatEagerNode.concat(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, TruffleString.ToIndexableNode.getUncached(), TruffleString.ToIndexableNode.getUncached(), TStringInternalNodes.GetCodePointLengthNode.getUncached(), TStringInternalNodes.GetCodePointLengthNode.getUncached(), ConcatMaterializeBytesNodeGen.getUncached(), CalcStringAttributesNodeGen.getUncached(), InlinedConditionProfile.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.ConcatEagerNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.ConcatEagerNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final InlineSupport.StateField state_2_;
            private final TruffleString.ToIndexableNode toIndexableNodeA_;
            private final TruffleString.ToIndexableNode toIndexableNodeB_;
            private final TStringInternalNodes.GetCodePointLengthNode getCodePointLengthANode_;
            private final TStringInternalNodes.GetCodePointLengthNode getCodePointLengthBNode_;
            private final TStringInternalNodes.ConcatMaterializeBytesNode materializeBytesNode_;
            private final TStringInternalNodes.CalcStringAttributesNode calculateAttributesNode_;
            private final InlinedConditionProfile brokenProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.ConcatEagerNode.class));
                this.state_0_ = target.getState(0, 32);
                this.state_1_ = target.getState(1, 27);
                this.state_2_ = target.getState(2, 25);
                this.toIndexableNodeA_ = TruffleStringFactory.ToIndexableNodeGen.inline(InlineSupport.InlineTarget.create(TruffleString.ToIndexableNode.class, this.state_0_.subUpdater(0, 7)));
                this.toIndexableNodeB_ = TruffleStringFactory.ToIndexableNodeGen.inline(InlineSupport.InlineTarget.create(TruffleString.ToIndexableNode.class, this.state_0_.subUpdater(7, 7)));
                this.getCodePointLengthANode_ = GetCodePointLengthNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.GetCodePointLengthNode.class, this.state_1_.subUpdater(0, 25)));
                this.getCodePointLengthBNode_ = GetCodePointLengthNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.GetCodePointLengthNode.class, this.state_2_.subUpdater(0, 25)));
                this.materializeBytesNode_ = ConcatMaterializeBytesNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.ConcatMaterializeBytesNode.class, this.state_0_.subUpdater(30, 2)));
                this.calculateAttributesNode_ = CalcStringAttributesNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.CalcStringAttributesNode.class, this.state_0_.subUpdater(14, 16)));
                this.brokenProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_1_.subUpdater(25, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, AbstractTruffleString arg2Value, TruffleString.Encoding arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_1_, this.state_2_, this.state_0_, this.state_0_, this.state_1_));
                return TStringInternalNodes.ConcatEagerNode.concat(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.toIndexableNodeA_, this.toIndexableNodeB_, this.getCodePointLengthANode_, this.getCodePointLengthBNode_, this.materializeBytesNode_, this.calculateAttributesNode_, this.brokenProfile_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.SubstringNode.class)
    static final class SubstringNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        SubstringNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException8LLLILIIZ(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
        }

        @NeverDefault
        public static TStringInternalNodes.SubstringNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.SubstringNode inline(@InlineSupport.RequiredField(bits=28, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.SubstringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.SubstringNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                TruffleString arg1Value_;
                if (arg6Value == 0) {
                    return TStringInternalNodes.SubstringNode.lengthZero(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (arg1Value instanceof TruffleString) {
                    arg1Value_ = (TruffleString)arg1Value;
                    if (arg5Value == 0 && arg6Value == TStringGuards.length(arg1Value_)) {
                        return TStringInternalNodes.SubstringNode.sameStr(arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                }
                if (arg6Value > 0 && (arg6Value != TStringGuards.length(arg1Value) || arg1Value.isMutable()) && !arg7Value) {
                    return TStringInternalNodes.SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, CalcStringAttributesNodeGen.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (arg1Value instanceof TruffleString) {
                    arg1Value_ = (TruffleString)arg1Value;
                    if (arg6Value > 0 && arg6Value != TStringGuards.length(arg1Value_) && arg7Value) {
                        return TStringInternalNodes.SubstringNode.createLazySubstring(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, CalcStringAttributesNodeGen.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                    }
                }
                throw SubstringNodeGen.newUnsupportedSpecializationException8LLLILIIZ(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.SubstringNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.SubstringNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final TStringInternalNodes.CalcStringAttributesNode attributes;
            private final InlinedConditionProfile materializeSubstring_utf16Profile_;
            private final InlinedConditionProfile materializeSubstring_utf32Profile_;
            private final InlinedConditionProfile createLazySubstring_stride1MustMaterializeProfile_;
            private final InlinedConditionProfile createLazySubstring_stride2MustMaterializeProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.SubstringNode.class));
                this.state_0_ = target.getState(0, 28);
                this.attributes = CalcStringAttributesNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.CalcStringAttributesNode.class, this.state_0_.subUpdater(4, 16)));
                this.materializeSubstring_utf16Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(20, 2)));
                this.materializeSubstring_utf32Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(22, 2)));
                this.createLazySubstring_stride1MustMaterializeProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(24, 2)));
                this.createLazySubstring_stride2MustMaterializeProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(26, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0xF) != 0) {
                    TruffleString arg1Value_;
                    if ((state_0 & 1) != 0 && arg6Value == 0) {
                        return TStringInternalNodes.SubstringNode.lengthZero(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 2) != 0 && arg1Value instanceof TruffleString) {
                        arg1Value_ = (TruffleString)arg1Value;
                        if (arg5Value == 0 && arg6Value == TStringGuards.length(arg1Value_)) {
                            return TStringInternalNodes.SubstringNode.sameStr(arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                        }
                    }
                    if ((state_0 & 4) != 0 && arg6Value > 0 && (arg6Value != TStringGuards.length(arg1Value) || arg1Value.isMutable()) && !arg7Value) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                        return TStringInternalNodes.SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.attributes, this.materializeSubstring_utf16Profile_, this.materializeSubstring_utf32Profile_);
                    }
                    if ((state_0 & 8) != 0 && arg1Value instanceof TruffleString) {
                        arg1Value_ = (TruffleString)arg1Value;
                        if (arg6Value > 0 && arg6Value != TStringGuards.length(arg1Value_) && arg7Value) {
                            assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                            return TStringInternalNodes.SubstringNode.createLazySubstring(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.attributes, this.createLazySubstring_stride1MustMaterializeProfile_, this.createLazySubstring_stride2MustMaterializeProfile_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private TruffleString executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                TruffleString arg1Value_;
                int state_0 = this.state_0_.get(arg0Value);
                if (arg6Value == 0) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return TStringInternalNodes.SubstringNode.lengthZero(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (arg1Value instanceof TruffleString) {
                    arg1Value_ = (TruffleString)arg1Value;
                    if (arg5Value == 0 && arg6Value == TStringGuards.length(arg1Value_)) {
                        this.state_0_.set(arg0Value, state_0 |= 2);
                        return TStringInternalNodes.SubstringNode.sameStr(arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                }
                if (arg6Value > 0 && (arg6Value != TStringGuards.length(arg1Value) || arg1Value.isMutable()) && !arg7Value) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                    return TStringInternalNodes.SubstringNode.materializeSubstring(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.attributes, this.materializeSubstring_utf16Profile_, this.materializeSubstring_utf32Profile_);
                }
                if (arg1Value instanceof TruffleString) {
                    arg1Value_ = (TruffleString)arg1Value;
                    if (arg6Value > 0 && arg6Value != TStringGuards.length(arg1Value_) && arg7Value) {
                        this.state_0_.set(arg0Value, state_0 |= 8);
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                        return TStringInternalNodes.SubstringNode.createLazySubstring(arg0Value, arg1Value_, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.attributes, this.createLazySubstring_stride1MustMaterializeProfile_, this.createLazySubstring_stride2MustMaterializeProfile_);
                    }
                }
                throw SubstringNodeGen.newUnsupportedSpecializationException8LLLILIIZ(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.IndexOfCodePointSetNode.class)
    static final class IndexOfCodePointSetNodeGen
    extends TStringInternalNodes.IndexOfCodePointSetNode {
        static final InlineSupport.ReferenceField<DynamicStrideData> DYNAMIC_STRIDE_CACHE_UPDATER = InlineSupport.ReferenceField.create(MethodHandles.lookup(), "dynamicStride_cache", DynamicStrideData.class);
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private DynamicStrideData dynamicStride_cache;

        private IndexOfCodePointSetNodeGen(IndexOfCodePointSet.IndexOfNode[] indexOfNodes, TruffleString.Encoding encoding) {
            super(indexOfNodes, encoding);
        }

        @Override
        @ExplodeLoop
        int execute(Object arg0Value, int arg1Value, int arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    assert (DSLSupport.assertIdempotence(!this.isUTF16Or32));
                    return this.stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if ((state_0 & 2) != 0) {
                    assert (DSLSupport.assertIdempotence(this.isUTF16Or32));
                    DynamicStrideData s1_ = this.dynamicStride_cache;
                    while (s1_ != null) {
                        if (arg3Value == s1_.cachedStride_) {
                            return this.dynamicStride(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedStride_);
                        }
                        s1_ = s1_.next_;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        private int executeAndSpecialize(Object arg0Value, int arg1Value, int arg2Value, int arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            int state_0 = this.state_0_;
            if (!this.isUTF16Or32) {
                this.state_0_ = state_0 |= 1;
                return this.stride0(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
            if (this.isUTF16Or32) {
                DynamicStrideData s1_;
                block5: {
                    DynamicStrideData s1_original;
                    do {
                        int count1_ = 0;
                        s1_original = s1_ = DYNAMIC_STRIDE_CACHE_UPDATER.getVolatile(this);
                        while (s1_ != null && arg3Value != s1_.cachedStride_) {
                            ++count1_;
                            s1_ = s1_.next_;
                        }
                        if (s1_ != null || count1_ >= 3) break block5;
                        s1_ = new DynamicStrideData(s1_original);
                        s1_.cachedStride_ = arg3Value;
                    } while (!DYNAMIC_STRIDE_CACHE_UPDATER.compareAndSet(this, s1_original, s1_));
                    this.state_0_ = state_0 |= 2;
                }
                if (s1_ != null) {
                    return this.dynamicStride(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, s1_.cachedStride_);
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static TStringInternalNodes.IndexOfCodePointSetNode create(IndexOfCodePointSet.IndexOfNode[] indexOfNodes, TruffleString.Encoding encoding) {
            return new IndexOfCodePointSetNodeGen(indexOfNodes, encoding);
        }

        @GeneratedBy(value=TStringInternalNodes.IndexOfCodePointSetNode.class)
        @DenyReplace
        private static final class DynamicStrideData
        implements DSLSupport.SpecializationDataNode {
            @CompilerDirectives.CompilationFinal
            final DynamicStrideData next_;
            @CompilerDirectives.CompilationFinal
            int cachedStride_;

            DynamicStrideData(DynamicStrideData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.LastIndexOfCodePointRawNode.class)
    static final class LastIndexOfCodePointRawNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        LastIndexOfCodePointRawNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException8LLLILIII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
        }

        @NeverDefault
        public static TStringInternalNodes.LastIndexOfCodePointRawNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.LastIndexOfCodePointRawNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=16, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.LastIndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.LastIndexOfCodePointRawNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TStringOpsNodesFactory.RawLastIndexOfCodePointNodeGen.getUncached());
                }
                if (TStringGuards.isUTF8(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TStringOpsNodesFactory.RawLastIndexOfCodePointNodeGen.getUncached());
                }
                if (TStringGuards.isUTF16(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.LastIndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TStringOpsNodesFactory.RawLastIndexOfCodePointNodeGen.getUncached());
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.LastIndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalPreviousNodeGen.getUncached());
                }
                throw LastIndexOfCodePointRawNodeGen.newUnsupportedSpecializationException8LLLILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.LastIndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.LastIndexOfCodePointRawNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final TStringOpsNodes.RawLastIndexOfCodePointNode lastIndexOfNode;
            private final TruffleStringIterator.InternalPreviousNode unsupported_prevNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.LastIndexOfCodePointRawNode.class));
                this.state_0_ = target.getState(0, 16);
                this.state_1_ = target.getState(1, 21);
                this.lastIndexOfNode = TStringOpsNodesFactory.RawLastIndexOfCodePointNodeGen.inline(InlineSupport.InlineTarget.create(TStringOpsNodes.RawLastIndexOfCodePointNode.class, this.state_0_.subUpdater(4, 12)));
                this.unsupported_prevNode_ = TruffleStringIteratorFactory.InternalPreviousNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalPreviousNode.class, this.state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isFixedWidth(arg3Value)) {
                        return TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF8(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                        return TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF16(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                        return TStringInternalNodes.LastIndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_1_));
                        return TStringInternalNodes.LastIndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.unsupported_prevNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                }
                if (TStringGuards.isUTF8(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return TStringInternalNodes.LastIndexOfCodePointRawNode.utf8Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                }
                if (TStringGuards.isUTF16(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return TStringInternalNodes.LastIndexOfCodePointRawNode.utf16Variable(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.lastIndexOfNode);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    assert (InlineSupport.validate(arg0Value, this.state_1_));
                    return TStringInternalNodes.LastIndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.unsupported_prevNode_);
                }
                throw LastIndexOfCodePointRawNodeGen.newUnsupportedSpecializationException8LLLILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.LastIndexOfCodePointNode.class)
    static final class LastIndexOfCodePointNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        LastIndexOfCodePointNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException8LLLILIII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
        }

        @NeverDefault
        public static TStringInternalNodes.LastIndexOfCodePointNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.LastIndexOfCodePointNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=14, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.LastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.LastIndexOfCodePointNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TStringOpsNodesFactory.RawLastIndexOfCodePointNodeGen.getUncached());
                }
                if (!TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.LastIndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached());
                }
                throw LastIndexOfCodePointNodeGen.newUnsupportedSpecializationException8LLLILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.LastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.LastIndexOfCodePointNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final TStringOpsNodes.RawLastIndexOfCodePointNode fixedWidth_lastIndexOfNode_;
            private final TruffleStringIterator.InternalNextNode decode_nextNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.LastIndexOfCodePointNode.class));
                this.state_0_ = target.getState(0, 14);
                this.state_1_ = target.getState(1, 21);
                this.fixedWidth_lastIndexOfNode_ = TStringOpsNodesFactory.RawLastIndexOfCodePointNodeGen.inline(InlineSupport.InlineTarget.create(TStringOpsNodes.RawLastIndexOfCodePointNode.class, this.state_0_.subUpdater(2, 12)));
                this.decode_nextNode_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isFixedWidth(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fixedWidth_lastIndexOfNode_);
                    }
                    if ((state_0 & 2) != 0 && !TStringGuards.isFixedWidth(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_1_));
                        return TStringInternalNodes.LastIndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.decode_nextNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.LastIndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fixedWidth_lastIndexOfNode_);
                }
                if (!TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_1_));
                    return TStringInternalNodes.LastIndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.decode_nextNode_);
                }
                throw LastIndexOfCodePointNodeGen.newUnsupportedSpecializationException8LLLILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.IndexOfCodePointRawNode.class)
    static final class IndexOfCodePointRawNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        IndexOfCodePointRawNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException8LLLILIII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
        }

        @NeverDefault
        public static TStringInternalNodes.IndexOfCodePointRawNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.IndexOfCodePointRawNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=16, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.IndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.IndexOfCodePointRawNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.IndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TStringOpsNodesFactory.RawIndexOfCodePointNodeGen.getUncached());
                }
                if (TStringGuards.isUTF8(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    return this.utf8Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    return this.utf16Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.IndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached());
                }
                throw IndexOfCodePointRawNodeGen.newUnsupportedSpecializationException8LLLILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.IndexOfCodePointRawNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.IndexOfCodePointRawNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final TStringOpsNodes.RawIndexOfCodePointNode utf8Fixed_indexOfNode_;
            private final TruffleStringIterator.InternalNextNode unsupported_nextNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.IndexOfCodePointRawNode.class));
                this.state_0_ = target.getState(0, 16);
                this.state_1_ = target.getState(1, 21);
                this.utf8Fixed_indexOfNode_ = TStringOpsNodesFactory.RawIndexOfCodePointNodeGen.inline(InlineSupport.InlineTarget.create(TStringOpsNodes.RawIndexOfCodePointNode.class, this.state_0_.subUpdater(4, 12)));
                this.unsupported_nextNode_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isFixedWidth(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.IndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8Fixed_indexOfNode_);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF8(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                        return this.utf8Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF16(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                        return this.utf16Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_1_));
                        return TStringInternalNodes.IndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.unsupported_nextNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.IndexOfCodePointRawNode.utf8Fixed(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.utf8Fixed_indexOfNode_);
                }
                if (TStringGuards.isUTF8(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.utf8Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return this.utf16Variable(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    assert (InlineSupport.validate(arg0Value, this.state_1_));
                    return TStringInternalNodes.IndexOfCodePointRawNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.unsupported_nextNode_);
                }
                throw IndexOfCodePointRawNodeGen.newUnsupportedSpecializationException8LLLILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.IndexOfCodePointNode.class)
    static final class IndexOfCodePointNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        IndexOfCodePointNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException8LLLILIII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, int arg6Value, int arg7Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
        }

        @NeverDefault
        public static TStringInternalNodes.IndexOfCodePointNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.IndexOfCodePointNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=14, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=21, value=InlineSupport.StateField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.IndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.IndexOfCodePointNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TStringOpsNodesFactory.RawIndexOfCodePointNodeGen.getUncached());
                }
                if (!TStringGuards.isFixedWidth(arg3Value)) {
                    return TStringInternalNodes.IndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleStringIteratorFactory.InternalNextNodeGen.getUncached());
                }
                throw IndexOfCodePointNodeGen.newUnsupportedSpecializationException8LLLILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.IndexOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.IndexOfCodePointNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final TStringOpsNodes.RawIndexOfCodePointNode fixedWidth_indexOfNode_;
            private final TruffleStringIterator.InternalNextNode decode_nextNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.IndexOfCodePointNode.class));
                this.state_0_ = target.getState(0, 14);
                this.state_1_ = target.getState(1, 21);
                this.fixedWidth_indexOfNode_ = TStringOpsNodesFactory.RawIndexOfCodePointNodeGen.inline(InlineSupport.InlineTarget.create(TStringOpsNodes.RawIndexOfCodePointNode.class, this.state_0_.subUpdater(2, 12)));
                this.decode_nextNode_ = TruffleStringIteratorFactory.InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, this.state_1_.subUpdater(0, 21)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isFixedWidth(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fixedWidth_indexOfNode_);
                    }
                    if ((state_0 & 2) != 0 && !TStringGuards.isFixedWidth(arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_1_));
                        return TStringInternalNodes.IndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.decode_nextNode_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, int arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.IndexOfCodePointNode.doFixedWidth(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.fixedWidth_indexOfNode_);
                }
                if (!TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_1_));
                    return TStringInternalNodes.IndexOfCodePointNode.decode(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, this.decode_nextNode_);
                }
                throw IndexOfCodePointNodeGen.newUnsupportedSpecializationException8LLLILIII(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.CodePointAtRawNode.class)
    static final class CodePointAtRawNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        CodePointAtRawNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLILIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, Object arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static TStringInternalNodes.CodePointAtRawNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.CodePointAtRawNode inline(@InlineSupport.RequiredField(bits=18, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.CodePointAtRawNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.CodePointAtRawNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, TruffleString.ErrorHandling arg6Value) {
                if (TStringGuards.isUTF16(arg4Value)) {
                    return TStringInternalNodes.CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF32(arg4Value)) {
                    return TStringInternalNodes.CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF8(arg4Value)) {
                    return TStringInternalNodes.CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (!TStringGuards.isUTF16Or32(arg4Value) && !TStringGuards.isUTF8(arg4Value) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                    return TStringInternalNodes.CodePointAtRawNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isAscii(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                    return TStringInternalNodes.CodePointAtRawNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                    return TStringInternalNodes.CodePointAtRawNode.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw CodePointAtRawNodeGen.newUnsupportedSpecializationException7LLLILIL(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, (Object)arg6Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.CodePointAtRawNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.CodePointAtRawNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile stride0;
            private final InlinedConditionProfile utf16_fixedWidthProfile_;
            private final InlinedConditionProfile utf16_validProfile_;
            private final InlinedConditionProfile utf32_stride1Profile_;
            private final InlinedConditionProfile utf8_fixedWidthProfile_;
            private final InlinedConditionProfile utf8_validProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.CodePointAtRawNode.class));
                this.state_0_ = target.getState(0, 18);
                this.stride0 = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(10, 2)));
                this.utf16_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(6, 2)));
                this.utf16_validProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(8, 2)));
                this.utf32_stride1Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(12, 2)));
                this.utf8_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(14, 2)));
                this.utf8_validProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(16, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, TruffleString.ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x3F) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isUTF16(arg4Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                        return TStringInternalNodes.CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf16_fixedWidthProfile_, this.utf16_validProfile_, this.stride0);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF32(arg4Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.stride0, this.utf32_stride1Profile_);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF8(arg4Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                        return TStringInternalNodes.CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                    }
                    if ((state_0 & 8) != 0 && !TStringGuards.isUTF16Or32(arg4Value) && !TStringGuards.isUTF8(arg4Value) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                        return TStringInternalNodes.CodePointAtRawNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isAscii(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                        return TStringInternalNodes.CodePointAtRawNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x20) != 0 && TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                        return TStringInternalNodes.CodePointAtRawNode.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, TruffleString.ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isUTF16(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                    return TStringInternalNodes.CodePointAtRawNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf16_fixedWidthProfile_, this.utf16_validProfile_, this.stride0);
                }
                if (TStringGuards.isUTF32(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.CodePointAtRawNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.stride0, this.utf32_stride1Profile_);
                }
                if (TStringGuards.isUTF8(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                    return TStringInternalNodes.CodePointAtRawNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8_fixedWidthProfile_, this.utf8_validProfile_);
                }
                if (!TStringGuards.isUTF16Or32(arg4Value) && !TStringGuards.isUTF8(arg4Value) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    return TStringInternalNodes.CodePointAtRawNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isAscii(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return TStringInternalNodes.CodePointAtRawNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    return TStringInternalNodes.CodePointAtRawNode.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw CodePointAtRawNodeGen.newUnsupportedSpecializationException7LLLILIL(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, (Object)arg6Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.CodePointAtNode.class)
    static final class CodePointAtNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        CodePointAtNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLILIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, Object arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static TStringInternalNodes.CodePointAtNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.CodePointAtNode inline(@InlineSupport.RequiredField(bits=16, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.CodePointAtNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.CodePointAtNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, TruffleString.ErrorHandling arg6Value) {
                if (TStringGuards.isUTF16(arg4Value)) {
                    return TStringInternalNodes.CodePointAtNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF32(arg4Value)) {
                    return TStringInternalNodes.CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF8(arg4Value)) {
                    return TStringInternalNodes.CodePointAtNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (!TStringGuards.isUTF16Or32(arg4Value) && !TStringGuards.isUTF8(arg4Value) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                    return TStringInternalNodes.CodePointAtNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isAscii(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                    return TStringInternalNodes.CodePointAtNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                    return this.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw CodePointAtNodeGen.newUnsupportedSpecializationException7LLLILIL(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, (Object)arg6Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.CodePointAtNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.CodePointAtNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile stride0;
            private final InlinedConditionProfile valid;
            private final InlinedConditionProfile utf16_fixedWidthProfile_;
            private final InlinedConditionProfile utf32_stride1Profile_;
            private final InlinedConditionProfile utf8_fixedWidthProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.CodePointAtNode.class));
                this.state_0_ = target.getState(0, 16);
                this.stride0 = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(8, 2)));
                this.valid = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(10, 2)));
                this.utf16_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(6, 2)));
                this.utf32_stride1Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(12, 2)));
                this.utf8_fixedWidthProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(14, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, TruffleString.ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x3F) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isUTF16(arg4Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.CodePointAtNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf16_fixedWidthProfile_, this.stride0, this.valid);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF32(arg4Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.stride0, this.utf32_stride1Profile_);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF8(arg4Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.CodePointAtNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8_fixedWidthProfile_, this.valid);
                    }
                    if ((state_0 & 8) != 0 && !TStringGuards.isUTF16Or32(arg4Value) && !TStringGuards.isUTF8(arg4Value) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                        return TStringInternalNodes.CodePointAtNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isAscii(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                        return TStringInternalNodes.CodePointAtNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x20) != 0 && TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                        return this.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, TruffleString.ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isUTF16(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.CodePointAtNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf16_fixedWidthProfile_, this.stride0, this.valid);
                }
                if (TStringGuards.isUTF32(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.CodePointAtNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.stride0, this.utf32_stride1Profile_);
                }
                if (TStringGuards.isUTF8(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.CodePointAtNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.utf8_fixedWidthProfile_, this.valid);
                }
                if (!TStringGuards.isUTF16Or32(arg4Value) && !TStringGuards.isUTF8(arg4Value) && (TStringGuards.isBytes(arg4Value) || TStringGuards.is7Or8Bit(arg3Value))) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    return TStringInternalNodes.CodePointAtNode.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isAscii(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return TStringInternalNodes.CodePointAtNode.doAsciiBroken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value) && !TStringGuards.is7Or8Bit(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    return this.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw CodePointAtNodeGen.newUnsupportedSpecializationException7LLLILIL(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, (Object)arg6Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.ReadByteNode.class)
    static final class ReadByteNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        ReadByteNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException5LLLIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
        }

        @NeverDefault
        public static TStringInternalNodes.ReadByteNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.ReadByteNode inline(@InlineSupport.RequiredField(bits=7, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.ReadByteNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.ReadByteNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value) {
                if (TStringGuards.isUTF16(arg4Value)) {
                    return TStringInternalNodes.ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF32(arg4Value)) {
                    return TStringInternalNodes.ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (!TStringGuards.isUTF16Or32(arg4Value)) {
                    return TStringInternalNodes.ReadByteNode.doRest(arg1Value, arg2Value, arg3Value, arg4Value);
                }
                throw ReadByteNodeGen.newUnsupportedSpecializationException5LLLIL(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.ReadByteNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.ReadByteNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile stride0;
            private final InlinedConditionProfile uTF32_stride1Profile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.ReadByteNode.class));
                this.state_0_ = target.getState(0, 7);
                this.stride0 = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(3, 2)));
                this.uTF32_stride1Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(5, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 7) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isUTF16(arg4Value)) {
                        return TStringInternalNodes.ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.stride0);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF32(arg4Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.stride0, this.uTF32_stride1Profile_);
                    }
                    if ((state_0 & 4) != 0 && !TStringGuards.isUTF16Or32(arg4Value)) {
                        return TStringInternalNodes.ReadByteNode.doRest(arg1Value, arg2Value, arg3Value, arg4Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isUTF16(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return TStringInternalNodes.ReadByteNode.doUTF16(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.stride0);
                }
                if (TStringGuards.isUTF32(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ReadByteNode.doUTF32(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, this.stride0, this.uTF32_stride1Profile_);
                }
                if (!TStringGuards.isUTF16Or32(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return TStringInternalNodes.ReadByteNode.doRest(arg1Value, arg2Value, arg3Value, arg4Value);
                }
                throw ReadByteNodeGen.newUnsupportedSpecializationException5LLLIL(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.CodePointIndexToRawNode.class)
    static final class CodePointIndexToRawNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        CodePointIndexToRawNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException8LLLILIIZ(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
        }

        @NeverDefault
        public static TStringInternalNodes.CodePointIndexToRawNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.CodePointIndexToRawNode inline(@InlineSupport.RequiredField(bits=6, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.CodePointIndexToRawNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.CodePointIndexToRawNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    return this.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    return this.utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    return this.utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    return this.utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    return this.utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value)) {
                    return this.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                throw CodePointIndexToRawNodeGen.newUnsupportedSpecializationException8LLLILIIZ(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.CodePointIndexToRawNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.CodePointIndexToRawNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.CodePointIndexToRawNode.class));
                this.state_0_ = target.getState(0, 6);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isFixedWidth(arg3Value)) {
                        return this.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF8(arg4Value) && TStringGuards.isValid(arg3Value)) {
                        return this.utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF8(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                        return this.utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isUTF16(arg4Value) && TStringGuards.isValid(arg3Value)) {
                        return this.utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isUTF16(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                        return this.utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                    if ((state_0 & 0x20) != 0 && TStringGuards.isUnsupportedEncoding(arg4Value)) {
                        return this.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value, boolean arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return this.utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    return this.utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return this.utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    return this.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
                }
                throw CodePointIndexToRawNodeGen.newUnsupportedSpecializationException8LLLILIIZ(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value, arg7Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.RawIndexToCodePointIndexNode.class)
    static final class RawIndexToCodePointIndexNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        RawIndexToCodePointIndexNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLILII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, int arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static TStringInternalNodes.RawIndexToCodePointIndexNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.RawIndexToCodePointIndexNode inline(@InlineSupport.RequiredField(bits=10, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.RawIndexToCodePointIndexNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.RawIndexToCodePointIndexNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value) {
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    return this.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    return TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    return TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    return this.utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    return this.utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value)) {
                    return TStringInternalNodes.RawIndexToCodePointIndexNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                throw RawIndexToCodePointIndexNodeGen.newUnsupportedSpecializationException7LLLILII(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.RawIndexToCodePointIndexNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.RawIndexToCodePointIndexNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile broken;
            private final InlinedConditionProfile unsupported_validProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.RawIndexToCodePointIndexNode.class));
                this.state_0_ = target.getState(0, 10);
                this.broken = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(6, 2)));
                this.unsupported_validProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(8, 2)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x3F) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isFixedWidth(arg3Value)) {
                        return this.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF8(arg4Value) && TStringGuards.isValid(arg3Value)) {
                        return TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.broken);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF8(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                        return TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.broken);
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isUTF16(arg4Value) && TStringGuards.isValid(arg3Value)) {
                        return this.utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isUTF16(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                        return this.utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x20) != 0 && TStringGuards.isUnsupportedEncoding(arg4Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.RawIndexToCodePointIndexNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.unsupported_validProfile_, this.broken);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isFixedWidth(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Valid(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.broken);
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return TStringInternalNodes.RawIndexToCodePointIndexNode.utf8Broken(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.broken);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    return this.utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return this.utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.RawIndexToCodePointIndexNode.unsupported(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.unsupported_validProfile_, this.broken);
                }
                throw RawIndexToCodePointIndexNodeGen.newUnsupportedSpecializationException7LLLILII(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, arg6Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.ByteLengthOfCodePointNode.class)
    static final class ByteLengthOfCodePointNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        ByteLengthOfCodePointNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLILIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value, Object arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static TStringInternalNodes.ByteLengthOfCodePointNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.ByteLengthOfCodePointNode inline(@InlineSupport.RequiredField(bits=27, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.ByteLengthOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.ByteLengthOfCodePointNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, TruffleString.ErrorHandling arg6Value) {
                if (TStringGuards.isFixedWidth(arg3Value) && TStringGuards.isBestEffort(arg6Value)) {
                    return this.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUpToValidFixedWidth(arg3Value) && TStringGuards.isReturnNegative(arg6Value)) {
                    return this.doFixedValidReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isAscii(arg4Value) && TStringGuards.isBroken(arg3Value) && TStringGuards.isReturnNegative(arg6Value)) {
                    return this.doASCIIBrokenReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF32(arg4Value) && TStringGuards.isBroken(arg3Value) && TStringGuards.isReturnNegative(arg6Value)) {
                    return TStringInternalNodes.ByteLengthOfCodePointNode.doUTF32BrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, CodePointAtRawNodeGen.getUncached());
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    return this.utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    return this.utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    return this.utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    return this.utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value)) {
                    return this.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw ByteLengthOfCodePointNodeGen.newUnsupportedSpecializationException7LLLILIL(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, (Object)arg6Value);
            }
        }

        @GeneratedBy(value=TStringInternalNodes.ByteLengthOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.ByteLengthOfCodePointNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final TStringInternalNodes.CodePointAtRawNode uTF32BrokenReturnNegative_codePointAtRawNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.ByteLengthOfCodePointNode.class));
                this.state_0_ = target.getState(0, 27);
                this.uTF32BrokenReturnNegative_codePointAtRawNode_ = CodePointAtRawNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.CodePointAtRawNode.class, this.state_0_.subUpdater(9, 18)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, TruffleString.ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x1FF) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isFixedWidth(arg3Value) && TStringGuards.isBestEffort(arg6Value)) {
                        return this.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUpToValidFixedWidth(arg3Value) && TStringGuards.isReturnNegative(arg6Value)) {
                        return this.doFixedValidReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isAscii(arg4Value) && TStringGuards.isBroken(arg3Value) && TStringGuards.isReturnNegative(arg6Value)) {
                        return this.doASCIIBrokenReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isUTF32(arg4Value) && TStringGuards.isBroken(arg3Value) && TStringGuards.isReturnNegative(arg6Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_));
                        return TStringInternalNodes.ByteLengthOfCodePointNode.doUTF32BrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.uTF32BrokenReturnNegative_codePointAtRawNode_);
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isUTF8(arg4Value) && TStringGuards.isValid(arg3Value)) {
                        return this.utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x20) != 0 && TStringGuards.isUTF8(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                        return this.utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x40) != 0 && TStringGuards.isUTF16(arg4Value) && TStringGuards.isValid(arg3Value)) {
                        return this.utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x80) != 0 && TStringGuards.isUTF16(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                        return this.utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x100) != 0 && TStringGuards.isUnsupportedEncoding(arg4Value)) {
                        return this.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, TruffleString.Encoding arg4Value, int arg5Value, TruffleString.ErrorHandling arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isFixedWidth(arg3Value) && TStringGuards.isBestEffort(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.doFixed(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUpToValidFixedWidth(arg3Value) && TStringGuards.isReturnNegative(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.doFixedValidReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isAscii(arg4Value) && TStringGuards.isBroken(arg3Value) && TStringGuards.isReturnNegative(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return this.doASCIIBrokenReturnNegative(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF32(arg4Value) && TStringGuards.isBroken(arg3Value) && TStringGuards.isReturnNegative(arg6Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    assert (InlineSupport.validate(arg0Value, this.state_0_));
                    return TStringInternalNodes.ByteLengthOfCodePointNode.doUTF32BrokenReturnNegative(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.uTF32BrokenReturnNegative_codePointAtRawNode_);
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return this.utf8Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF8(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x20);
                    return this.utf8Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isValid(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x40);
                    return this.utf16Valid(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUTF16(arg4Value) && TStringGuards.isBroken(arg3Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x80);
                    return this.utf16Broken(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isUnsupportedEncoding(arg4Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    return this.unsupported(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw ByteLengthOfCodePointNodeGen.newUnsupportedSpecializationException7LLLILIL(this, arg0Value, arg1Value, arg2Value, arg3Value, (Object)arg4Value, arg5Value, (Object)arg6Value);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.FromNativePointerNode.class)
    static final class FromNativePointerNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        FromNativePointerNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.FromNativePointerNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.FromNativePointerNode inline(@InlineSupport.RequiredField(bits=14, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.FromNativePointerNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.FromNativePointerNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            TruffleString execute(Node arg0Value, AbstractTruffleString.NativePointer arg1Value, int arg2Value, int arg3Value, TruffleString.Encoding arg4Value, boolean arg5Value) {
                return TStringInternalNodes.FromNativePointerNode.fromNativePointerInternal(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.FromNativePointerNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.FromNativePointerNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile asciiLatinBytesProfile_;
            private final InlinedConditionProfile utf8Profile_;
            private final InlinedConditionProfile utf8BrokenProfile_;
            private final InlinedConditionProfile utf16Profile_;
            private final InlinedConditionProfile utf32Profile_;
            private final InlinedConditionProfile exoticValidProfile_;
            private final InlinedConditionProfile exoticFixedWidthProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.FromNativePointerNode.class));
                this.state_0_ = target.getState(0, 14);
                this.asciiLatinBytesProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(0, 2)));
                this.utf8Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(2, 2)));
                this.utf8BrokenProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(4, 2)));
                this.utf16Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(6, 2)));
                this.utf32Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(8, 2)));
                this.exoticValidProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(10, 2)));
                this.exoticFixedWidthProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(12, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString.NativePointer arg1Value, int arg2Value, int arg3Value, TruffleString.Encoding arg4Value, boolean arg5Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_));
                return TStringInternalNodes.FromNativePointerNode.fromNativePointerInternal(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, this.asciiLatinBytesProfile_, this.utf8Profile_, this.utf8BrokenProfile_, this.utf16Profile_, this.utf32Profile_, this.exoticValidProfile_, this.exoticFixedWidthProfile_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode.class)
    static final class FromBufferWithStringCompactionKnownAttributesNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        FromBufferWithStringCompactionKnownAttributesNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=31, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(bits=29, value=InlineSupport.StateField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, boolean arg2Value, TruffleString.Encoding arg3Value) {
                return TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, TStringInternalNodes.GetCodePointLengthNode.getUncached(), GetPreciseCodeRangeNodeGen.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.StateField state_1_;
            private final TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode_;
            private final TStringInternalNodes.GetPreciseCodeRangeNode getPreciseCodeRangeNode_;
            private final InlinedConditionProfile utf16Profile_;
            private final InlinedConditionProfile utf16CompactProfile_;
            private final InlinedConditionProfile utf32Profile_;
            private final InlinedConditionProfile utf32Compact0Profile_;
            private final InlinedConditionProfile utf32Compact1Profile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode.class));
                this.state_0_ = target.getState(0, 31);
                this.state_1_ = target.getState(1, 29);
                this.getCodePointLengthNode_ = GetCodePointLengthNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.GetCodePointLengthNode.class, this.state_0_.subUpdater(0, 25)));
                this.getPreciseCodeRangeNode_ = GetPreciseCodeRangeNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.GetPreciseCodeRangeNode.class, this.state_1_.subUpdater(0, 25)));
                this.utf16Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(29, 2)));
                this.utf16CompactProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_1_.subUpdater(25, 2)));
                this.utf32Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_1_.subUpdater(27, 2)));
                this.utf32Compact0Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(25, 2)));
                this.utf32Compact1Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(27, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, AbstractTruffleString arg1Value, boolean arg2Value, TruffleString.Encoding arg3Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_1_, this.state_0_, this.state_1_, this.state_1_, this.state_0_, this.state_0_));
                return TStringInternalNodes.FromBufferWithStringCompactionKnownAttributesNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, this.getCodePointLengthNode_, this.getPreciseCodeRangeNode_, this.utf16Profile_, this.utf16CompactProfile_, this.utf32Profile_, this.utf32Compact0Profile_, this.utf32Compact1Profile_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.FromBufferWithStringCompactionNode.class)
    static final class FromBufferWithStringCompactionNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        FromBufferWithStringCompactionNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.FromBufferWithStringCompactionNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.FromBufferWithStringCompactionNode inline(@InlineSupport.RequiredField(bits=20, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.FromBufferWithStringCompactionNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.FromBufferWithStringCompactionNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            TruffleString execute(Node arg0Value, Object arg1Value, int arg2Value, int arg3Value, TruffleString.Encoding arg4Value, boolean arg5Value, boolean arg6Value) {
                return TStringInternalNodes.FromBufferWithStringCompactionNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.FromBufferWithStringCompactionNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.FromBufferWithStringCompactionNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile asciiLatinBytesProfile_;
            private final InlinedConditionProfile utf8Profile_;
            private final InlinedConditionProfile utf8BrokenProfile_;
            private final InlinedConditionProfile utf16Profile_;
            private final InlinedConditionProfile utf16CompactProfile_;
            private final InlinedConditionProfile utf32Profile_;
            private final InlinedConditionProfile utf32Compact0Profile_;
            private final InlinedConditionProfile utf32Compact1Profile_;
            private final InlinedConditionProfile exoticValidProfile_;
            private final InlinedConditionProfile exoticFixedWidthProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.FromBufferWithStringCompactionNode.class));
                this.state_0_ = target.getState(0, 20);
                this.asciiLatinBytesProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(0, 2)));
                this.utf8Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(2, 2)));
                this.utf8BrokenProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(4, 2)));
                this.utf16Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(6, 2)));
                this.utf16CompactProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(8, 2)));
                this.utf32Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(10, 2)));
                this.utf32Compact0Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(12, 2)));
                this.utf32Compact1Profile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(14, 2)));
                this.exoticValidProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(16, 2)));
                this.exoticFixedWidthProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(18, 2)));
            }

            @Override
            TruffleString execute(Node arg0Value, Object arg1Value, int arg2Value, int arg3Value, TruffleString.Encoding arg4Value, boolean arg5Value, boolean arg6Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_, this.state_0_));
                return TStringInternalNodes.FromBufferWithStringCompactionNode.fromBufferWithStringCompaction(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, this.asciiLatinBytesProfile_, this.utf8Profile_, this.utf8BrokenProfile_, this.utf16Profile_, this.utf16CompactProfile_, this.utf32Profile_, this.utf32Compact0Profile_, this.utf32Compact1Profile_, this.exoticValidProfile_, this.exoticFixedWidthProfile_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.GetCodePointLengthNode.class)
    static final class GetCodePointLengthNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        GetCodePointLengthNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.GetCodePointLengthNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.GetCodePointLengthNode inline(@InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.GetCodePointLengthNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.GetCodePointLengthNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, TruffleString.Encoding arg2Value) {
                return TStringInternalNodes.GetCodePointLengthNode.get(arg0Value, arg1Value, arg2Value, InlinedConditionProfile.getUncached(), TruffleString.ToIndexableNode.getUncached(), CalcStringAttributesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.GetCodePointLengthNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.GetCodePointLengthNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile cacheMissProfile_;
            private final TruffleString.ToIndexableNode toIndexableNode_;
            private final TStringInternalNodes.CalcStringAttributesNode calcStringAttributesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.GetCodePointLengthNode.class));
                this.state_0_ = target.getState(0, 25);
                this.cacheMissProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(0, 2)));
                this.toIndexableNode_ = TruffleStringFactory.ToIndexableNodeGen.inline(InlineSupport.InlineTarget.create(TruffleString.ToIndexableNode.class, this.state_0_.subUpdater(2, 7)));
                this.calcStringAttributesNode_ = CalcStringAttributesNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.CalcStringAttributesNode.class, this.state_0_.subUpdater(9, 16)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, TruffleString.Encoding arg2Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                return TStringInternalNodes.GetCodePointLengthNode.get(arg0Value, arg1Value, arg2Value, this.cacheMissProfile_, this.toIndexableNode_, this.calcStringAttributesNode_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.GetPreciseCodeRangeNode.class)
    static final class GetPreciseCodeRangeNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        GetPreciseCodeRangeNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.GetPreciseCodeRangeNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.GetPreciseCodeRangeNode inline(@InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.GetPreciseCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.GetPreciseCodeRangeNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, TruffleString.Encoding arg2Value) {
                return TStringInternalNodes.GetPreciseCodeRangeNode.get(arg0Value, arg1Value, arg2Value, InlinedConditionProfile.getUncached(), TruffleString.ToIndexableNode.getUncached(), CalcStringAttributesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.GetPreciseCodeRangeNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.GetPreciseCodeRangeNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile impreciseProfile_;
            private final TruffleString.ToIndexableNode toIndexableNode_;
            private final TStringInternalNodes.CalcStringAttributesNode calcStringAttributesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.GetPreciseCodeRangeNode.class));
                this.state_0_ = target.getState(0, 25);
                this.impreciseProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(0, 2)));
                this.toIndexableNode_ = TruffleStringFactory.ToIndexableNodeGen.inline(InlineSupport.InlineTarget.create(TruffleString.ToIndexableNode.class, this.state_0_.subUpdater(2, 7)));
                this.calcStringAttributesNode_ = CalcStringAttributesNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.CalcStringAttributesNode.class, this.state_0_.subUpdater(9, 16)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, TruffleString.Encoding arg2Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                return TStringInternalNodes.GetPreciseCodeRangeNode.get(arg0Value, arg1Value, arg2Value, this.impreciseProfile_, this.toIndexableNode_, this.calcStringAttributesNode_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.GetValidOrBrokenCodeRangeNode.class)
    static final class GetValidOrBrokenCodeRangeNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        GetValidOrBrokenCodeRangeNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.GetValidOrBrokenCodeRangeNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.GetValidOrBrokenCodeRangeNode inline(@InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.GetValidOrBrokenCodeRangeNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.GetValidOrBrokenCodeRangeNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, TruffleString.Encoding arg2Value) {
                return TStringInternalNodes.GetValidOrBrokenCodeRangeNode.get(arg0Value, arg1Value, arg2Value, InlinedConditionProfile.getUncached(), TruffleString.ToIndexableNode.getUncached(), CalcStringAttributesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.GetValidOrBrokenCodeRangeNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.GetValidOrBrokenCodeRangeNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile impreciseProfile_;
            private final TruffleString.ToIndexableNode toIndexableNode_;
            private final TStringInternalNodes.CalcStringAttributesNode calcStringAttributesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.GetValidOrBrokenCodeRangeNode.class));
                this.state_0_ = target.getState(0, 25);
                this.impreciseProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(0, 2)));
                this.toIndexableNode_ = TruffleStringFactory.ToIndexableNodeGen.inline(InlineSupport.InlineTarget.create(TruffleString.ToIndexableNode.class, this.state_0_.subUpdater(2, 7)));
                this.calcStringAttributesNode_ = CalcStringAttributesNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.CalcStringAttributesNode.class, this.state_0_.subUpdater(9, 16)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, TruffleString.Encoding arg2Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                return TStringInternalNodes.GetValidOrBrokenCodeRangeNode.get(arg0Value, arg1Value, arg2Value, this.impreciseProfile_, this.toIndexableNode_, this.calcStringAttributesNode_);
            }
        }
    }

    @GeneratedBy(value=TStringInternalNodes.GetCodeRangeForIndexCalculationNode.class)
    static final class GetCodeRangeForIndexCalculationNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        GetCodeRangeForIndexCalculationNodeGen() {
        }

        @NeverDefault
        public static TStringInternalNodes.GetCodeRangeForIndexCalculationNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringInternalNodes.GetCodeRangeForIndexCalculationNode inline(@InlineSupport.RequiredField(bits=25, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringInternalNodes.GetCodeRangeForIndexCalculationNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringInternalNodes.GetCodeRangeForIndexCalculationNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, TruffleString.Encoding arg2Value) {
                return TStringInternalNodes.GetCodeRangeForIndexCalculationNode.get(arg0Value, arg1Value, arg2Value, InlinedConditionProfile.getUncached(), TruffleString.ToIndexableNode.getUncached(), CalcStringAttributesNodeGen.getUncached());
            }
        }

        @GeneratedBy(value=TStringInternalNodes.GetCodeRangeForIndexCalculationNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringInternalNodes.GetCodeRangeForIndexCalculationNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlinedConditionProfile impreciseProfile_;
            private final TruffleString.ToIndexableNode toIndexableNode_;
            private final TStringInternalNodes.CalcStringAttributesNode calcStringAttributesNode_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringInternalNodes.GetCodeRangeForIndexCalculationNode.class));
                this.state_0_ = target.getState(0, 25);
                this.impreciseProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(0, 2)));
                this.toIndexableNode_ = TruffleStringFactory.ToIndexableNodeGen.inline(InlineSupport.InlineTarget.create(TruffleString.ToIndexableNode.class, this.state_0_.subUpdater(2, 7)));
                this.calcStringAttributesNode_ = CalcStringAttributesNodeGen.inline(InlineSupport.InlineTarget.create(TStringInternalNodes.CalcStringAttributesNode.class, this.state_0_.subUpdater(9, 16)));
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, TruffleString.Encoding arg2Value) {
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                return TStringInternalNodes.GetCodeRangeForIndexCalculationNode.get(arg0Value, arg1Value, arg2Value, this.impreciseProfile_, this.toIndexableNode_, this.calcStringAttributesNode_);
            }
        }
    }
}

