/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.xml;

import java.util.ArrayList;
import java.util.List;
import org.enhydra.xml.HashMapElement;
import org.enhydra.xml.NodeListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SearchElement
extends HashMapElement {
    public static String TAG_SEPARATOR = "/";
    public static String ATTR_SEPARATOR = "@";
    public static String EQUAL_SEPARATOR = "=";

    public SearchElement() {
    }

    public SearchElement(Document ownerDoc, String name) {
        super(ownerDoc, name);
    }

    public SearchElement(Node node) {
        super(node);
    }

    public SearchElement(SearchElement node) {
        super(node);
    }

    @Override
    protected Node newElementInstance(Node node) {
        return new SearchElement(node);
    }

    public static Element newInstance(Document document) {
        Element root = document.getDocumentElement();
        return new SearchElement(root);
    }

    public NodeList getSubElementsByTagName(String namePath) {
        ArrayList list = new ArrayList();
        this.getSubElementsByTagName(namePath, list);
        return new NodeListImpl(list);
    }

    private void getSubElementsByTagName(String name, List list) {
        String[] keys = this.split(name, TAG_SEPARATOR);
        if (keys.length == 1) {
            List l = (List)this.children.get(name);
            if (l != null) {
                list.addAll(l);
            }
            return;
        }
        NodeList tagChildren = this.getChildrenByTagName(keys[0]);
        if (tagChildren != null) {
            for (int i = 0; i < tagChildren.getLength(); ++i) {
                ((SearchElement)tagChildren.item(i)).getSubElementsByTagName(keys[1], list);
            }
        }
    }

    public NodeList getSubElementsByAttrValue(String attrPath, String attrValue) {
        String[] keys = this.split(attrPath, ATTR_SEPARATOR);
        if (keys.length != 2) {
            throw new DOMException(15, "Parameter not supported");
        }
        ArrayList list = new ArrayList();
        this.getSubElementsByAttrValue(keys[0], keys[1], attrValue, list);
        return new NodeListImpl(list);
    }

    private void getSubElementsByAttrValue(String tagName, String attrName, String attrValue, List list) {
        String[] keys = this.split(tagName, TAG_SEPARATOR);
        if (keys.length == 1) {
            List fList = (List)this.children.get(tagName);
            if (fList != null) {
                for (int i = 0; i < fList.size(); ++i) {
                    Element elm = (Element)fList.get(i);
                    String val = elm.getAttribute(attrName);
                    if (val == null || !val.equals(attrValue)) continue;
                    list.add(elm);
                }
            }
            return;
        }
        NodeList tagChildren = this.getChildrenByTagName(keys[0]);
        if (tagChildren != null) {
            for (int i = 0; i < tagChildren.getLength(); ++i) {
                ((SearchElement)tagChildren.item(i)).getSubElementsByAttrValue(keys[1], attrName, attrValue, list);
            }
        }
    }

    public NodeList getSubElementsByTagText(String tagPath, String tagValue) {
        ArrayList list = new ArrayList();
        this.getSubElementsByTagText(tagPath, tagValue, list);
        return new NodeListImpl(list);
    }

    private void getSubElementsByTagText(String tagName, String tagValue, List list) {
        String[] keys = this.split(tagName, TAG_SEPARATOR);
        if (keys.length == 1) {
            List fList = (List)this.children.get(tagName);
            if (fList != null) {
                for (int i = 0; i < fList.size(); ++i) {
                    HashMapElement elm = (HashMapElement)fList.get(i);
                    String val = elm.getText();
                    if (val != null) {
                        if (!val.equals(tagValue)) continue;
                        list.add(elm);
                        continue;
                    }
                    if (!"null".equals(tagValue)) continue;
                    list.add(elm);
                }
            }
            return;
        }
        NodeList tagChildren = this.getChildrenByTagName(keys[0]);
        if (tagChildren != null) {
            for (int i = 0; i < tagChildren.getLength(); ++i) {
                ((SearchElement)tagChildren.item(i)).getSubElementsByTagText(keys[1], tagValue, list);
            }
        }
    }

    public NodeList getSubElementsByCondition(String condition) {
        String[] keys = this.split(condition, EQUAL_SEPARATOR);
        String namePath = keys[0];
        if (namePath.indexOf(ATTR_SEPARATOR) != -1) {
            return this.getSubElementsByAttrValue(namePath, keys[1]);
        }
        return this.getSubElementsByTagText(namePath, keys[1]);
    }

    public Element getFirstSubElementsByCondition(String condition) {
        NodeList nodes = this.getSubElementsByCondition(condition);
        if (nodes != null && nodes.getLength() > 0) {
            return (Element)nodes.item(0);
        }
        return null;
    }

    public Element getFirstSubElementByTagName(String namePath) {
        NodeList nodes = this.getSubElementsByTagName(namePath);
        if (nodes != null && nodes.getLength() > 0) {
            return (Element)nodes.item(0);
        }
        return null;
    }

    public String getText(String namePath) {
        NodeList nodes = this.getSubElementsByTagName(namePath);
        if (nodes != null && nodes.getLength() > 0) {
            return ((SearchElement)nodes.item(0)).getText();
        }
        return null;
    }

    public void setText(String namePath, String text) {
        NodeList nodes = this.getSubElementsByTagName(namePath);
        if (nodes != null && nodes.getLength() > 0) {
            ((SearchElement)nodes.item(0)).setText(text);
        }
    }

    public void setAttr(String namePath, String value) {
        String[] keys = this.split(namePath, ATTR_SEPARATOR);
        NodeList nodes = this.getSubElementsByTagName(keys[0]);
        if (nodes != null && nodes.getLength() > 0) {
            ((SearchElement)nodes.item(0)).setAttribute(keys[1], value);
        }
    }

    private String[] split(String text, String separator) {
        String[] splitText = new String[2];
        int separatorIndex = text.indexOf(separator);
        if (separatorIndex == -1) {
            splitText = new String[]{text};
        } else {
            splitText[0] = text.substring(0, separatorIndex);
            splitText[1] = text.substring(separatorIndex + 1, text.length());
        }
        return splitText;
    }
}

