/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.xml;

import org.enhydra.xml.CommentImpl;
import org.enhydra.xml.ElementImpl;
import org.enhydra.xml.Indent;
import org.enhydra.xml.NodeDOMException;
import org.enhydra.xml.TextImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NodeImpl
implements Node,
NodeList {
    protected Document ownerDocument;
    protected String nodeName = null;
    protected String nodeValue = null;
    protected short type = 1;
    protected NodeImpl parent = null;
    protected int numChildren = 0;
    protected NodeImpl firstChild = null;
    protected NodeImpl lastChild = null;
    protected NodeImpl nextSibling = null;
    protected NodeImpl previousSibling = null;

    public NodeImpl() {
    }

    public NodeImpl(NodeImpl node) {
        this.ownerDocument = node.ownerDocument;
        this.nodeName = node.nodeName;
        this.nodeValue = node.nodeValue;
        this.type = node.type;
        this.parent = node.parent;
        this.numChildren = node.numChildren;
        this.firstChild = node.firstChild;
        this.lastChild = node.lastChild;
        this.nextSibling = node.nextSibling;
        this.previousSibling = node.previousSibling;
    }

    public NodeImpl(Node node) {
        this(node, true);
    }

    public NodeImpl(Node node, boolean deep) {
        this.ownerDocument = node.getOwnerDocument();
        this.nodeName = node.getNodeName();
        this.type = node.getNodeType();
        this.nodeValue = node.getNodeValue();
        if (deep) {
            this.initNodeImplChildren(node);
        }
    }

    public NodeImpl(Document ownerDoc, String name) {
        this.ownerDocument = ownerDoc;
        this.nodeName = this.nodeName;
    }

    public NodeImpl(Document ownerDoc, String nodeName, short type) {
        this.ownerDocument = ownerDoc;
        this.nodeName = nodeName;
        this.type = type;
    }

    public NodeImpl(Document ownerDoc, String nodeName, short type, String value) {
        this.ownerDocument = ownerDoc;
        this.nodeName = nodeName;
        this.type = type;
        this.nodeValue = value;
    }

    protected void initNodeImplChildren(Node node) {
        block5: for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: {
                    this.appendChild(this.newElementInstance(child));
                    continue block5;
                }
                case 3: {
                    this.appendChild(this.newTextInstance(child));
                    continue block5;
                }
                case 8: {
                    this.appendChild(this.newCommentInstance(child));
                    continue block5;
                }
                default: {
                    this.appendChild(this.newDefaultInstance(child));
                }
            }
        }
    }

    protected Node newElementInstance(Node node) {
        return new ElementImpl(node);
    }

    protected Node newTextInstance(Node node) {
        return new TextImpl(node);
    }

    protected Node newCommentInstance(Node node) {
        return new CommentImpl(node);
    }

    protected Node newDefaultInstance(Node node) {
        return new NodeImpl(node);
    }

    private void checkNode(Node node) throws DOMException {
        if (node == null) {
            return;
        }
        if (!(node instanceof NodeImpl)) {
            throw new NodeDOMException(4, "Node not an NodeImpl!");
        }
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getNodeValue() {
        return this.nodeValue;
    }

    @Override
    public void setNodeValue(String nodeValue) {
        this.nodeValue = nodeValue;
    }

    @Override
    public short getNodeType() {
        return this.type;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    @Override
    public NodeList getChildNodes() {
        return this;
    }

    @Override
    public Node getFirstChild() {
        return this.firstChild;
    }

    @Override
    public Node getLastChild() {
        return this.lastChild;
    }

    @Override
    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public Node getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(newChild);
        this.checkNode(refChild);
        NodeImpl newChildNode = (NodeImpl)newChild;
        NodeImpl refChildNode = (NodeImpl)refChild;
        NodeImpl previous = null;
        NodeImpl next = null;
        if (refChild == null) {
            previous = this.lastChild;
            next = null;
            this.lastChild = newChildNode;
        } else {
            previous = refChildNode.previousSibling;
            next = refChildNode;
        }
        if (previous != null) {
            previous.nextSibling = newChildNode;
        }
        if (next != null) {
            next.previousSibling = newChildNode;
        }
        newChildNode.parent = this;
        newChildNode.previousSibling = previous;
        newChildNode.nextSibling = next;
        if (this.firstChild == refChildNode) {
            this.firstChild = newChildNode;
        }
        ++this.numChildren;
        return newChildNode;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(newChild);
        this.checkNode(oldChild);
        NodeImpl newChildNode = (NodeImpl)newChild;
        NodeImpl oldChildNode = (NodeImpl)oldChild;
        NodeImpl previous = oldChildNode.previousSibling;
        NodeImpl next = oldChildNode.nextSibling;
        if (previous != null) {
            previous.nextSibling = newChildNode;
        }
        if (next != null) {
            next.previousSibling = newChildNode;
        }
        newChildNode.parent = this;
        newChildNode.previousSibling = previous;
        newChildNode.nextSibling = next;
        if (this.firstChild == oldChildNode) {
            this.firstChild = newChildNode;
        }
        if (this.lastChild == oldChildNode) {
            this.lastChild = newChildNode;
        }
        oldChildNode.parent = null;
        oldChildNode.previousSibling = null;
        oldChildNode.nextSibling = null;
        return oldChildNode;
    }

    @Override
    public Node removeChild(Node oldChild) {
        if (oldChild == null) {
            throw new IllegalArgumentException("oldChild == null!");
        }
        this.checkNode(oldChild);
        NodeImpl oldChildNode = (NodeImpl)oldChild;
        NodeImpl previous = oldChildNode.previousSibling;
        NodeImpl next = oldChildNode.nextSibling;
        if (previous != null) {
            previous.nextSibling = next;
        }
        if (next != null) {
            next.previousSibling = previous;
        }
        if (this.firstChild == oldChildNode) {
            this.firstChild = next;
        }
        if (this.lastChild == oldChildNode) {
            this.lastChild = previous;
        }
        oldChildNode.parent = null;
        oldChildNode.previousSibling = null;
        oldChildNode.nextSibling = null;
        --this.numChildren;
        return oldChildNode;
    }

    @Override
    public Node appendChild(Node newChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild == null!");
        }
        this.checkNode(newChild);
        return this.insertBefore(newChild, null);
    }

    @Override
    public boolean hasChildNodes() {
        return this.numChildren > 0;
    }

    @Override
    public Node cloneNode(boolean deep) {
        return new NodeImpl(this, deep);
    }

    @Override
    public void normalize() {
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) {
    }

    @Override
    public String getLocalName() {
        return this.nodeName;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public int getLength() {
        return this.numChildren;
    }

    @Override
    public Node item(int index) {
        Node child;
        if (index < 0) {
            return null;
        }
        for (child = this.getFirstChild(); child != null && index-- > 0; child = child.getNextSibling()) {
        }
        return child;
    }

    public String toString() {
        return this.toString(Indent.DEFAULT_TAB);
    }

    public String toString(String tab) {
        StringBuffer sb = new StringBuffer();
        this.allToString(sb, new Indent(0, tab));
        return sb.toString();
    }

    protected void beginToString(StringBuffer sb, Indent indent) {
    }

    protected void endToString(StringBuffer sb, Indent indent) {
    }

    private void allToString(StringBuffer sb, Indent indent) {
        this.beginToString(sb, indent);
        for (Node child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            ((NodeImpl)child).allToString(sb, indent);
        }
        this.endToString(sb, indent);
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node arg0) throws DOMException {
        return 0;
    }

    @Override
    public String getTextContent() throws DOMException {
        return null;
    }

    @Override
    public void setTextContent(String arg0) throws DOMException {
    }

    @Override
    public boolean isSameNode(Node arg0) {
        return false;
    }

    @Override
    public String lookupPrefix(String arg0) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String arg0) {
        return false;
    }

    @Override
    public String lookupNamespaceURI(String arg0) {
        return null;
    }

    @Override
    public boolean isEqualNode(Node arg0) {
        return false;
    }

    @Override
    public Object getFeature(String arg0, String arg1) {
        return null;
    }

    @Override
    public Object setUserData(String arg0, Object arg1, UserDataHandler arg2) {
        return null;
    }

    @Override
    public Object getUserData(String arg0) {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }
}

