/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.LogChannel;
import com.lutris.logging.Logger;
import com.lutris.logging.StandardLogChannel;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import com.lutris.util.ConfigFile;
import com.lutris.util.KeywordValueException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;

public class StandardLogger
extends Logger {
    private static final String LOG_SECTION = "Server";
    private static final String LOG_FILE = "LogFile";
    private static final String LOG_TO_FILE = "LogToFile";
    private static final String LOG_TO_STDERR = "LogToStderr";
    private Hashtable levelNumbers = new Hashtable();
    protected String[] levelNames = new String[34];
    protected int numLevels = 0;
    protected boolean[] enabledLevelFlags = null;
    protected boolean[] logFileLevelFlags = null;
    protected boolean[] stderrLevelFlags = null;
    File activeLogFile;
    PrintWriter logFileStream;
    PrintWriter stderrStream;
    private Hashtable logChannels = new Hashtable();

    public StandardLogger(boolean makeCentral) {
        int level;
        for (level = 0; level <= 17; ++level) {
            String name = standardLevelNames[level];
            this.levelNumbers.put(name, new Integer(level));
            this.levelNames[level] = name;
        }
        this.numLevels = level;
        if (makeCentral) {
            centralLogger = this;
        }
    }

    private int getMaxLevel(String[] levels) {
        int maxLevelNum = 0;
        for (int idx = 0; idx < levels.length; ++idx) {
            int levelNum = this.getLevel(levels[idx]);
            if (levelNum <= maxLevelNum) continue;
            maxLevelNum = levelNum;
        }
        return maxLevelNum;
    }

    private boolean[] getLevelStateArray(String[] levels, int maxLevelNum) {
        boolean[] levelNums = new boolean[maxLevelNum + 1];
        for (int idx = 0; idx < levels.length; ++idx) {
            levelNums[this.getLevel((String)levels[idx])] = true;
        }
        return levelNums;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File switchLogFile(File logFile) throws IOException {
        PrintWriter oldLogFileStream = this.logFileStream;
        File oldActiveLogFile = this.activeLogFile;
        FileOutputStream out = new FileOutputStream(logFile.getPath(), true);
        this.logFileStream = new PrintWriter(out, false);
        this.activeLogFile = logFile;
        if (oldLogFileStream != null) {
            PrintWriter printWriter = oldLogFileStream;
            synchronized (printWriter) {
                oldLogFileStream.close();
            }
        }
        return oldActiveLogFile;
    }

    public synchronized void configure(File logFile, String[] fileLevels, String[] stderrLevels) throws IOException {
        int idx;
        if (logFile.getParent() != null) {
            new File(logFile.getParent()).mkdirs();
        }
        this.switchLogFile(logFile);
        this.stderrStream = new PrintWriter(System.err, false);
        int maxLevelNum = this.enabledLevelFlags != null ? this.enabledLevelFlags.length - 1 : 17;
        int levelNum = this.getMaxLevel(fileLevels);
        if (levelNum > maxLevelNum) {
            maxLevelNum = levelNum;
        }
        if ((levelNum = this.getMaxLevel(stderrLevels)) > maxLevelNum) {
            maxLevelNum = levelNum;
        }
        this.logFileLevelFlags = this.getLevelStateArray(fileLevels, maxLevelNum);
        this.stderrLevelFlags = this.getLevelStateArray(stderrLevels, maxLevelNum);
        this.enabledLevelFlags = new boolean[maxLevelNum + 1];
        for (idx = 0; idx < this.logFileLevelFlags.length; ++idx) {
            if (!this.logFileLevelFlags[idx]) continue;
            this.enabledLevelFlags[idx] = true;
        }
        for (idx = 0; idx < this.stderrLevelFlags.length; ++idx) {
            if (!this.stderrLevelFlags[idx]) continue;
            this.enabledLevelFlags[idx] = true;
        }
    }

    private synchronized StandardLogChannel createChannel(String facility) {
        StandardLogChannel channel = (StandardLogChannel)this.logChannels.get(facility);
        if (channel == null) {
            channel = new StandardLogChannel(facility, this);
            this.logChannels.put(facility, channel);
        }
        return channel;
    }

    @Override
    public LogChannel getChannel(String facility) {
        StandardLogChannel channel = (StandardLogChannel)this.logChannels.get(facility);
        if (channel == null) {
            channel = this.createChannel(facility);
        }
        return channel;
    }

    private synchronized Integer createLevel(String level) {
        Integer intLevel = (Integer)this.levelNumbers.get(level);
        if (intLevel == null) {
            intLevel = new Integer(this.numLevels);
            this.levelNames[this.numLevels] = level;
            this.levelNumbers.put(level, intLevel);
            ++this.numLevels;
        }
        return intLevel;
    }

    public synchronized int getLevel(String level) {
        Integer intLevel = (Integer)this.levelNumbers.get(level);
        if (intLevel == null) {
            intLevel = this.createLevel(level);
        }
        return intLevel;
    }

    public String getLevelName(int level) {
        if (level >= 0 && level < this.numLevels) {
            return this.levelNames[level];
        }
        return null;
    }

    @Override
    public void configure(String confFilePath) throws ConfigException {
        try {
            FileInputStream configFIS = new FileInputStream(confFilePath);
            ConfigFile cFile = new ConfigFile(configFIS);
            Config config = cFile.getConfig();
            configFIS.close();
            Config logConfig = (Config)config.getSection(LOG_SECTION);
            this.configure(logConfig);
        }
        catch (KeywordValueException kve) {
            throw new ConfigException("Error parsing configuration for logger.", kve);
        }
        catch (IOException ioe) {
            throw new ConfigException("Error configuring logger.", ioe);
        }
    }

    @Override
    public void configure(Config logConfig) throws ConfigException {
        if (logConfig == null) {
            throw new ConfigException("Cannot configure logger. Config is null.");
        }
        String logFile = null;
        logFile = logConfig.getString(LOG_FILE);
        String[] toFile = null;
        toFile = logConfig.getStrings(LOG_TO_FILE);
        String[] toStderr = null;
        toStderr = logConfig.getStrings(LOG_TO_STDERR);
        File theLogFile = new File(logFile);
        try {
            this.configure(theLogFile, toFile, toStderr);
        }
        catch (IOException ioe) {
            throw new ConfigException("Error configuring logger.", ioe);
        }
    }
}

