/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.LogChannel;
import com.lutris.logging.LogWriter;
import com.lutris.logging.StandardLogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StandardLogChannel
implements LogChannel {
    private String facility;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    private StandardLogger logger;

    protected StandardLogChannel(String chanFacility, StandardLogger loggerObj) {
        this.facility = chanFacility;
        this.logger = loggerObj;
    }

    @Override
    public int getLevel(String level) {
        return this.logger.getLevel(level);
    }

    @Override
    public LogWriter getLogWriter(String level) {
        return new LogWriter((LogChannel)this, level);
    }

    @Override
    public LogWriter getLogWriter(int level) {
        return new LogWriter((LogChannel)this, level);
    }

    @Override
    public boolean isEnabled(int level) {
        boolean[] enabledLevelFlags = this.logger.enabledLevelFlags;
        return enabledLevelFlags != null && level >= 0 && level < enabledLevelFlags.length && enabledLevelFlags[level];
    }

    @Override
    public boolean isEnabled(String level) {
        return this.isEnabled(this.logger.getLevel(level));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(PrintWriter out, Date date, int level, String msg) {
        try {
            StringBuffer msgBuf = new StringBuffer();
            dateFormatter.format(date, msgBuf, new FieldPosition(1));
            msgBuf.append(": ");
            msgBuf.append(this.facility);
            msgBuf.append(',');
            msgBuf.append(this.logger.levelNames[level]);
            int nextIdx = 0;
            PrintWriter printWriter = out;
            synchronized (printWriter) {
                while (nextIdx < msg.length()) {
                    out.print(msgBuf);
                    if (nextIdx == 0) {
                        out.print(": ");
                    } else {
                        out.print("+ ");
                    }
                    int newlineIdx = msg.indexOf(10, nextIdx);
                    if (newlineIdx < 0) {
                        newlineIdx = msg.length();
                    }
                    out.write(msg, nextIdx, newlineIdx - nextIdx);
                    out.println();
                    nextIdx = newlineIdx + 1;
                }
                out.flush();
            }
        }
        catch (Throwable ignore) {
            System.err.println("StandardLogChannel.doWrite ignored exception:");
            ignore.printStackTrace();
        }
    }

    @Override
    public void write(int level, String msg) {
        if (this.isEnabled(level)) {
            Date date = new Date();
            if (this.logger.logFileLevelFlags[level]) {
                this.doWrite(this.logger.logFileStream, date, level, msg);
            }
            if (this.logger.stderrLevelFlags[level]) {
                this.doWrite(this.logger.stderrStream, date, level, msg);
            }
        }
    }

    @Override
    public synchronized void write(String level, String msg) {
        this.write(this.getLevel(level), msg);
    }

    @Override
    public synchronized void write(int level, String msg, Throwable throwable) {
        if (this.isEnabled(level)) {
            Date date = new Date();
            StringWriter stackBuf = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stackBuf));
            stackBuf.flush();
            String errMsg = msg + ": " + throwable.getMessage() + '\n' + stackBuf;
            if (this.logger.logFileLevelFlags[level]) {
                this.doWrite(this.logger.logFileStream, date, level, errMsg);
            }
            if (this.logger.stderrLevelFlags[level]) {
                this.doWrite(this.logger.stderrStream, date, level, errMsg);
            }
        }
    }

    @Override
    public synchronized void write(String level, String msg, Throwable throwable) {
        this.write(this.getLevel(level), msg, throwable);
    }
}

