/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.logging;

import com.lutris.logging.ChannelWriter;
import com.lutris.logging.LogChannel;
import java.io.PrintWriter;
import java.io.Writer;

public class LogWriter
extends PrintWriter {
    private LogChannel channel;
    private int level;
    private boolean enabled;

    protected LogWriter(LogChannel logChannel, String logLevel) {
        this(logChannel, logChannel.getLevel(logLevel));
    }

    protected LogWriter(LogChannel logChannel, int logLevel) {
        super((Writer)new ChannelWriter(logChannel, logLevel), true);
        this.channel = logChannel;
        this.level = logLevel;
        this.enabled = logChannel.isEnabled(this.level);
    }

    public LogChannel getChannel() {
        return this.channel;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void println(String msg, Throwable throwable) {
        if (this.enabled) {
            this.flush();
            this.channel.write(this.level, msg, throwable);
        }
    }
}

