/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPathEntry;
import com.lutris.logging.LogChannel;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public abstract class Resource {
    protected String name = null;
    protected ClassPathEntry location = null;
    protected long size = -1L;
    protected long lastModifiedTime = -1L;
    protected boolean loggingEnabled = false;
    protected LogChannel logChannel;
    protected int logLevel;

    protected Resource(String name, ClassPathEntry location, LogChannel loadLogChannel) throws NullPointerException {
        this.logChannel = loadLogChannel;
        if (this.logChannel != null) {
            this.logLevel = this.logChannel.getLevel("CLASSLOAD");
            this.loggingEnabled = this.logChannel.isEnabled(this.logLevel);
        }
        if (name == null || location == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.location = location;
    }

    public String getName() {
        return this.name;
    }

    public ClassPathEntry getLocation() {
        return this.location;
    }

    public String toString() {
        return "[" + this.location + "][" + this.name + "]";
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getTime() {
        return this.lastModifiedTime;
    }

    public abstract long getCurrentLastModifiedTime() throws FileNotFoundException;

    public boolean hasBeenModified() throws FileNotFoundException {
        long currentTime = this.getCurrentLastModifiedTime();
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "hasBeenModified: " + this.getName() + ": current time=" + currentTime + ", last time=" + this.lastModifiedTime);
        }
        return currentTime > this.lastModifiedTime;
    }

    private byte[] getBytesKnowSize(InputStream inputStream) throws IOException {
        int bytesRead;
        byte[] bytes = new byte[(int)this.size];
        int idx = 0;
        while ((long)idx < this.size && inputStream.available() != 0 && (bytesRead = inputStream.read(bytes, idx, (int)this.size - idx)) != -1) {
            idx += bytesRead;
        }
        if ((long)idx != this.size) {
            throw new IOException("Read of resource expected " + this.size + " bytes, got " + idx + " bytes");
        }
        return bytes;
    }

    private byte[] getBytesUnknowSize(InputStream inputStream) throws IOException {
        int bytesRead;
        byte[] byteBuffer = new byte[10240];
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        while (inputStream.available() != 0 && (bytesRead = inputStream.read(byteBuffer)) != -1) {
            byteStream.write(byteBuffer, 0, bytesRead);
        }
        return byteStream.toByteArray();
    }

    public byte[] getBytes() throws IOException {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            throw new IOException("Null InputStream for resource, " + this);
        }
        try {
            if (this.size >= 0L) {
                byte[] byArray = this.getBytesKnowSize(inputStream);
                return byArray;
            }
            byte[] byArray = this.getBytesUnknowSize(inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    public abstract InputStream getInputStream() throws IOException;

    public boolean equals(Resource resource) {
        return this.name.equals(resource.getName()) && this.location.equals(resource.getLocation()) && this.size == resource.getSize() && this.lastModifiedTime == resource.getLastModifiedTime();
    }
}

