/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.classloader;

import com.lutris.classloader.ClassPath;
import com.lutris.classloader.ClassPathEntry;
import com.lutris.classloader.Resource;
import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class MultiClassLoader
extends ClassLoader {
    private Hashtable loadedClasses = new Hashtable();
    private ClassPath classPath;
    public static final String LOG_LEVEL = "CLASSLOAD";
    private boolean loggingEnabled = false;
    private LogChannel logChannel;
    private int logLevel;
    private Vector filters = null;
    private ClassLoader parentClassLoader;
    private ClassLoader secondaryClassLoader;
    private static ClassLoader sysClassLoader;

    public static ClassLoader getSystemClassLoader() {
        return sysClassLoader;
    }

    public MultiClassLoader(ClassLoader parent, ClassLoader secondary, LogChannel loadLogChannel) {
        this.classPath = new ClassPath(loadLogChannel);
        this.setParent(parent);
        this.secondaryClassLoader = secondary;
        this.logChannel = loadLogChannel;
        if (this.logChannel != null) {
            this.logLevel = this.logChannel.getLevel(LOG_LEVEL);
            this.loggingEnabled = this.logChannel.isEnabled(this.logLevel);
        }
    }

    public MultiClassLoader(LogChannel loadLogChannel) {
        this(null, MultiClassLoader.getSystemClassLoader(), loadLogChannel);
    }

    public MultiClassLoader(String path, LogChannel loadLogChannel) {
        this(new String[]{path}, loadLogChannel);
    }

    public MultiClassLoader(String[] path, LogChannel loadLogChannel) {
        this(loadLogChannel);
        this.setClassPath(path);
    }

    public MultiClassLoader(File path, LogChannel loadLogChannel) {
        this(new File[]{path}, loadLogChannel);
    }

    public MultiClassLoader(File[] path, LogChannel loadLogChannel) {
        this(loadLogChannel);
        this.setClassPath(path);
    }

    public MultiClassLoader(URL path, LogChannel loadLogChannel) {
        this(new URL[]{path}, loadLogChannel);
    }

    public MultiClassLoader(URL[] path, LogChannel loadLogChannel) {
        this(loadLogChannel);
        this.setClassPath(path);
    }

    public void setClassPath(String path) {
        this.setClassPath(new String[]{path});
    }

    public synchronized void setClassPath(String[] path) {
        this.classPath.set(path);
    }

    public void setClassPath(File path) {
        this.setClassPath(new File[]{path});
    }

    public synchronized void setClassPath(File[] path) {
        this.classPath.set(path);
    }

    public void setClassPath(URL path) {
        this.setClassPath(new URL[]{path});
    }

    public synchronized void setClassPath(URL[] path) {
        this.classPath.set(path);
    }

    public void addClassPath(String path) {
        this.addClassPath(new String[]{path});
    }

    public synchronized void addClassPath(String[] path) {
        this.classPath.add(path);
    }

    public void addClassPath(File path) {
        this.addClassPath(new File[]{path});
    }

    public synchronized void addClassPath(File[] path) {
        this.classPath.add(path);
    }

    public void addClassPath(URL path) {
        this.addClassPath(new URL[]{path});
    }

    public synchronized void addClassPath(URL[] path) {
        this.classPath.add(path);
    }

    public synchronized void clearClassPath() {
        this.classPath.clear();
    }

    public URL[] getClassPath() {
        int len = this.classPath.getLength();
        URL[] urlPath = new URL[len];
        Enumeration cpeEnum = this.classPath.getPath();
        for (int i = 0; i < len; ++i) {
            ClassPathEntry cpe = (ClassPathEntry)cpeEnum.nextElement();
            urlPath[i] = cpe.getURL();
        }
        return urlPath;
    }

    public static String[] parseClassPath(String path) {
        String systemSeparator = System.getProperty("path.separator");
        if (systemSeparator == null) {
            throw new NullPointerException("path.separator property not defined");
        }
        StringTokenizer tokenizer = new StringTokenizer(path, systemSeparator);
        String[] parsed = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            parsed[i] = tokenizer.nextToken();
            ++i;
        }
        return parsed;
    }

    public static URL[] getSystemClassPath() {
        String systemClassPath = System.getProperty("java.class.path");
        if (systemClassPath == null) {
            systemClassPath = "";
        }
        String[] parsedPath = MultiClassLoader.parseClassPath(systemClassPath);
        Vector<URL> urlVector = new Vector<URL>(parsedPath.length);
        for (int i = 0; i < parsedPath.length; ++i) {
            try {
                urlVector.addElement(new URL("file", "", parsedPath[i]));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        Object[] urlArray = new URL[urlVector.size()];
        urlVector.copyInto(urlArray);
        return urlArray;
    }

    public void setParent(ClassLoader parent) {
        this.parentClassLoader = null != parent ? parent : MultiClassLoader.getSystemClassLoader();
    }

    public ClassLoader getSecondary() {
        return this.secondaryClassLoader;
    }

    public void setSecondary(ClassLoader secondary) {
        this.secondaryClassLoader = secondary;
    }

    public LogChannel getLogChannel() {
        return this.logChannel;
    }

    public synchronized void addClassFilter(ClassFilter filter) {
        if (this.filters == null) {
            this.filters = new Vector();
        }
        this.filters.addElement(filter);
    }

    private int checkFilters(String className) {
        int restrict = 1;
        if (className.startsWith("java.lang.")) {
            restrict = 2;
        } else if (this.filters != null) {
            int numFilters = this.filters.size();
            for (int idx = 0; idx < numFilters && (restrict = ((ClassFilter)this.filters.elementAt(idx)).loadCheck(className)) == 1; ++idx) {
            }
        }
        if (restrict != 1 && this.loggingEnabled) {
            String msg = "";
            switch (restrict) {
                case 2: {
                    msg = "Filter disallows loading by this classloader: ";
                    break;
                }
                case 3: {
                    msg = "Filter allows loading by this classloader: ";
                    break;
                }
                case 4: {
                    msg = "Filter requires loading by this classloader: ";
                }
            }
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, msg + className);
            }
        }
        return restrict;
    }

    private ClassResource checkForLoadedClass(String className) {
        ClassResource cr = (ClassResource)this.loadedClasses.get(className);
        if (cr != null && this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "loadClass already loaded: " + className);
        }
        return cr;
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.loadClassResource(className, resolve).getClassObj();
    }

    private void logClassLoadFailure(String className, Throwable except) {
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "load of class failed: " + className, except);
        }
    }

    private void logReadFailure(String name, Throwable except) {
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "read of resource failed: " + name, except);
        }
    }

    private ClassResource loadClassResource(String className, boolean resolve) throws ClassNotFoundException {
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "loadClass: " + className);
        }
        try {
            ClassResource cr = this.checkForLoadedClass(className);
            if (cr == null) {
                cr = this.doLoadClass(className);
                if (resolve) {
                    this.resolveClass(cr.getClassObj());
                }
            }
            return cr;
        }
        catch (ClassNotFoundException except) {
            this.logClassLoadFailure(className, except);
            throw except;
        }
        catch (IOException except) {
            this.logClassLoadFailure(className, except);
            throw new ClassNotFoundException(except.getClass().getName() + ": " + except.getMessage());
        }
        catch (RuntimeException except) {
            this.logClassLoadFailure(className, except);
            throw except;
        }
        catch (Error except) {
            this.logClassLoadFailure(className, except);
            throw except;
        }
    }

    public Resource getClassResource(String className) throws ClassNotFoundException {
        ClassResource cr = this.checkForLoadedClass(className);
        if (cr == null) {
            throw new ClassNotFoundException("Class \"" + className + "\" is not loaded by this class loader");
        }
        return cr.getResource();
    }

    private ClassResource loadClassOther(String className, ClassLoader loader, String loaderName) {
        ClassResource cr;
        block6: {
            cr = null;
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "checking " + loaderName + " class loader: " + className);
            }
            try {
                if (loader instanceof MultiClassLoader) {
                    cr = ((MultiClassLoader)loader).loadClassResource(className, false);
                } else {
                    Class<?> c = loader.loadClass(className);
                    cr = new ClassResource(c, null);
                }
                if (this.loggingEnabled) {
                    this.logChannel.write(this.logLevel, "class loaded by: " + loaderName);
                }
            }
            catch (ClassNotFoundException except) {
                if (!this.loggingEnabled) break block6;
                this.logChannel.write(this.logLevel, "class not loaded by " + loaderName + ": " + except.getClass().getName() + ": " + except.getMessage());
            }
        }
        return cr;
    }

    private ClassResource loadClassHere(String className) throws IOException {
        String fileName;
        Resource resource;
        ClassResource cr = null;
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "checking MultiClassLoader: " + className);
        }
        if ((resource = this.getResourceObject(fileName = className.replace('.', '/').concat(".class"))) != null) {
            Class<?> c;
            try {
                c = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                try {
                    c = Class.forName(className, true, ClassLoader.getSystemClassLoader());
                }
                catch (ClassNotFoundException e1) {
                    byte[] classBytes = resource.getBytes();
                    c = this.defineClass(className, classBytes, 0, classBytes.length);
                }
            }
            cr = new ClassResource(c, resource);
            this.loadedClasses.put(className, cr);
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "class loaded by MultiClassLoader: " + className);
            }
        }
        if (cr == null && this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "class not loaded by MultiClassLoader: " + className);
        }
        return cr;
    }

    private synchronized ClassResource doLoadClass(String className) throws ClassNotFoundException, IOException {
        ClassResource cr = this.checkForLoadedClass(className);
        if (cr != null) {
            return cr;
        }
        int filterRestrict = this.checkFilters(className);
        if (this.parentClassLoader != null && filterRestrict != 3 && filterRestrict != 4 && (cr = this.loadClassOther(className, this.parentClassLoader, "parent")) != null) {
            return cr;
        }
        if ((filterRestrict == 1 || filterRestrict == 3 || filterRestrict == 4) && (cr = this.loadClassHere(className)) != null) {
            return cr;
        }
        if (this.secondaryClassLoader != null && filterRestrict != 4 && (cr = this.loadClassOther(className, this.secondaryClassLoader, "secondary")) != null) {
            return cr;
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public URL getResource(String name) {
        Resource resource = this.getResourceObject(name);
        if (resource != null) {
            ClassPathEntry location = resource.getLocation();
            try {
                return new URL(location.getURL() + resource.getName());
            }
            catch (MalformedURLException mue) {
                if (this.loggingEnabled) {
                    this.logChannel.write(this.logLevel, "getResource not returned due to exception: " + name, (Throwable)mue);
                }
                return null;
            }
        }
        return null;
    }

    public Resource getResourceObject(String name) {
        Resource resource;
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "getResource loading: " + name);
        }
        try {
            resource = this.classPath.getResource(name);
            if (this.loggingEnabled) {
                if (resource == null) {
                    this.logChannel.write(this.logLevel, "getResource not found: " + name);
                } else {
                    this.logChannel.write(this.logLevel, "getResource finished: " + name);
                }
            }
        }
        catch (RuntimeException except) {
            this.logReadFailure(name, except);
            throw except;
        }
        catch (Error except) {
            this.logReadFailure(name, except);
            throw except;
        }
        return resource;
    }

    public Resource getResourceAsIs(String name) {
        return this.getResourceObject(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        Resource resource = this.getResourceObject(name);
        if (resource != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException except) {
                this.logReadFailure(name, except);
                return null;
            }
        }
        return null;
    }

    public byte[] getResourceAsByteArray(String name) {
        Resource resource = this.getResourceObject(name);
        if (resource != null) {
            try {
                return resource.getBytes();
            }
            catch (IOException except) {
                this.logReadFailure(name, except);
                return null;
            }
        }
        return null;
    }

    public boolean shouldReload() {
        Enumeration classes = this.loadedClasses.elements();
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "Checking for out-of-date classes");
        }
        while (classes.hasMoreElements()) {
            boolean isModified;
            try {
                isModified = ((ClassResource)classes.nextElement()).getResource().hasBeenModified();
            }
            catch (FileNotFoundException except) {
                if (this.loggingEnabled) {
                    this.logChannel.write(this.logLevel, "File for loaded class can no longer be accessed", (Throwable)except);
                }
                isModified = true;
            }
            if (!isModified) continue;
            if (this.loggingEnabled) {
                this.logChannel.write(this.logLevel, "Loaded classes have been modified");
            }
            return true;
        }
        if (this.loggingEnabled) {
            this.logChannel.write(this.logLevel, "Loaded classes have not been modified");
        }
        return false;
    }

    static {
        try {
            Method getSystemClassLoaderMethod = ClassLoader.class.getMethod("getSystemClassLoader", new Class[0]);
            sysClassLoader = (ClassLoader)getSystemClassLoaderMethod.invoke(ClassLoader.class, new Object[0]);
        }
        catch (NoSuchMethodException var1) {
            sysClassLoader = new SysClassLoader();
        }
        catch (InvocationTargetException var2) {
            throw new FatalExceptionError(var2);
        }
        catch (IllegalAccessException var3) {
            throw new FatalExceptionError(var3);
        }
    }

    public class ClassResource {
        private Class classObj;
        private Resource resource;

        public ClassResource(Class classObj, Resource resource) {
            this.classObj = classObj;
            this.resource = resource;
        }

        public Class getClassObj() {
            return this.classObj;
        }

        public Resource getResource() {
            return this.resource;
        }
    }

    static class SysClassLoader
    extends ClassLoader {
        SysClassLoader() {
        }

        public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
            Class<?> foundClass = this.findSystemClass(className);
            if (resolve) {
                this.resolveClass(foundClass);
            }
            return foundClass;
        }

        @Override
        public URL getResource(String var1) {
            return SysClassLoader.getSystemResource(var1);
        }

        @Override
        public InputStream getResourceAsStream(String var1) {
            return SysClassLoader.getSystemResourceAsStream(var1);
        }
    }

    public static interface ClassFilter {
        public static final int NORMAL_LOAD = 1;
        public static final int DONT_LOAD = 2;
        public static final int CAN_LOAD = 3;
        public static final int MUST_LOAD = 4;

        public int loadCheck(String var1);
    }
}

