
/*
 * @(#)HashMapNode.java 1.36 02/03/21
 *
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package org.enhydra.xml;

import java.util.ArrayList ;
import java.util.HashMap ;

import org.w3c.dom.Node ;



/**
 * @author Tweety
 *
 * A class representing a node in a meta-data tree, which implements
 * the <a HREF="../../../../api/org/w3c/dom/NamedNodeMap.html">
 *
 * @version 1.0
 */
class HashMapNamedNodeMap extends NamedNodeMapImpl {

    
    /**
     * HashMap of <code>Node</code> items.
     */
    HashMap  hNodes;


    /**
     * Constructs a <code>HashMapNamedNodeMap</code> from the given <code>HashMap</code>.
     * 
     * @param nodes, as a <code>HashMap</code>.
     */
    public HashMapNamedNodeMap(HashMap  nodes) {
        super(new ArrayList (nodes.values()));
        this.hNodes = nodes;
    }


    /**
     * Returns the items count.
     * 
     * @return items count.
     */
    public int getLength() {
        return hNodes.size();
    }

    
    /**
     * Returns the <code>Node</code> item with the given name.
     * 
     * @param name <code>Node</code> name.
     * 
     * @return <code>Node</code> item with the given name.
     */
    public Node  getNamedItem(String  name) {
        return (Node ) hNodes.get(name);
    }
    
}
