

/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: ConfigException.java,v 1.1 2005/07/13 11:09:06 slobodan Exp $
 */





package com.lutris.util;

/**
 * Exception class thrown by class <code>Config</code>.  If a syntax
 * error is found in the configuration input stream, or if a component
 * expects a data format for which a configuration element cannot be
 * converted, then this exception is thrown to indicate the error.
 * 
 * @see     Config
 * @version $Revision: 1.1 $
 * @author  John Marco
 * @since   Soda1.0
 */
public class ConfigException extends KeywordValueException {
    /**
     * The <code>reason</code> field may contain this value to indicate
     * that the cause of the current exception is unknown.
     * 
     * @see ConfigException#reason
     */
    public static final int     UNKNOWN = 0;

    /**
     * The <code>reason</code> field may contain this value to indicate
     * that a syntax error in the configuration input file or stream
     * caused this exception.
     * 
     * @see ConfigException#reason
     */
    public static final int     NOT_FOUND = 1;

    /**
     * The <code>reason</code> field may contain this value to indicate
     * that a syntax error in the configuration input file or stream
     * caused this exception.
     * 
     * @see ConfigException#reason
     */
    public static final int     SYNTAX = 2;
    
    /**
     * The <code>reason</code> field may contain this value to indicate
     * that a component expects a different number of elements than
     * are provided in the configuration file for a particular key.
     * 
     * @see ConfigException#reason
     */
    public static final int     COUNT = 3;

    /**
     * The <code>reason</code> field may contain this value to indicate
     * that a configuration element could not be converted from its
     * internal string form to the requested type.
     * 
     * @see ConfigException#reason
     */
    public static final int     FORMAT = 4;

    /**
     * Internal constant to indicate the highest valid <code>reason</code>
     * code.
     * 
     * @see ConfigException#reason
     */
    private static final int    MAX_REASON = 4;
    
    /**
     * Indicates the cause (if known) of the current exception.
     * 
     * @see ConfigException#UNKNOWN
     * @see ConfigException#SYNTAX
     * @see ConfigException#COUNT
     * @see ConfigException#FORMAT
     */
    public int reason;

    /**
     * Creates a new ConfigException object with no informational string
     * and a <code>reason</code> field of <code>UNKNOWN</code>.
     * 
     * @see ConfigException#reason
     */
    public
    ConfigException()
    {
    super("Unknown reason");
    reason = UNKNOWN;
    }

    /**
     * Creates a new ConfigException object with the specified informational
     * string and a <code>reason</code> field of <code>UNKNOWN</code>.
     * 
     * @param s Informational string to store in the exception object.
     * 
     * @see ConfigException#reason
     */
    public
    ConfigException(String  s)
    {
    super(s);
    reason = UNKNOWN;
    }

    /**
     * Constructs a new exception with the specified cause.
     *
     * @param cause The cause (which is saved for later retrieval by the 
     * Throwable.getCause() method). 
     * A null value is permitted, and indicates that the cause is 
     * nonexistent or unknown.
     */
    public ConfigException (Throwable  cause) {
        super (cause);
    }

    /**
     * Constructs a new exception with the specified cause and a detail message.
     *
     * @param msg A detailed message describing the expection.
     * @param cause The cause (which is saved for later retrieval by the 
     * Throwable.getCause() method). 
     * A null value is permitted, and indicates that the cause is 
     * nonexistent or unknown.
     */
    public ConfigException (String  msg, Throwable  cause) {
        super (msg,cause);
    }
    
    /**
     * Creates a new ConfigException object with the specified informational
     * string and the specified <code>reason</code> field.
     * 
     * @param s Informational string to store in the exception object.
     * @param r Reason code to store in the <code>reason</code> field.
     * 
     * @see ConfigException#reason
     */
    public
    ConfigException(int r, String  s)
    {
    super(s);
    if ((r < 0) || (r > MAX_REASON)) reason = UNKNOWN;
    else reason = r;
    }
}
