
package com.lutris.logging;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * Temporary class for maintaing old applications that uses
 * deprecated com.lutris.logging.*
 */
public class LogAdapter implements LogChannel {
    private static Logger logger = null;
    private static final int INT_ERROR = -1;
    public LogAdapter() {}
 
    public LogAdapter(org.apache.log4j.Logger logger) {
        this.logger = logger;
    }

    public void setLogger(org.apache.log4j.Logger log) {
        logger = log;
    }

    public org.apache.log4j.Logger getLogger() {
        return logger;
    }

    public int getLevel(String  level) {
        if (logger != null) {
            if (logger.getLevel() != null) {
                return  logger.getLevel().toInt();
            }
        }
        return INT_ERROR;
    }

    /**
     * Determine if logging is enabled for the specified level.
     */
    public boolean isEnabled(int level) {
        return logger.isEnabledFor(intToLevel(level));
    }

    /**
     * Determine if logging is enabled for the specified level.
     */
    public boolean isEnabled(String  level) {
        return false;
    }

    /**
     * Write a string to the log file.
     */
    public void write(int level, String  msg) {
        Level lev;

        if (logger == null) {
            logger = Logger.getLogger(LogAdapter.class.getName());
        }
        lev = intToLevel(level);
        if (lev == null) {
            lev = Level.INFO;
        }
        logger.log(lev, msg);
    }

    /**
     * Write a string and exception to the log file.
     */
    public void write(int level, String  msg, Throwable  throwable) {
        Level lev;

        if (logger == null) {
            logger = Logger.getLogger(LogAdapter.class.getName());
        }
        lev = intToLevel(level);
        if (lev == null) {
            lev = Level.INFO;
        }
        logger.log(lev, msg, throwable);
    }

    /**
     * Write a string to the log file.
     */
    public void write(String  level, String  msg) {
        Level lev;

        if (logger == null) {
            logger = Logger.getLogger(LogAdapter.class.getName());
        }
        lev = stringToLevel(level);
        if (lev == null) {
            lev = Level.INFO;
        }
        logger.log(lev, msg);
    }

    /**
     * Write a string and exception to the log file.
     */
    public void write(String  level, String  msg, Throwable  throwable) {
        Level lev;

        if (logger == null) {
            logger = Logger.getLogger(LogAdapter.class.getName());
        }
        lev = stringToLevel(level);
        if (lev == null) {
            lev = Level.INFO;
        }
        logger.log(lev, msg);
    }

    private Level intToLevel(int level) {
        Level lev;

        switch (level) {
        case com.lutris.logging.Logger.EMERGENCY: 
        case com.lutris.logging.Logger.ALERT:
            lev = Level.FATAL;
            break;

        case com.lutris.logging.Logger.CRITICAL: 
        case com.lutris.logging.Logger.ERROR:
            lev = Level.ERROR;
            break;

        case com.lutris.logging.Logger.WARNING:
            lev = Level.WARN;
            break;

        case com.lutris.logging.Logger.NOTICE: 
        case com.lutris.logging.Logger.INFO:
            lev = Level.INFO;
            break;

        case com.lutris.logging.Logger.DEBUG: 
        case com.lutris.logging.Logger.DEBUG1: 
        case com.lutris.logging.Logger.DEBUG2: 
        case com.lutris.logging.Logger.DEBUG3: 
        case com.lutris.logging.Logger.DEBUG4: 
        case com.lutris.logging.Logger.DEBUG5: 
        case com.lutris.logging.Logger.DEBUG6: 
        case com.lutris.logging.Logger.DEBUG7: 
        case com.lutris.logging.Logger.DEBUG8: 
        case com.lutris.logging.Logger.DEBUG9: 
        case com.lutris.logging.Logger.DEBUGTMP:
            lev = Level.DEBUG;
            break;

        default:
            lev = null;
        } // end switch (level)
 return lev;
    }

    private Level stringToLevel(String  level) {
        Level lev;

        if (level.equalsIgnoreCase("EMERGENCY")
                || level.equalsIgnoreCase("ALERT")) {
            lev = Level.FATAL;
        } else if (level.equalsIgnoreCase("CRITICAL")
                || level.equalsIgnoreCase("ERROR")) {
            lev = Level.ERROR;
        } else if (level.equalsIgnoreCase("WARNING")) {
            lev = Level.WARN;
        } else if (level.equalsIgnoreCase("NOTICE")
                || level.equalsIgnoreCase("INFO")) {
            lev = Level.INFO;
        } else if (level.equalsIgnoreCase("DEBUG")
                || level.equalsIgnoreCase("DEBUG1")
                || level.equalsIgnoreCase("DEBUG2")
                || level.equalsIgnoreCase("DEBUG3")
                || level.equalsIgnoreCase("DEBUG4")
                || level.equalsIgnoreCase("DEBUG5")
                || level.equalsIgnoreCase("DEBUG6")
                || level.equalsIgnoreCase("DEBUG7")
                || level.equalsIgnoreCase("DEBUG8")
                || level.equalsIgnoreCase("DEBUG9")
                || level.equalsIgnoreCase("DEBUGTMP")) {
            lev = Level.DEBUG;
        } else {// default
            lev = null;
        }
        return lev;
    }
    
    /**
     * Create a LogWrite associated with a particular level.  This
     * is often an easier object to use than a LogChannel if limited
     * levels are needed.
     *
     * @param level Symbolic level that is to be checked.
     * @return A log writer object.
     */
    public LogWriter getLogWriter(String  level) {
        // FIXME: 
 return null;
    }

    /**
     * Create a LogWrite associated with a particular level.  This
     * is often an easier object to use than a LogChannel if limited
     * levels are needed.
     *
     * @param level Numeric level that is to be checked.
     * @return A log writer object.
     */
    public LogWriter getLogWriter(int level) {
        // FIXME: 
 return null;
    }
}

/*
 old log levels:
 "EMERGENCY" =  0
 "ALERT"     =  1
 "CRITICAL"  =  2
 "ERROR"     =  3
 "WARNING"   =  4
 "NOTICE"    =  5
 "INFO"      =  6
 "DEBUG"     =  7
 "DEBUG1"    =  8
 "DEBUG2"    =  9
 "DEBUG3"    = 10
 "DEBUG4"    = 11
 "DEBUG5"    = 12
 "DEBUG6"    = 13
 "DEBUG7"    = 14
 "DEBUG8"    = 15
 "DEBUG9"    = 16
 "DEBUGTMP"  = 17
 */
