

/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: LocalZipResource.java,v 1.2 2005/03/24 10:51:25 slobodan Exp $
 */





package com.lutris.classloader;

// lutris packages
// v. strahinja, 24 sep 2002
import java.io.FileNotFoundException ;
import java.io.IOException ;
import java.io.InputStream ;
import java.util.zip.ZipEntry ;
import java.util.zip.ZipFile ;

import com.lutris.logging.LogChannel;
import com.lutris.util.FatalExceptionError;

/**
 * <P>A <CODE>Resource</CODE> that is an entry in
 * a specified zip file on the local machine.  The zip file is represented by a
 * <CODE>ClassPathEntry</CODE>, and the filename is specified by a String.
 *
 * @author Kristen Pol, Lutris Technologies
 * @version $Revision : 1.1 $
 * @see com.lutris.classloader.ClassPathEntry
 * @see com.lutris.classloader.Resource
 * @see java.util.zip.ZipFile
 * @see java.util.zip.ZipEntry
 */
public class LocalZipResource extends Resource {

    // private data members

    /** The ZipEntry that represents this resource. */
    private ZipEntry  zipEntry = null;

    // constructors

    /**
     * Constructs local zip file resource with specified name and location.
     *
     * @param name The file name of the resource.
     * @param location The location of the resource.
     * @param loadLogChannel The log channel for logging.
     * @exception FileNotFoundException if the desired file does not exist or
     *         does not have read permission.
     * @see Resource
     * @see ClassPathEntry
     */
    protected LocalZipResource(String  name, ClassPathEntry location,
// v. strahinja, 24 sep 2002
 LogChannel loadLogChannel)
//        Logger loadLogger)
 throws FileNotFoundException  {
// v. strahinja, 24 sep 2002
 super(name, location, loadLogChannel);
//    super(name, location, loadLogger);
 ZipFile  zipFile = location.getZipFile();
    if (zipFile == null) {
        throw new FileNotFoundException ( "There is no zip file associated with resource: "
                                             + location);
    }
    try {
        zipEntry = zipFile.getEntry(name);
        if (zipEntry == null) {
        throw new FileNotFoundException ("Entry, " + name
                                                + ", does not exist in zip "
                                                + "file, " + zipFile);
        }
        size = zipEntry.getSize();
        //lastModifiedTime = zipEntry.getTime();
    } catch (IOException  e) {
        throw new FileNotFoundException ("Entry, " + name
                                            + ", does not exist in zip file, "
                                            + zipFile + ", or is " + "corrupt: "
                                            + e.getMessage());
    }
    }

    // public methods

    /**
     * Gets input stream representing resource.
     *
     * @return the input stream that represents the resource.
     * @exception IOException if the input stream can not be constructed.
     * @see InputStream
     */
    public InputStream  getInputStream() throws IOException  {
    ZipFile  zipFile = location.getZipFile();
    if (zipFile == null) {
            throw new FatalExceptionError(new IOException ("Failed to get zip file for location, should not be able to get here without a zip file"));
        }
        return zipFile.getInputStream(zipEntry);
    }

    /**
     * Get current last-modification time of resource.  This is the
     * time on the disk file the resource is associated with.
     *
     * @return the last-modified time of the permanent copy of the resource
     * in milliseconds.
     */
    public long getCurrentLastModifiedTime() throws FileNotFoundException  {
    lastModifiedTime = zipEntry.getTime();
        return lastModifiedTime;
        //return zipEntry.getTime();
    }
}
