/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDocumentFactory {
    private static String[] properties = new String[]{"method", "version", "encoding", "omit-xml-declaration", "standalone", "doctype-public", "doctype-system", "indent", "media-type"};
    private static int METHOD = 0;
    private static int VERSION = 1;
    private static int ENCODING = 2;
    private static int OMIT_XML_DECLARATION = 3;
    private static int STANDALONE = 4;
    private static int DOCTYPE_PUBLIC = 5;
    private static int DOCTYPE_SYSTEM = 6;
    private static int CDATA_SECTION_ELEMENTS = 7;
    private static int INDENT = 8;
    private static int MEDIA_TYPE = 9;
    private String fileName;

    public XMLDocumentFactory() {
    }

    public XMLDocumentFactory(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static Document parse(String fileName) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new UtilErrorHandler());
            Document doc = builder.parse(fileName);
            return doc;
        }
        catch (SAXParseException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Document parse() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new UtilErrorHandler());
            Document doc = builder.parse(this.fileName);
            return doc;
        }
        catch (SAXParseException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void serialize(Node node, String fileName, Properties prop) {
        String out = "<?xml version=\"1.0\"?>";
        File file = new File(fileName);
        if (prop != null) {
            out = "<?xml";
            String str = "";
            for (int i = 0; i < properties.length; ++i) {
                str = (String)prop.get(properties[i]);
                if (str == null) continue;
                out = out + " " + properties[i] + "=\"" + str + "\"";
            }
            out = out + "?>";
        }
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            out = out + node.toString();
            outStream.write(out.getBytes());
            outStream.close();
        }
        catch (Exception e) {
            System.err.println("Error serializing file");
        }
    }

    public void serialize(Node node) {
        File file = new File(this.fileName);
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(node.toString().getBytes());
            outStream.close();
        }
        catch (Exception e) {
            System.err.println("Error serializing file");
        }
    }

    static class UtilErrorHandler
    implements ErrorHandler {
        UtilErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        @Override
        public void error(SAXParseException errorException) throws SAXException {
            throw new SAXException(errorException);
        }

        @Override
        public void warning(SAXParseException warningError) throws SAXException {
            System.err.println("[Validation : Warning] URI = " + warningError.getMessage());
        }
    }
}

