/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.util;

import com.lutris.util.ConfigException;
import com.lutris.util.ConfigFile;
import com.lutris.util.ConfigParserConstants;
import com.lutris.util.ConfigParserTokenManager;
import com.lutris.util.KeywordValueException;
import com.lutris.util.ParseException;
import com.lutris.util.SimpleCharStream;
import com.lutris.util.Token;
import com.lutris.util.TokenMgrError;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import org.enhydra.util.ConfigFileInterface;

public class ConfigParser
implements ConfigParserConstants {
    private String comments = "";
    private ConfigFileInterface configFile = null;
    public ConfigParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[16];
    private static int[] jj_la1_0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static void main(String[] args) throws ParseException, ConfigException {
        ConfigParser parser = new ConfigParser(System.in);
        ConfigFile cf = new ConfigFile();
        parser.process(cf);
        cf.write(System.out);
    }

    public void process(ConfigFileInterface configFile) throws ParseException, ConfigException {
        this.configFile = configFile;
        try {
            try {
                this.ParseConfigFile();
            }
            catch (TokenMgrError e) {
                throw this.generateParseException();
            }
        }
        catch (ParseException e) {
            System.err.println("Syntax error in config file at line " + e.currentToken.next.beginLine + ", column " + e.currentToken.next.beginColumn + ".");
            throw e;
        }
    }

    private static final boolean isodigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return true;
            }
        }
        return false;
    }

    private static final boolean isxdigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return true;
            }
        }
        return false;
    }

    public final void ParseConfigFile() throws ParseException, ConfigException {
        block4: {
            boolean done;
            do {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 0: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block4;
                    }
                }
            } while (!(done = this.ConfigEntry()));
            return;
        }
    }

    public final boolean ConfigEntry() throws ParseException, ConfigException {
        Token comment;
        Object keyword = null;
        Vector vlist = null;
        boolean isArray = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                comment = this.jj_consume_token(5);
                this.comments = this.comments + comment.toString();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                comment = this.jj_consume_token(8);
                this.comments = this.comments + comment.toString();
                break;
            }
            case 6: {
                comment = this.jj_consume_token(6);
                this.comments = this.comments + comment.toString();
                break;
            }
            case 4: {
                Token kw = this.jj_consume_token(4);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                block15 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        isArray = this.arraySpec();
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 5: {
                                this.jj_consume_token(5);
                                break block15;
                            }
                        }
                        this.jj_la1[3] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                    }
                }
                this.jj_consume_token(15);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 10: {
                        vlist = this.ValueList();
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                    }
                }
                this.jj_consume_token(8);
                if (vlist == null) {
                    try {
                        if (isArray) {
                            this.configFile.addEntry(kw.image, new String[0], this.comments);
                        }
                        this.configFile.addEntry(kw.image, "", this.comments);
                    }
                    catch (KeywordValueException e) {
                        throw new ConfigException("Key " + kw.image + " is not valid.");
                    }
                } else {
                    Enumeration en = vlist.elements();
                    String[] values = new String[vlist.size()];
                    int pos = values.length - 1;
                    while (en.hasMoreElements()) {
                        values[pos--] = (String)en.nextElement();
                    }
                    try {
                        if (isArray) {
                            this.configFile.addEntry(kw.image, values, this.comments);
                        } else {
                            if (values.length != 1) {
                                throw new ConfigException("Key " + kw.image + " is not a list.  Use " + kw.image + "[]");
                            }
                            this.configFile.addEntry(kw.image, values[0], this.comments);
                        }
                    }
                    catch (KeywordValueException e) {
                        throw new ConfigException("Key " + kw.image + " is not valid.");
                    }
                }
                this.comments = "";
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                try {
                    this.configFile.addEntry("ConfigFileTrailingComment", (String[])null, this.comments);
                }
                catch (KeywordValueException e) {
                    System.err.println("ConfigFile unable to add entry for ConfigFileTrailingComment.");
                }
                this.comments = "";
                return true;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return false;
    }

    public final Vector ValueList() throws ParseException {
        String sval = null;
        Vector vlist = null;
        sval = this.Value();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                    }
                }
                vlist = this.ValueList();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        if (vlist == null) {
            vlist = new Vector();
            vlist.addElement(sval);
        } else {
            vlist.addElement(sval);
        }
        return vlist;
    }

    public final String Value() throws ParseException {
        String lhs = "";
        String rhs = "";
        lhs = this.ValueFragment();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                this.jj_consume_token(12);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                    }
                }
                rhs = this.Value();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        return lhs + rhs;
    }

    public final String ValueFragment() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                String sval = this.QuotedString();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                return sval;
            }
            case 10: {
                Token val = this.jj_consume_token(10);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                return val.image;
            }
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final boolean arraySpec() throws ParseException {
        String lhs = "";
        String rhs = "";
        this.jj_consume_token(1);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        this.jj_consume_token(2);
        return true;
    }

    public final String QuotedString() throws ParseException {
        Token qs = this.jj_consume_token(9);
        StringBuffer sbuf = new StringBuffer();
        char[] cbuf = qs.image.toCharArray();
        block18: for (int i = 1; i < cbuf.length - 1; ++i) {
            switch (cbuf[i]) {
                case '\\': {
                    int val;
                    String s;
                    switch (cbuf[i + 1]) {
                        case 'n': {
                            sbuf.append("\n");
                            ++i;
                            continue block18;
                        }
                        case 't': {
                            sbuf.append("\t");
                            ++i;
                            continue block18;
                        }
                        case 'b': {
                            sbuf.append("\b");
                            ++i;
                            continue block18;
                        }
                        case 'r': {
                            sbuf.append("\r");
                            ++i;
                            continue block18;
                        }
                        case 'f': {
                            sbuf.append("\f");
                            ++i;
                            continue block18;
                        }
                        case 'u': {
                            if (cbuf.length - i >= 6 && ConfigParser.isxdigit(cbuf[i + 2]) && ConfigParser.isxdigit(cbuf[i + 3]) && ConfigParser.isxdigit(cbuf[i + 4]) && ConfigParser.isxdigit(cbuf[i + 5])) {
                                try {
                                    s = new String(cbuf, i + 2, 4);
                                    val = Integer.parseInt(s, 16);
                                    sbuf.append((char)val);
                                    i += 5;
                                }
                                catch (Throwable t) {
                                    sbuf.append(cbuf[i + 1]);
                                    ++i;
                                }
                                continue block18;
                            }
                            sbuf.append(cbuf[i + 1]);
                            ++i;
                            continue block18;
                        }
                        case 'x': {
                            if (cbuf.length - i >= 4 && ConfigParser.isxdigit(cbuf[i + 2]) && ConfigParser.isxdigit(cbuf[i + 3])) {
                                try {
                                    s = new String(cbuf, i + 2, 2);
                                    val = Integer.parseInt(s, 16);
                                    sbuf.append((char)val);
                                    i += 3;
                                }
                                catch (Throwable t) {
                                    sbuf.append(cbuf[i + 1]);
                                    ++i;
                                }
                                continue block18;
                            }
                            sbuf.append(cbuf[i + 1]);
                            ++i;
                            continue block18;
                        }
                    }
                    if (cbuf.length - i >= 4 && ConfigParser.isodigit(cbuf[i + 1]) && ConfigParser.isodigit(cbuf[i + 2]) && ConfigParser.isodigit(cbuf[i + 3])) {
                        try {
                            s = new String(cbuf, i + 1, 3);
                            val = Integer.parseInt(s, 8);
                            sbuf.append((char)val);
                            i += 3;
                        }
                        catch (Throwable t) {
                            sbuf.append(cbuf[i + 1]);
                            ++i;
                        }
                        continue block18;
                    }
                    sbuf.append(cbuf[i + 1]);
                    ++i;
                    continue block18;
                }
                default: {
                    sbuf.append(cbuf[i]);
                }
            }
        }
        return sbuf.toString();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{369, 32, 32, 32, 2, 32, 1536, 337, 32, 8192, 32, 4096, 32, 32, 1536, 32};
    }

    public ConfigParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ConfigParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConfigParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ConfigParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public ConfigParser(ConfigParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ConfigParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 16; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[16];
        for (i = 0; i < 16; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 16; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 16; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, ConfigParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        ConfigParser.jj_la1_0();
    }
}

