/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.util;

import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import com.lutris.util.ConfigParser;
import com.lutris.util.KeywordValueException;
import com.lutris.util.KeywordValueTable;
import com.lutris.util.ParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import org.enhydra.util.ConfigFileInterface;

public class ConfigFile
implements ConfigFileInterface {
    private Config config;
    private Vector order;
    private Hashtable comments;
    private File file = null;
    public static final String TRAILING_COMMENT = "ConfigFileTrailingComment";
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public ConfigFile() {
        this.config = new Config();
        this.order = new Vector();
        this.comments = new Hashtable();
    }

    public ConfigFile(InputStream inputStream) throws ConfigException {
        this.config = new Config();
        this.order = new Vector();
        this.comments = new Hashtable();
        ConfigParser configParser = new ConfigParser(inputStream);
        try {
            configParser.process(this);
        }
        catch (ParseException var4) {
            throw new ConfigException(2, var4.getMessage());
        }
    }

    public ConfigFile(File file) throws ConfigException, IOException {
        this(new FileInputStream(file));
        this.file = file;
        this.config.setConfigFile(this);
    }

    public ConfigFile(KeywordValueTable kvt) throws ConfigException {
        this.config = new Config(kvt);
        this.order = new Vector();
        this.comments = new Hashtable();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public String getComment(String key) {
        return (String)this.comments.get(key);
    }

    @Override
    public void addEntry(String key, String[] values, String comment) throws KeywordValueException {
        if (!key.equals(TRAILING_COMMENT)) {
            this.config.set(key, values);
            if (!this.order.contains(key)) {
                this.order.addElement(key);
            }
        }
        this.comments.put(key, comment);
    }

    @Override
    public void addEntry(String kkey, String value, String comment) throws KeywordValueException {
        if (!kkey.equals(TRAILING_COMMENT)) {
            this.config.set(kkey, value);
            if (!this.order.contains(kkey)) {
                this.order.addElement(kkey);
            }
        }
        this.comments.put(kkey, comment);
    }

    @Override
    public void removeEntry(String key) throws KeywordValueException {
        if (!key.equals(TRAILING_COMMENT)) {
            this.config.remove(key);
            this.order.removeElement(key);
        }
        this.comments.remove(key);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void write() throws IOException, FileNotFoundException {
        if (this.file == null) {
            throw new FileNotFoundException("No file associated with this object");
        }
        FileOutputStream out = new FileOutputStream(this.file);
        this.write(out);
        out.close();
    }

    @Override
    public void write(OutputStream outputStream) {
        String[] values;
        String comment;
        String key;
        int i;
        PrintWriter out = new PrintWriter(outputStream, true);
        boolean isArray = false;
        Hashtable<String, String> remaining = new Hashtable<String, String>();
        String[] remainingkeys = this.config.leafKeys();
        for (i = 0; i < remainingkeys.length; ++i) {
            remaining.put(remainingkeys[i], "X");
        }
        for (i = 0; i < this.order.size(); ++i) {
            key = (String)this.order.elementAt(i);
            comment = (String)this.comments.get(key);
            isArray = false;
            try {
                Object o = this.config.get(key);
                if (o == null) continue;
                isArray = o.getClass().isArray();
                if (isArray) {
                    Object[] oa = (Object[])o;
                    if (oa.length > 0 && oa[0] instanceof String) {
                        values = (String[])o;
                    } else {
                        values = new String[oa.length];
                        for (int k = 0; k < oa.length; ++k) {
                            values[k] = oa[k].toString();
                        }
                    }
                } else {
                    values = new String[1];
                    values[0] = o instanceof String ? (String)o : o.toString();
                }
            }
            catch (KeywordValueException e) {
                values = null;
            }
            if (values == null || values.length == 0) {
                if (comment != null && !comment.equals("")) {
                    if (comment.endsWith("\n")) {
                        out.print(comment);
                    } else {
                        out.println(comment);
                    }
                }
                out.print(key);
                if (isArray) {
                    out.print("[]");
                }
                out.println(" =");
            } else {
                if (comment != null && !comment.equals("")) {
                    if (comment.endsWith("\n")) {
                        out.print(comment);
                    } else {
                        out.println(comment);
                    }
                }
                if (isArray) {
                    out.print(key + "[] = " + ConfigFile.quoteStr(values[0]));
                } else {
                    out.print(key + " = " + ConfigFile.quoteStr(values[0]));
                }
                for (int j = 1; j < values.length; ++j) {
                    out.print(", " + ConfigFile.quoteStr(values[j]));
                }
                out.println();
            }
            remaining.remove(key);
        }
        comment = (String)this.comments.get(TRAILING_COMMENT);
        if (comment != null && !comment.equals("")) {
            if (comment.endsWith("\n")) {
                out.print(comment);
            } else {
                out.println(comment);
            }
        }
        remaining.remove(TRAILING_COMMENT);
        i = 0;
        String lastWord = "";
        while (i != remainingkeys.length) {
            int dot;
            key = remainingkeys[i];
            ++i;
            if (remaining.get(key) == null) continue;
            isArray = false;
            if (!key.startsWith(lastWord)) {
                out.println("");
            }
            if ((dot = key.indexOf(46)) == -1) {
                dot = key.length();
            }
            lastWord = key.substring(0, dot);
            try {
                Object o = this.config.get(key);
                if (o == null) continue;
                isArray = o.getClass().isArray();
                if (isArray) {
                    Object[] oa = (Object[])o;
                    if (oa[0] instanceof String) {
                        values = (String[])o;
                    } else {
                        values = new String[oa.length];
                        for (int k = 0; k < oa.length; ++k) {
                            values[k] = oa[k].toString();
                        }
                    }
                } else {
                    values = new String[1];
                    values[0] = o instanceof String ? (String)o : o.toString();
                }
            }
            catch (KeywordValueException e) {
                values = null;
            }
            if (values == null || values.length == 0) {
                out.println(key + " =");
                continue;
            }
            if (isArray) {
                out.print(key + "[] = " + ConfigFile.quoteStr(values[0]));
            } else {
                out.print(key + " = " + ConfigFile.quoteStr(values[0]));
            }
            for (int j = 1; j < values.length; ++j) {
                out.print(", " + ConfigFile.quoteStr(values[j]));
            }
            out.println();
        }
    }

    private boolean containsWhiteSpace(String str) {
        if (str.indexOf(" ") != -1) {
            return true;
        }
        return str.indexOf("\t") != -1;
    }

    private static final String quoteStr(String s) {
        if (s == null || s.length() < 1) {
            return "";
        }
        char[] chars = s.toCharArray();
        StringBuffer sb = new StringBuffer();
        boolean needQuotes = false;
        block9: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\n': {
                    needQuotes = true;
                    sb.append("\\n");
                    continue block9;
                }
                case '\b': {
                    needQuotes = true;
                    sb.append("\\b");
                    continue block9;
                }
                case '\r': {
                    needQuotes = true;
                    sb.append("\\r");
                    continue block9;
                }
                case '\f': {
                    needQuotes = true;
                    sb.append("\\f");
                    continue block9;
                }
                case '\"': {
                    needQuotes = true;
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    needQuotes = true;
                    sb.append("\\\\");
                    continue block9;
                }
                case '\t': 
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    needQuotes = true;
                    sb.append(chars[i]);
                    continue block9;
                }
                default: {
                    char ival;
                    if (chars[i] < ' ' || chars[i] == '\u007f') {
                        needQuotes = true;
                        ival = chars[i];
                        sb.append('\\');
                        sb.append(digits[(ival & 0xC0) >> 6]);
                        sb.append(digits[(ival & 0x38) >> 3]);
                        sb.append(digits[ival & 7]);
                        continue block9;
                    }
                    if (chars[i] > '\u007f') {
                        needQuotes = true;
                        ival = chars[i];
                        sb.append("\\u");
                        sb.append(digits[(ival & 0xF000) >> 12]);
                        sb.append(digits[(ival & 0xF00) >> 8]);
                        sb.append(digits[(ival & 0xF0) >> 4]);
                        sb.append(digits[ival & 0xF]);
                        continue block9;
                    }
                    sb.append(chars[i]);
                }
            }
        }
        if (needQuotes) {
            return "\"" + sb.toString() + "\"";
        }
        return sb.toString();
    }
}

