/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.util;

import com.lutris.util.ConfigException;
import com.lutris.util.FatalExceptionError;
import com.lutris.util.KeywordValueException;
import com.lutris.util.KeywordValueTable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.enhydra.util.ConfigFileInterface;

public class Config
extends KeywordValueTable {
    private static final int GET_ALL = -1;
    private ConfigFileInterface configFile = null;

    public Config() {
    }

    public Config(KeywordValueTable kvt) {
        String[] keys = kvt.keys();
        for (int i = 0; i < keys.length; ++i) {
            try {
                this.set(keys[i], kvt.get(keys[i]));
                continue;
            }
            catch (KeywordValueException e) {
                throw new FatalExceptionError(e);
            }
        }
    }

    public Config(KeywordValueTable kvt, ConfigFileInterface configFile) {
        this(kvt);
        this.configFile = configFile;
    }

    public Config(ConfigFileInterface configFile) {
        this();
        this.configFile = configFile;
    }

    public Config getClonedConfig() throws KeywordValueException {
        Config returnConfig = this.getClonedConfigParams();
        ConfigFileInterface cf = null;
        Class<?> classObj = this.getConfigFile().getClass();
        String className = classObj.getName();
        Class[] classParam = new Class[1];
        Constructor<?> constr = null;
        Object[] arguments = new Object[1];
        try {
            classParam[0] = Class.forName("com.lutris.util.Config");
            constr = classObj.getConstructor(classParam);
            arguments[0] = this;
            cf = (ConfigFileInterface)constr.newInstance(arguments);
            cf.setFile(this.getConfigFile().getFile());
            returnConfig.setConfigFile(cf);
        }
        catch (Exception ex) {
            returnConfig.setConfigFile(cf);
        }
        return returnConfig;
    }

    private Config getClonedConfigParams() throws KeywordValueException {
        Config returnConfig = new Config();
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            Object tempValue = this.get(keys[i]);
            if (tempValue instanceof String) {
                returnConfig.set(new String(keys[i]), new String((String)tempValue));
                continue;
            }
            if (tempValue instanceof KeywordValueTable) {
                Config kvtTempConfig = new Config((KeywordValueTable)tempValue).getClonedConfigParams();
                returnConfig.set(new String(keys[i]), kvtTempConfig);
                continue;
            }
            if (tempValue instanceof Config) {
                Config tempConfig = ((Config)tempValue).getClonedConfigParams();
                returnConfig.set(new String(keys[i]), tempConfig);
                continue;
            }
            if (!tempValue.getClass().isArray()) continue;
            int len = Array.getLength(tempValue);
            String[] newTemp = new String[len];
            for (int k = 0; k < len; ++k) {
                newTemp[k] = new String(Array.get(tempValue, k).toString());
            }
            returnConfig.set(new String(keys[i]), newTemp);
        }
        return returnConfig;
    }

    public Hashtable allConfigParams(String prefix) throws KeywordValueException {
        String[] keys = this.keys();
        Hashtable<String, String> ht = new Hashtable<String, String>();
        for (int i = 0; i < keys.length; ++i) {
            Object tempValue = this.get(keys[i]);
            String name = prefix != null && prefix.length() > 0 ? prefix + "__" + keys[i] : keys[i];
            if (tempValue instanceof String) {
                ht.put(name, (String)tempValue);
                continue;
            }
            if (tempValue instanceof KeywordValueTable) {
                ht.putAll(((Config)tempValue).allConfigParams(name));
                continue;
            }
            if (tempValue instanceof Config) {
                ht.putAll(((Config)tempValue).allConfigParams(name));
                continue;
            }
            if (!tempValue.getClass().isArray()) continue;
            int len = Array.getLength(tempValue);
            for (int k = 0; k < len; ++k) {
                ht.put(name + "__" + k, Array.get(tempValue, k).toString());
            }
        }
        return ht;
    }

    public void importConfig(Config config) throws KeywordValueException {
        int i;
        String[] original = this.keys();
        String[] in = config.keys();
        for (i = 0; i < in.length; ++i) {
            this.set(in[i], config.get(in[i]));
        }
        for (i = 0; i < original.length; ++i) {
            if (config.containsKey(original[i])) continue;
            this.remove(in[i]);
        }
    }

    @Override
    protected KeywordValueTable newSection() {
        return new Config(this.configFile);
    }

    public ConfigFileInterface getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(ConfigFileInterface configFile) {
        this.configFile = configFile;
    }

    public synchronized Config getConfig(String keyword) throws KeywordValueException {
        return (Config)this.getSection(keyword);
    }

    @Override
    public synchronized KeywordValueTable getSection(String keyword) throws KeywordValueException {
        KeywordValueTable kvt = super.getSection(keyword);
        if (kvt == null) {
            return null;
        }
        if (kvt instanceof Config) {
            return kvt;
        }
        return new Config(kvt, this.configFile);
    }

    @Override
    public boolean containsKey(String key) {
        boolean result = false;
        try {
            result = super.containsKey(key);
        }
        catch (KeywordValueException e) {
            result = false;
        }
        return result;
    }

    public int containsCount(String key) throws ConfigException {
        Object valObj = null;
        try {
            valObj = this.get(key);
            if (valObj == null) {
                return -1;
            }
            return Array.getLength(valObj);
        }
        catch (KeywordValueException e) {
            throw new ConfigException(e.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (valObj == null) {
                return -1;
            }
            return 1;
        }
    }

    public boolean isArray(String key) throws ConfigException {
        Object valObj = null;
        try {
            valObj = this.get(key);
            if (valObj == null) {
                throw new ConfigException("Key \"" + key + "\" not found.");
            }
            Array.getLength(valObj);
            return true;
        }
        catch (KeywordValueException e) {
            throw new ConfigException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private final long[] getLongsInternal(String key, int count) throws ConfigException {
        Object obj;
        try {
            obj = this.get(key);
        }
        catch (KeywordValueException e) {
            throw new ConfigException(e.getMessage());
        }
        if (obj == null) {
            throw new ConfigException(1, "Key \"" + key + "\" not found in configuration.");
        }
        long[] la = null;
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            la = new long[len];
            for (int i = 0; i < len; ++i) {
                try {
                    la[i] = Long.parseLong(Array.get(obj, i).toString());
                    continue;
                }
                catch (Throwable e) {
                    throw new ConfigException("Element " + i + " is not a long.");
                }
            }
        } else {
            la = new long[1];
            try {
                la[0] = Long.parseLong(obj.toString());
            }
            catch (Throwable e) {
                throw new ConfigException("Element 0 is not a long.");
            }
        }
        if (count != -1 && la.length != count) {
            throw new ConfigException(3, "Key \"" + key + "\" has " + la.length + " elements. (expected " + count + ")");
        }
        return la;
    }

    public long getLong(String key) throws ConfigException {
        return this.getLongsInternal(key, 1)[0];
    }

    public long getLong(String key, long defaultValue) throws ConfigException {
        try {
            return this.getLongsInternal(key, 1)[0];
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }

    public long[] getLongs(String key) throws ConfigException {
        return this.getLongsInternal(key, -1);
    }

    public long[] getLongs(String key, long[] defaultValue) throws ConfigException {
        try {
            return this.getLongsInternal(key, -1);
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }

    private final int[] getIntsInternal(String key, int count) throws ConfigException {
        Object obj;
        try {
            obj = this.get(key);
        }
        catch (KeywordValueException e) {
            throw new ConfigException(e.getMessage());
        }
        if (obj == null) {
            throw new ConfigException(1, "Key \"" + key + "\" not found in configuration.");
        }
        int[] ia = null;
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            ia = new int[len];
            for (int i = 0; i < len; ++i) {
                try {
                    ia[i] = Integer.parseInt(Array.get(obj, i).toString());
                    continue;
                }
                catch (Throwable e) {
                    throw new ConfigException("Element " + i + " is not an integer.");
                }
            }
        } else {
            ia = new int[1];
            try {
                ia[0] = Integer.parseInt(obj.toString());
            }
            catch (Throwable e) {
                throw new ConfigException("Element 0 is not an integer.");
            }
        }
        if (count != -1 && ia.length != count) {
            throw new ConfigException(3, "Key \"" + key + "\" has " + ia.length + " elements. (expected " + count + ")");
        }
        return ia;
    }

    public int getInt(String key) throws ConfigException {
        return this.getIntsInternal(key, 1)[0];
    }

    public int getInt(String key, int defaultValue) throws ConfigException {
        try {
            return this.getIntsInternal(key, 1)[0];
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }

    public int[] getInts(String key) throws ConfigException {
        return this.getIntsInternal(key, -1);
    }

    public int[] getInts(String key, int[] defaultValue) throws ConfigException {
        try {
            return this.getIntsInternal(key, -1);
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }

    private final String[] getStringsInternal(String key, int count) throws ConfigException {
        Object obj;
        try {
            obj = this.get(key);
        }
        catch (KeywordValueException e) {
            throw new ConfigException(e.getMessage());
        }
        if (obj == null) {
            throw new ConfigException(1, "Key \"" + key + "\" not found in configuration.");
        }
        String[] sa = null;
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            sa = new String[len];
            for (int i = 0; i < len; ++i) {
                try {
                    sa[i] = Array.get(obj, i).toString();
                    continue;
                }
                catch (Throwable e) {
                    throw new ConfigException("Element " + i + " is not a String.");
                }
            }
        } else {
            sa = new String[1];
            try {
                sa[0] = obj.toString();
            }
            catch (Throwable e) {
                throw new ConfigException("Element 0 is not a String.");
            }
        }
        if (count != -1 && sa.length != count) {
            throw new ConfigException(3, "Key \"" + key + "\" has " + sa.length + " elements. (expected " + count + ")");
        }
        return sa;
    }

    @Override
    public String getString(String key) throws ConfigException {
        return this.getStringsInternal(key, 1)[0];
    }

    @Override
    public String getString(String key, String defaultValue) throws ConfigException {
        try {
            return this.getStringsInternal(key, 1)[0];
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }

    public String[] getStrings(String key) throws ConfigException {
        return this.getStringsInternal(key, -1);
    }

    public String[] getStrings(String key, String[] defaultValue) throws ConfigException {
        try {
            return this.getStringsInternal(key, -1);
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }

    private final boolean[] getBooleansInternal(String key, int count) throws ConfigException {
        Object obj;
        try {
            obj = this.get(key);
        }
        catch (KeywordValueException e) {
            throw new ConfigException(e.getMessage());
        }
        if (obj == null) {
            throw new ConfigException(1, "Key \"" + key + "\" not found in configuration.");
        }
        boolean[] ba = null;
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            ba = new boolean[len];
            for (int i = 0; i < len; ++i) {
                try {
                    ba[i] = Boolean.valueOf(Array.get(obj, i).toString().toLowerCase());
                    continue;
                }
                catch (Throwable e) {
                    throw new ConfigException("Element " + i + " is not a boolean.");
                }
            }
        } else {
            ba = new boolean[1];
            try {
                ba[0] = Boolean.valueOf(obj.toString().toLowerCase());
            }
            catch (Throwable e) {
                throw new ConfigException("Element 0 is not a boolean.");
            }
        }
        if (count != -1 && ba.length != count) {
            throw new ConfigException(3, "Key \"" + key + "\" has " + ba.length + " elements. (expected " + count + ")");
        }
        return ba;
    }

    public boolean getBoolean(String key) throws ConfigException {
        return this.getBooleansInternal(key, 1)[0];
    }

    public boolean getBoolean(String key, boolean defaultValue) throws ConfigException {
        try {
            return this.getBooleansInternal(key, 1)[0];
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }

    public boolean[] getBooleans(String key) throws ConfigException {
        return this.getBooleansInternal(key, -1);
    }

    public boolean[] getBooleans(String key, boolean[] defaultValue) throws ConfigException {
        try {
            return this.getBooleansInternal(key, -1);
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }

    private final double[] getDoublesInternal(String key, int count) throws ConfigException {
        Object obj;
        try {
            obj = this.get(key);
        }
        catch (KeywordValueException e) {
            throw new ConfigException(e.getMessage());
        }
        if (obj == null) {
            throw new ConfigException(1, "Key \"" + key + "\" not found in configuration.");
        }
        double[] da = null;
        if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            da = new double[len];
            for (int i = 0; i < len; ++i) {
                try {
                    da[i] = Double.valueOf(Array.get(obj, i).toString());
                    continue;
                }
                catch (Throwable e) {
                    throw new ConfigException("Element " + i + " is not a double.");
                }
            }
        } else {
            da = new double[1];
            try {
                da[0] = Double.valueOf(obj.toString());
            }
            catch (Throwable e) {
                throw new ConfigException("Element 0 is not a long.");
            }
        }
        if (count != -1 && da.length != count) {
            throw new ConfigException(3, "Key \"" + key + "\" has " + da.length + " elements. (expected " + count + ")");
        }
        return da;
    }

    public double getDouble(String key) throws ConfigException {
        return this.getDoublesInternal(key, 1)[0];
    }

    public double getDouble(String key, double defaultValue) throws ConfigException {
        try {
            return this.getDoublesInternal(key, 1)[0];
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }

    public double[] getDoubles(String key) throws ConfigException {
        return this.getDoublesInternal(key, -1);
    }

    public double[] getDoubles(String key, double[] defaultValue) throws ConfigException {
        try {
            return this.getDoublesInternal(key, -1);
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }

    public Object getDataSource(String key) throws ConfigException {
        Object obj;
        try {
            obj = this.get(key);
        }
        catch (KeywordValueException e) {
            throw new ConfigException(e.getMessage());
        }
        if (obj == null) {
            throw new ConfigException(1, "Key \"" + key + "\" not found in configuration.");
        }
        Object ds = null;
        if (obj.getClass().isArray()) {
            throw new ConfigException("The value is an array. The method returns a single DataStruct Object.");
        }
        try {
            ds = obj;
        }
        catch (Throwable e) {
            throw new ConfigException("Element is not a DataSource.");
        }
        return ds;
    }

    public Object getDataSource(String key, Object defaultValue) throws ConfigException {
        try {
            return this.getDataSource(key);
        }
        catch (ConfigException e) {
            if (e.reason != 1) {
                throw e;
            }
            return defaultValue;
        }
    }
}

